/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.config.jwt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.MACVerifier;
import com.ohaotian.authority.config.jwt.JwtProperties;
import com.ohaotian.authority.config.jwt.JwtResult;
import com.ohaotian.authority.config.jwt.JwtTokenHolder;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.util.RegexUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.minidev.json.JSONObject;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class JwtFilter
implements Filter {
    private static final Logger logger = LogManager.getLogger(JwtFilter.class);
    private JwtProperties jwtProperties;

    public JwtFilter(JwtProperties jwtProperties) {
        this.jwtProperties = jwtProperties;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.isStaticResources(request)) {
            logger.info("\u767d\u540d\u5355\u653e\u884c");
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            String token = this.getToken(request);
            logger.info("\u8bf7\u6c42token: " + token);
            TokenResult tokenResult = this.validToken(token);
            Integer state = tokenResult.getStatus();
            if (state == 0) {
                JSONObject data = tokenResult.getData();
                String userId = String.valueOf(data.get((Object)"userId") + "");
                UserHolder.setUserId(userId);
                filterChain.doFilter(servletRequest, servletResponse);
            } else {
                this.doErrorReturn(request, response, state);
            }
        }
    }

    private TokenResult validToken(String token) {
        TokenResult tokenResult = new TokenResult();
        if (token == null) {
            tokenResult.setStatus(2);
            return tokenResult;
        }
        HashMap<String, String> myHeader = new HashMap<String, String>();
        myHeader.put("auth-token", token);
        com.alibaba.fastjson.JSONObject tokenJsonObj = new com.alibaba.fastjson.JSONObject();
        tokenJsonObj.put("token", (Object)token);
        String tokenJson = JSON.toJSONString((Object)tokenJsonObj);
        if (!this.isTimeValid(myHeader, tokenJson)) {
            logger.error("token\u5df2\u8fc7\u671f");
            tokenResult.setStatus(1);
            return tokenResult;
        }
        if (!this.updateTimeValid(myHeader, tokenJson)) {
            logger.error("\u66f4\u65b0token\u8fc7\u671f\u65f6\u95f4\u5931\u8d25");
            tokenResult.setStatus(1);
            return tokenResult;
        }
        try {
            JWSObject jwsObject = JWSObject.parse((String)token);
            MACVerifier verifier = new MACVerifier(this.jwtProperties.getSecret().getBytes());
            if (jwsObject.verify((JWSVerifier)verifier)) {
                Payload payload = jwsObject.getPayload();
                JSONObject jsonOBj = payload.toJSONObject();
                tokenResult.setStatus(0);
                tokenResult.setData(jsonOBj);
                tokenResult.setToken(token);
                JwtTokenHolder.setToken(token);
                logger.info("token\u9a8c\u8bc1\u5b8c\u6210");
                return tokenResult;
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790token\u5f02\u5e38", (Throwable)e);
        }
        tokenResult.setStatus(2);
        return tokenResult;
    }

    private boolean updateTimeValid(Map<String, String> myHeader, String tokenJson) {
        try {
            JwtResult reqBO;
            HttpResult httpResult = this.doPostJson(HttpClientBuilder.create().build(), this.jwtProperties.getUpdateOverTimeUrl(), myHeader, tokenJson, Integer.valueOf(this.jwtProperties.socketTimeout));
            if (httpResult.getStatusCode() == 200 && (reqBO = (JwtResult)JSON.parseObject((String)httpResult.getResString(), JwtResult.class)).getCode().equals("0")) {
                return true;
            }
        }
        catch (IOException e) {
            logger.error("\u66f4\u65b0token\u8fc7\u671f\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    private boolean isTimeValid(Map<String, String> myHeader, String tokenJson) {
        try {
            logger.info("httpUrl:" + this.jwtProperties.getOverTimeUrl());
            HttpResult httpResult = this.doPostJson(HttpClientBuilder.create().build(), this.jwtProperties.getOverTimeUrl(), myHeader, tokenJson, Integer.valueOf(this.jwtProperties.socketTimeout));
            logger.info("httpStatus:" + httpResult.getStatusCode());
            logger.info("httpResult:" + httpResult.toString());
            if (httpResult.getStatusCode() == 200) {
                long curTime;
                JwtResult reqBO = (JwtResult)JSON.parseObject((String)httpResult.getResString(), JwtResult.class);
                logger.info("reqBO:" + reqBO.toString());
                if (reqBO.getCode().equals("0") && (curTime = System.currentTimeMillis()) <= Long.parseLong(reqBO.getData().getExpTime())) {
                    return true;
                }
            }
        }
        catch (IOException e) {
            logger.error("\u67e5\u8be2token\u8fc7\u671f\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    private boolean isStaticResources(HttpServletRequest request) {
        String url = request.getRequestURI();
        if (!StringUtils.isEmpty((Object)this.jwtProperties.getStaticResources())) {
            String[] split;
            for (String staticResource : split = this.jwtProperties.getStaticResources().split(";")) {
                if (!RegexUtil.wildcardEquals(staticResource, url)) continue;
                return true;
            }
        }
        return false;
    }

    private void doErrorReturn(HttpServletRequest request, HttpServletResponse response, Integer state) throws IOException, ServletException {
        if (!StringUtils.isEmpty((Object)request.getHeader("x-requested-with")) && request.getHeader("x-requested-with").equalsIgnoreCase("XMLHttpRequest")) {
            com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
            jsonObject.put("code", (Object)1);
            if (state == 1) {
                jsonObject.put("message", (Object)"\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            } else {
                jsonObject.put("message", (Object)"\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            }
            response.setStatus(401);
            response.setContentType("application/json;charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.write(JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty}));
            out.flush();
            out.close();
        } else {
            response.sendRedirect(this.jwtProperties.getRedirectUrl());
        }
    }

    private String getToken(HttpServletRequest request) {
        Cookie[] cookies;
        String token = request.getHeader(this.jwtProperties.getHeadTokenKey());
        if (StringUtils.isEmpty((Object)token) && (cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(this.jwtProperties.getHeadTokenKey())) continue;
                return cookie.getValue();
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResult doPostJson(CloseableHttpClient httpClient, String url, Map<String, String> myHeader, String jsonStr, Integer overtime) throws IOException {
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url.trim());
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Integer.valueOf(this.jwtProperties.connectTimeout).intValue()).setConnectionRequestTimeout(Integer.valueOf(this.jwtProperties.connectionRequestTimeout).intValue()).setSocketTimeout(Integer.valueOf(this.jwtProperties.socketTimeout).intValue()).setRedirectsEnabled(true).build();
            httpPost.setConfig(requestConfig);
            StringEntity entity = new StringEntity(jsonStr, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            if (myHeader != null) {
                myHeader.forEach((k, v) -> {
                    if (!k.equalsIgnoreCase("Content-Type")) {
                        httpPost.setHeader(k, v);
                    }
                });
            }
            httpPost.setHeader("Content-Type", "application/json;charset=utf8");
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpResult myHttpResult = new HttpResult();
            myHttpResult.setStatusCode(response.getStatusLine().getStatusCode());
            myHttpResult.setResString(EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8));
            HashMap headersMap = new HashMap();
            Arrays.asList(response.getAllHeaders()).stream().forEach(h -> headersMap.put(h.getName(), h.getValue()));
            myHttpResult.setHeaderMap(headersMap);
            HttpResult httpResult = myHttpResult;
            return httpResult;
        }
        finally {
            if (httpClient != null) {
                httpClient.close();
            }
            if (response != null) {
                response.close();
            }
        }
    }

    private class HttpResult
    implements Serializable {
        private Integer statusCode;
        private Map headerMap;
        private String resString;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public Map getHeaderMap() {
            return this.headerMap;
        }

        public String getResString() {
            return this.resString;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public void setHeaderMap(Map headerMap) {
            this.headerMap = headerMap;
        }

        public void setResString(String resString) {
            this.resString = resString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpResult)) {
                return false;
            }
            HttpResult other = (HttpResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$statusCode = this.getStatusCode();
            Integer other$statusCode = other.getStatusCode();
            if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
                return false;
            }
            Map this$headerMap = this.getHeaderMap();
            Map other$headerMap = other.getHeaderMap();
            if (this$headerMap == null ? other$headerMap != null : !((Object)this$headerMap).equals(other$headerMap)) {
                return false;
            }
            String this$resString = this.getResString();
            String other$resString = other.getResString();
            return !(this$resString == null ? other$resString != null : !this$resString.equals(other$resString));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HttpResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $statusCode = this.getStatusCode();
            result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
            Map $headerMap = this.getHeaderMap();
            result = result * 59 + ($headerMap == null ? 43 : ((Object)$headerMap).hashCode());
            String $resString = this.getResString();
            result = result * 59 + ($resString == null ? 43 : $resString.hashCode());
            return result;
        }

        public String toString() {
            return "JwtFilter.HttpResult(statusCode=" + this.getStatusCode() + ", headerMap=" + this.getHeaderMap() + ", resString=" + this.getResString() + ")";
        }
    }

    private class TokenResult
    implements Serializable {
        private Integer status;
        private JSONObject data;
        private String token;

        public Integer getStatus() {
            return this.status;
        }

        public JSONObject getData() {
            return this.data;
        }

        public String getToken() {
            return this.token;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public void setData(JSONObject data) {
            this.data = data;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TokenResult)) {
                return false;
            }
            TokenResult other = (TokenResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$status = this.getStatus();
            Integer other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            JSONObject this$data = this.getData();
            JSONObject other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            return !(this$token == null ? other$token != null : !this$token.equals(other$token));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TokenResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            JSONObject $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            return result;
        }

        public String toString() {
            return "JwtFilter.TokenResult(status=" + this.getStatus() + ", data=" + this.getData() + ", token=" + this.getToken() + ")";
        }
    }
}

