/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.service.impl.jwt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.ohaotian.authority.config.jwt.JwtInterfaceConfig;
import com.ohaotian.authority.config.jwt.JwtTokenHolder;
import com.ohaotian.authority.model.AuthorityOrgBO;
import com.ohaotian.authority.model.AuthorityRoleBO;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.model.AuthorityUserRolesBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.authority.util.HttpUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JWTAuthorityServiceImpl
implements AuthorityService {
    private static Logger logger = LogManager.getLogger(JWTAuthorityServiceImpl.class);
    private JwtInterfaceConfig jwtInterfaceConfig;

    public JWTAuthorityServiceImpl(JwtInterfaceConfig jwtInterfaceConfig) {
        this.jwtInterfaceConfig = jwtInterfaceConfig;
    }

    @Override
    public String getToken(String userId) {
        return JwtTokenHolder.getToken();
    }

    @Override
    public AuthorityUserInfoBO getUserInfoByUserId(String userId) {
        AuthorityUserInfoBO authorityUserInfoBO = null;
        try {
            HashMap params = Maps.newHashMap();
            params.put("userId", userId);
            String jwtToken = JwtTokenHolder.getToken();
            HashMap header = Maps.newHashMap();
            header.put("auth-token", jwtToken);
            String userJson = HttpUtil.doPost(this.jwtInterfaceConfig.getAddr() + this.jwtInterfaceConfig.getGetUserPath(), (status, str) -> str, (Map<String, String>)params, header);
            JSONObject userObject = JSON.parseObject((String)userJson);
            JSONObject userData = (JSONObject)userObject.get((Object)"data");
            authorityUserInfoBO = new AuthorityUserInfoBO();
            authorityUserInfoBO.setUserId(userId);
            authorityUserInfoBO.setName(userData.getString("name"));
            authorityUserInfoBO.setCellPhone(userData.getString("cellPhone"));
            authorityUserInfoBO.setEmail(userData.getString("email"));
            authorityUserInfoBO.setLoginName(userData.getString("loginName"));
            authorityUserInfoBO.setOrgId(userData.getString("orgId"));
            authorityUserInfoBO.setTenantId(userData.getString("tenantId"));
            authorityUserInfoBO.setOrgId(userData.getString("orgId"));
        }
        catch (Exception e) {
            logger.error("\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01", (Throwable)e);
        }
        return authorityUserInfoBO;
    }

    @Override
    public AuthorityUserRolesBO getUserRolesByUserId(String userId) {
        AuthorityUserRolesBO authorityUserRolesBO = null;
        try {
            HashMap params = Maps.newHashMap();
            params.put("userId", userId);
            String jwtToken = JwtTokenHolder.getToken();
            HashMap header = Maps.newHashMap();
            header.put("auth-token", jwtToken);
            String rolesJson = HttpUtil.doPost(this.jwtInterfaceConfig.getAddr() + this.jwtInterfaceConfig.getGetRolesPath(), (status, str) -> str, (Map<String, String>)params, header);
            JSONObject rolesObject = JSON.parseObject((String)rolesJson);
            JSONObject rolesData = (JSONObject)rolesObject.get((Object)"data");
            JSONArray userRoles = rolesData.getJSONArray("userRoles");
            List userRolesMaps = userRoles.toJavaList(Map.class);
            List<AuthorityRoleBO> userRoleBOS = userRolesMaps.stream().map(map -> {
                AuthorityRoleBO authorityRoleBO = new AuthorityRoleBO();
                authorityRoleBO.setRoleName((String)map.get("roleName"));
                authorityRoleBO.setAuthIdentity((String)map.get("authIdentity"));
                authorityRoleBO.setRoleId((String)map.get("roleId"));
                return authorityRoleBO;
            }).collect(Collectors.toList());
            JSONArray orgRoles = rolesData.getJSONArray("orgRoles");
            List orgRolesMaps = orgRoles.toJavaList(Map.class);
            List<AuthorityRoleBO> orgRolesBOS = orgRolesMaps.stream().map(map -> {
                AuthorityRoleBO authorityRoleBO = new AuthorityRoleBO();
                authorityRoleBO.setRoleName((String)map.get("roleName"));
                authorityRoleBO.setAuthIdentity((String)map.get("authIdentity"));
                authorityRoleBO.setRoleId((String)map.get("roleId"));
                return authorityRoleBO;
            }).collect(Collectors.toList());
            authorityUserRolesBO = new AuthorityUserRolesBO();
            authorityUserRolesBO.setUserRoles(userRoleBOS);
            authorityUserRolesBO.setOrgRoles(orgRolesBOS);
        }
        catch (Exception e) {
            logger.error("\u7528\u6237\u89d2\u8272\u67e5\u8be2\u5931\u8d25\uff01", (Throwable)e);
        }
        return authorityUserRolesBO;
    }

    @Override
    public List<AuthorityOrgBO> getAllOrgByParentId(String orgId) {
        if (orgId == null) {
            orgId = "1";
        }
        try {
            HashMap params = Maps.newHashMap();
            params.put("parentId", orgId);
            String jwtToken = JwtTokenHolder.getToken();
            HashMap header = Maps.newHashMap();
            header.put("auth-token", jwtToken);
            String userJson = HttpUtil.doPost(this.jwtInterfaceConfig.getAddr() + this.jwtInterfaceConfig.getGetAllOrgByParentIdPath(), (status, str) -> str, (Map<String, String>)params, header);
            JSONObject jsonObject = JSON.parseObject((String)userJson);
            JSONArray orgArray = jsonObject.getJSONArray("data");
            List orgMapList = orgArray.toJavaList(Map.class);
            return orgMapList.stream().map(orgMap -> {
                AuthorityOrgBO authorityOrgBO = new AuthorityOrgBO();
                authorityOrgBO.setOrgId((String)orgMap.get("organisationId"));
                authorityOrgBO.setOrgTitle((String)orgMap.get("title"));
                authorityOrgBO.setIsParent((Integer)orgMap.get("isParent"));
                return authorityOrgBO;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01", (Throwable)e);
            return null;
        }
    }
}

