/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.service.impl.none;

import com.google.common.collect.Lists;
import com.ohaotian.authority.config.none.NoneInterfaceConfig;
import com.ohaotian.authority.model.AuthorityOrgBO;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.model.AuthorityUserRolesBO;
import com.ohaotian.authority.service.AuthorityService;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class NoneAuthorityServiceImpl
implements AuthorityService {
    private static Logger logger = LogManager.getLogger(NoneAuthorityServiceImpl.class);
    private NoneInterfaceConfig noneInterfaceConfig;

    public NoneAuthorityServiceImpl(NoneInterfaceConfig noneInterfaceConfig) {
        this.noneInterfaceConfig = noneInterfaceConfig;
    }

    @Override
    public String getToken(String userId) {
        logger.info("none\u65e0\u7528\u6237token\uff0c\u56fa\u5b9a\u8fd4\u56denull\uff01");
        return null;
    }

    @Override
    public AuthorityUserInfoBO getUserInfoByUserId(String userId) {
        AuthorityUserInfoBO authorityUserInfoBO = new AuthorityUserInfoBO();
        authorityUserInfoBO.setUserId(userId);
        if (userId.equalsIgnoreCase(this.noneInterfaceConfig.getUserId())) {
            authorityUserInfoBO.setTenantId(this.noneInterfaceConfig.getTenantId());
            authorityUserInfoBO.setOrgId(this.noneInterfaceConfig.getOrgId());
            authorityUserInfoBO.setName(this.noneInterfaceConfig.getName());
            authorityUserInfoBO.setTenantName(this.noneInterfaceConfig.getTenantName());
            authorityUserInfoBO.setLoginName(this.noneInterfaceConfig.getLoginName());
            authorityUserInfoBO.setCellPhone(this.noneInterfaceConfig.getCellPhone());
            authorityUserInfoBO.setEmail(this.noneInterfaceConfig.getEmail());
        } else {
            authorityUserInfoBO.setName("\u6a21\u62df\u7528\u6237");
        }
        return authorityUserInfoBO;
    }

    @Override
    public AuthorityUserRolesBO getUserRolesByUserId(String userId) {
        ArrayList userRoles = Lists.newArrayList();
        ArrayList orgRoles = Lists.newArrayList();
        AuthorityUserRolesBO authorityUserRolesBO = new AuthorityUserRolesBO();
        authorityUserRolesBO.setUserRoles(userRoles);
        authorityUserRolesBO.setOrgRoles(orgRoles);
        return authorityUserRolesBO;
    }

    @Override
    public List<AuthorityOrgBO> getAllOrgByParentId(String orgId) {
        ArrayList<AuthorityOrgBO> authorityOrgBOList = new ArrayList<AuthorityOrgBO>();
        for (int i = 0; i < 5; ++i) {
            AuthorityOrgBO authorityOrgBO = new AuthorityOrgBO();
            Long num = !StringUtils.isEmpty((Object)orgId) ? Long.valueOf(orgId) : Long.valueOf(1L);
            num = num * 10L + (long)i;
            authorityOrgBO.setOrgId(num.toString());
            authorityOrgBO.setOrgTitle("\u90e8\u95e8" + num);
            authorityOrgBO.setIsParent((int)(num % 2L));
            authorityOrgBOList.add(authorityOrgBO);
        }
        return authorityOrgBOList;
    }
}

