/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.config.cas;

import com.ohaotian.authority.holder.UserHolder;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.util.StringUtils;

public class LocalUserInfoFilter
implements Filter {
    private static Logger logger = LogManager.getLogger(LocalUserInfoFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String loginName = LocalUserInfoFilter.getAccountNameFromCas(httpServletRequest);
        if (!StringUtils.isEmpty((Object)loginName)) {
            logger.info("\u8bf7\u6c42\u8005id: " + loginName);
            UserHolder.setUserId(loginName);
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, servletResponse);
    }

    public static String getAccountNameFromCas(HttpServletRequest request) {
        Assertion assertion = (Assertion)request.getSession().getAttribute("_const_cas_assertion_");
        if (assertion != null) {
            AttributePrincipal principal = assertion.getPrincipal();
            return principal.getName();
        }
        return null;
    }
}

