/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.config.service;

import com.ohaotian.authority.config.cas.CasInterfaceConfig;
import com.ohaotian.authority.config.jwt.JwtInterfaceConfig;
import com.ohaotian.authority.config.none.NoneInterfaceConfig;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.authority.service.impl.cas.CASAuthorityServiceImpl;
import com.ohaotian.authority.service.impl.jwt.JWTAuthorityServiceImpl;
import com.ohaotian.authority.service.impl.none.NoneAuthorityServiceImpl;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={AuthorityService.class})
public class ServiceConfig {
    private static final Logger logger = LogManager.getLogger(ServiceConfig.class);
    @Resource
    private CasInterfaceConfig casInterfaceConfig;
    @Resource
    private JwtInterfaceConfig jwtInterfaceConfig;
    @Resource
    private NoneInterfaceConfig noneInterfaceConfig;

    @Bean
    @ConditionalOnMissingBean(value={AuthorityService.class})
    @ConditionalOnProperty(prefix="auth", name={"type"}, havingValue="cas")
    public AuthorityService casService() {
        logger.info("\u7cfb\u7edf\u88c5\u8f7d\u9274\u6743\u5b9e\u73b0\u7c7b\uff1aCASAuthorityServiceImpl");
        return new CASAuthorityServiceImpl(this.casInterfaceConfig);
    }

    @Bean
    @ConditionalOnMissingBean(value={AuthorityService.class})
    @ConditionalOnProperty(prefix="auth", name={"type"}, havingValue="jwt")
    public AuthorityService jwtService() {
        logger.info("\u7cfb\u7edf\u88c5\u8f7d\u9274\u6743\u5b9e\u73b0\u7c7b\uff1aJWTAuthorityServiceImpl");
        return new JWTAuthorityServiceImpl(this.jwtInterfaceConfig);
    }

    @Bean
    @ConditionalOnMissingBean(value={AuthorityService.class})
    @ConditionalOnProperty(prefix="auth", name={"type"}, havingValue="none")
    public AuthorityService noneService() {
        logger.info("\u7cfb\u7edf\u88c5\u8f7d\u9274\u6743\u5b9e\u73b0\u7c7b\uff1aNoneAuthorityServiceImpl");
        return new NoneAuthorityServiceImpl(this.noneInterfaceConfig);
    }
}

