/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.service.impl.cas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.ohaotian.authority.config.cas.CasInterfaceConfig;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityOrgBO;
import com.ohaotian.authority.model.AuthorityRoleBO;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.model.AuthorityUserRolesBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.authority.util.HttpUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CASAuthorityServiceImpl
implements AuthorityService {
    private static Logger logger = LogManager.getLogger(CASAuthorityServiceImpl.class);
    private CasInterfaceConfig casInterfaceConfig;

    public CASAuthorityServiceImpl(CasInterfaceConfig casInterfaceConfig) {
        this.casInterfaceConfig = casInterfaceConfig;
    }

    @Override
    public String getToken(String userId) {
        try {
            HashMap params = Maps.newHashMap();
            params.put("userId", userId);
            String tokenJson = HttpUtil.doPost(this.casInterfaceConfig.getAddr() + this.casInterfaceConfig.getTokenPath(), (status, str) -> str, params);
            JSONObject tokenObject = JSON.parseObject((String)tokenJson);
            JSONObject tokenData = (JSONObject)tokenObject.get((Object)"data");
            return (String)tokenData.get((Object)"token");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2token\u5931\u8d25\uff01", (Throwable)e);
            return null;
        }
    }

    @Override
    public AuthorityUserInfoBO getUserInfoByUserId(String userId) {
        AuthorityUserInfoBO authorityUserInfoBO = null;
        try {
            HashMap params = Maps.newHashMap();
            params.put("userId", userId);
            String tokenJson = HttpUtil.doPost(this.casInterfaceConfig.getAddr() + this.casInterfaceConfig.getTokenPath(), (status, str) -> str, params);
            JSONObject tokenObject = JSON.parseObject((String)tokenJson);
            JSONObject tokenData = (JSONObject)tokenObject.get((Object)"data");
            String token = (String)tokenData.get((Object)"token");
            HashMap header = Maps.newHashMap();
            header.put("auth-token", token);
            String userJson = HttpUtil.doPost(this.casInterfaceConfig.getAddr() + this.casInterfaceConfig.getGetUserPath(), (status, str) -> str, (Map<String, String>)params, header);
            JSONObject userObject = JSON.parseObject((String)userJson);
            JSONObject userData = (JSONObject)userObject.get((Object)"data");
            authorityUserInfoBO = new AuthorityUserInfoBO();
            authorityUserInfoBO.setUserId(userId);
            authorityUserInfoBO.setName(userData.getString("name"));
            authorityUserInfoBO.setCellPhone(userData.getString("cellPhone"));
            authorityUserInfoBO.setEmail(userData.getString("email"));
            authorityUserInfoBO.setLoginName(userData.getString("loginName"));
            authorityUserInfoBO.setOrgId(userData.getString("orgId"));
            authorityUserInfoBO.setTenantId(userData.getString("tenantId"));
            authorityUserInfoBO.setOrgId(userData.getString("orgId"));
        }
        catch (Exception e) {
            logger.error("\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01", (Throwable)e);
        }
        return authorityUserInfoBO;
    }

    @Override
    public AuthorityUserRolesBO getUserRolesByUserId(String userId) {
        AuthorityUserRolesBO authorityUserRolesBO = null;
        try {
            HashMap params = Maps.newHashMap();
            params.put("userId", userId);
            String tokenJson = HttpUtil.doPost(this.casInterfaceConfig.getAddr() + this.casInterfaceConfig.getTokenPath(), (status, str) -> str, params);
            JSONObject tokenObject = JSON.parseObject((String)tokenJson);
            JSONObject tokenData = (JSONObject)tokenObject.get((Object)"data");
            String token = (String)tokenData.get((Object)"token");
            HashMap header = Maps.newHashMap();
            header.put("auth-token", token);
            String rolesJson = HttpUtil.doPost(this.casInterfaceConfig.getAddr() + this.casInterfaceConfig.getGetRolesPath(), (status, str) -> str, (Map<String, String>)params, header);
            JSONObject rolesObject = JSON.parseObject((String)rolesJson);
            JSONObject rolesData = (JSONObject)rolesObject.get((Object)"data");
            JSONArray userRoles = rolesData.getJSONArray("userRoles");
            List userRolesMaps = userRoles.toJavaList(Map.class);
            List<AuthorityRoleBO> userRoleBOS = userRolesMaps.stream().map(map -> {
                AuthorityRoleBO authorityRoleBO = new AuthorityRoleBO();
                authorityRoleBO.setRoleName((String)map.get("roleName"));
                authorityRoleBO.setAuthIdentity((String)map.get("authIdentity"));
                authorityRoleBO.setRoleId((String)map.get("roleId"));
                return authorityRoleBO;
            }).collect(Collectors.toList());
            JSONArray orgRoles = rolesData.getJSONArray("orgRoles");
            List orgRolesMaps = orgRoles.toJavaList(Map.class);
            List<AuthorityRoleBO> orgRolesBOS = orgRolesMaps.stream().map(map -> {
                AuthorityRoleBO authorityRoleBO = new AuthorityRoleBO();
                authorityRoleBO.setRoleName((String)map.get("roleName"));
                authorityRoleBO.setAuthIdentity((String)map.get("authIdentity"));
                authorityRoleBO.setRoleId((String)map.get("roleId"));
                return authorityRoleBO;
            }).collect(Collectors.toList());
            authorityUserRolesBO = new AuthorityUserRolesBO();
            authorityUserRolesBO.setUserRoles(userRoleBOS);
            authorityUserRolesBO.setOrgRoles(orgRolesBOS);
        }
        catch (Exception e) {
            logger.error("\u7528\u6237\u89d2\u8272\u67e5\u8be2\u5931\u8d25\uff01", (Throwable)e);
        }
        return authorityUserRolesBO;
    }

    @Override
    public List<AuthorityOrgBO> getAllOrgByParentId(String orgId) {
        try {
            String userId = UserHolder.getUserId();
            HashMap userParams = Maps.newHashMap();
            userParams.put("userId", userId);
            String tokenJson = HttpUtil.doPost(this.casInterfaceConfig.getAddr() + this.casInterfaceConfig.getTokenPath(), (status, str) -> str, userParams);
            JSONObject tokenObject = JSON.parseObject((String)tokenJson);
            JSONObject tokenData = (JSONObject)tokenObject.get((Object)"data");
            String token = (String)tokenData.get((Object)"token");
            if (orgId == null) {
                orgId = "1";
            }
            HashMap orgParams = Maps.newHashMap();
            orgParams.put("parentId", orgId);
            HashMap header = Maps.newHashMap();
            header.put("auth-token", token);
            String userJson = HttpUtil.doPost(this.casInterfaceConfig.getAddr() + this.casInterfaceConfig.getGetAllOrgByParentIdPath(), (status, str) -> str, (Map<String, String>)orgParams, header);
            JSONObject jsonObject = JSON.parseObject((String)userJson);
            JSONArray orgArray = jsonObject.getJSONArray("data");
            List orgMapList = orgArray.toJavaList(Map.class);
            return orgMapList.stream().map(orgMap -> {
                AuthorityOrgBO authorityOrgBO = new AuthorityOrgBO();
                authorityOrgBO.setOrgId((String)orgMap.get("organisationId"));
                authorityOrgBO.setOrgTitle((String)orgMap.get("title"));
                authorityOrgBO.setIsParent((Integer)orgMap.get("isParent"));
                return authorityOrgBO;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("\u7528\u6237\u89d2\u8272\u67e5\u8be2\u5931\u8d25\uff01", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        String rolesJson = "{\n    \"code\": \"0\",\n    \"data\": {\n        \"userRoles\": [\n            {\n                \"canSel\": 0,\n                \"roleId\": \"404737584022896640\",\n                \"roleName\": \"\u901a\u77e5\u4e2d\u5fc3\u4f7f\u7528\u8005\",\n                \"authIdentity\": \"auth:notify:user\",\n                \"orgExtend\": 0\n            },\n            {\n                \"canSel\": 0,\n                \"roleId\": \"386969850922303488\",\n                \"roleName\": \"\u7edf\u4e00\u65e5\u5fd7\u5e73\u53f0\u8d85\u7ba1\",\n                \"authIdentity\": \"auth:logplatform:super\",\n                \"orgExtend\": 0\n            }\n        ],\n        \"orgRoles\": [\n            {\n                \"canSel\": 1,\n                \"roleId\": \"335817127641706496\",\n                \"roleName\": \"\u80fd\u529b\u5e73\u53f0\u4f7f\u7528\u8005\",\n                \"authIdentity\": \"auth:ability:user\",\n                \"orgExtend\": 0\n            },\n            {\n                \"canSel\": 1,\n                \"roleId\": \"406442834556432384\",\n                \"roleName\": \"\u8d44\u6e90\u7ba1\u7406\u80fd\u529b\",\n                \"authIdentity\": \"auth:cmdb:user\",\n                \"orgExtend\": 0\n            },\n            {\n                \"canSel\": 1,\n                \"roleId\": \"4\",\n                \"roleName\": \"\u9ed8\u8ba4\u89d2\u8272\",\n                \"authIdentity\": \"auth:default:manage\",\n                \"orgExtend\": 0\n            },\n            {\n                \"canSel\": 1,\n                \"roleId\": \"1\",\n                \"roleName\": \"\u7cfb\u7d71\u7ba1\u7406\u5458\",\n                \"authIdentity\": \"auth:system:manage\",\n                \"orgExtend\": 0\n            }\n        ]\n    },\n    \"message\": \"\u6210\u529f\"\n}";
        JSONObject rolesObject = JSON.parseObject((String)rolesJson);
        JSONObject rolesData = (JSONObject)rolesObject.get((Object)"data");
        JSONArray userRoles = rolesData.getJSONArray("userRoles");
        List userRolesMaps = userRoles.toJavaList(Map.class);
        List<AuthorityRoleBO> userRoleBOS = userRolesMaps.stream().map(map -> {
            AuthorityRoleBO authorityRoleBO = new AuthorityRoleBO();
            authorityRoleBO.setRoleName((String)map.get("roleName"));
            authorityRoleBO.setAuthIdentity((String)map.get("authIdentity"));
            authorityRoleBO.setRoleId((String)map.get("roleId"));
            return authorityRoleBO;
        }).collect(Collectors.toList());
        JSONArray orgRoles = rolesData.getJSONArray("orgRoles");
        List orgRolesMaps = orgRoles.toJavaList(Map.class);
        List<AuthorityRoleBO> orgRolesBOS = orgRolesMaps.stream().map(map -> {
            AuthorityRoleBO authorityRoleBO = new AuthorityRoleBO();
            authorityRoleBO.setRoleName((String)map.get("roleName"));
            authorityRoleBO.setAuthIdentity((String)map.get("authIdentity"));
            authorityRoleBO.setRoleId((String)map.get("roleId"));
            return authorityRoleBO;
        }).collect(Collectors.toList());
        AuthorityUserRolesBO authorityUserRolesBO = new AuthorityUserRolesBO();
        authorityUserRolesBO.setUserRoles(userRoleBOS);
        authorityUserRolesBO.setOrgRoles(orgRolesBOS);
        System.out.println(authorityUserRolesBO);
    }
}

