/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext;

import com.ohaotian.plugin.mq.proxy.CacheStore;
import com.ohaotian.plugin.mq.proxy.status.ProxyTransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyMqTransactionChecker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean isDebugEnable = this.logger.isDebugEnabled();
    public static final Integer PRODUCT_SEND_STATUS_TIMETOOLONG = 2;
    public static final long MQ_EXPIRE = 0x6DDD00L;
    public static final int MQ_TRAN_CHECK_EXPIRE = 600;
    private CacheStore cacheStore;

    public ProxyTransactionStatus check(String msgId, String key, String topic, String tag) {
        String status = (String)this.cacheStore.get(msgId);
        if (status != null) {
            if (ProxyTransactionStatus.COMMIT.toString().equals(status)) {
                if (this.isDebugEnable) {
                    this.logger.debug("check msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "} key={" + key + "}send message success!");
                }
                try {
                    this.cacheStore.delete(msgId);
                    this.cacheStore.delete("C_" + msgId);
                }
                catch (Exception e) {
                    this.logger.error("delete redis key{" + msgId + "} and key {C_" + msgId + "} error", (Throwable)e);
                }
                return ProxyTransactionStatus.COMMIT;
            }
            if (ProxyTransactionStatus.ROLLBACK.toString().equals(status)) {
                if (this.isDebugEnable) {
                    this.logger.debug("check  msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "} key={" + key + "}send message fail!");
                }
                try {
                    this.cacheStore.delete(msgId);
                    this.cacheStore.delete("C_" + msgId);
                }
                catch (Exception e) {
                    this.logger.error("delete redis\ufffd\ufffd\ufffdkey{" + msgId + "} and key {C_" + msgId + "} error", (Throwable)e);
                }
                return ProxyTransactionStatus.ROLLBACK;
            }
            this.logger.error("unknow mq trans{" + status + "}msgId{" + msgId + "}");
            return ProxyTransactionStatus.ROLLBACK;
        }
        Integer cstatus = (Integer)this.cacheStore.get("C_" + msgId);
        if (cstatus != null) {
            Long dateTime = this.cacheStore.getExpireTimeByKey("C_" + msgId);
            if (dateTime != null && (dateTime == -1L || dateTime == -2L)) {
                this.cacheStore.delete(msgId);
                if (this.isDebugEnable) {
                    this.logger.debug("check msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "}  key={" + key + "}----too long time\ufffd\ufffd\ufffddelete message\ufffd\ufffd\ufffd");
                }
                return ProxyTransactionStatus.ROLLBACK;
            }
            if (this.isDebugEnable) {
                this.logger.debug("check msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "}  key={" + key + "} unknow status!");
            }
            return ProxyTransactionStatus.UNKNOW;
        }
        if (this.isDebugEnable) {
            this.logger.debug("check msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "}  key={" + key + "} first check empty\ufffd\ufffd\ufffdadd a check!");
        }
        this.cacheStore.set("C_" + msgId, (Object)PRODUCT_SEND_STATUS_TIMETOOLONG, 7200);
        return ProxyTransactionStatus.UNKNOW;
    }

    public void setCacheStore(CacheStore cacheStore) {
        this.cacheStore = cacheStore;
    }
}

