package com.ohaotian.plugin.mq.proxy.ext.aliyunmq;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;
import com.ohaotian.plugin.mq.proxy.CacheStore;
import com.ohaotian.plugin.mq.proxy.ext.ProxyMqTransactionChecker;
import com.ohaotian.plugin.mq.proxy.status.ProxyTransactionStatus;

public class AliyunMqTransactionCheckerListener implements LocalTransactionChecker {
    private ProxyMqTransactionChecker mqTransactionChecker = new ProxyMqTransactionChecker();

    public TransactionStatus check(Message msg) {
        ProxyTransactionStatus transactionStatus = mqTransactionChecker.check(msg.getMsgID(), msg.getKey(), msg.getTopic(), msg.getTag());
        switch (transactionStatus) {
            case ROLLBACK:
                return TransactionStatus.RollbackTransaction;
            case COMMIT:
                return TransactionStatus.CommitTransaction;
            default:
                return TransactionStatus.Unknow;
        }
    }

    public void setCacheStore(CacheStore cacheStore) {
        mqTransactionChecker.setCacheStore(cacheStore);
    }
}
