package com.ohaotian.plugin.mq.proxy.impl;

import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.ext.ExtInfo;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.lang.reflect.Proxy;
import java.util.*;

public class ProxyMessageRegister implements ApplicationContextAware {

    public ProxyMessageRegister(){
        this.init();
    }

    private void init() {
        // 关闭RocketMQ加载日志文件，防止业务系统的日志文件无法被加载
        System.setProperty("rocketmq.client.log.loadconfig","false");
    }

    private String strategy;

    List<MQRegister> registerList = new LinkedList<MQRegister>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map<String, ? extends ProxyMessageConsumer> consumerMapping = applicationContext.getBeansOfType(ProxyMessageConsumer.class);
        Iterator<? extends ProxyMessageConsumer> consumers = consumerMapping.values().iterator();
        Map<String, ConsumerRegisterInfo> localStore = new HashMap<String, ConsumerRegisterInfo>();
        while (consumers.hasNext()) {
            ProxyMessageConsumer consumer = consumers.next();
            StringBuilder localStoreKey = new StringBuilder();
            localStoreKey.append(consumer.getSubject()).append("[");
            ProxyMessageType[] messageTypes = consumer.supportMessageTypes();
            for(ProxyMessageType messageType: messageTypes) {
                localStoreKey.append(messageType.name()).append("-");
            }
            localStoreKey.append("]");
            ConsumerRegisterInfo consumerRegisterInfo = localStore.get(localStoreKey.toString());
            if (consumerRegisterInfo == null) {
                consumerRegisterInfo = new ConsumerRegisterInfo(consumer.getId(), consumer.getSubject(), new HashSet<String>(), consumer.supportMessageTypes(), new HashSet<IProxyMessageConsumerWrapper>(), consumer.getProperties());
                localStore.put(localStoreKey.toString(), consumerRegisterInfo);
            }
            Set<String> tagSet = consumerRegisterInfo.getTags();
            String[] tags = consumer.getTags();
            ProxyProducerFactoryBean.trans2TagSet(tagSet, tags);
            Set<IProxyMessageConsumerWrapper> localConsumers = consumerRegisterInfo.getConsumerWrappers();
            IProxyMessageConsumerWrapper proxyMessageConsumerWrapper = (IProxyMessageConsumerWrapper) Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IProxyMessageConsumerWrapper.class}, new ConsumerInvokeHandler(consumer));
            localConsumers.add(proxyMessageConsumerWrapper);
            String localStrategy = consumer.getStrategy();
            if (localStrategy == null || "".equals(localStrategy)) {
                localStrategy = this.strategy;
            }
            ExtInfo extInfo = MQUtils.getExtInfoMapping().get(localStrategy);
            if (extInfo == null) {
                throw new IllegalStateException("mq.strategy[" + localStrategy + "] unsupported");
            }
            MQRegister mqRegister = extInfo.newRegister();
            if (mqRegister instanceof ApplicationContextAware) {
                ((ApplicationContextAware) mqRegister).setApplicationContext(applicationContext);
            }
            registerList.add(mqRegister);
            mqRegister.register(consumerRegisterInfo);
        }
        this.startup();
    }

    public void startup() {
        for(MQRegister register : registerList) {
            register.startup();
        }
    }

    public void shutdown() {
        for(MQRegister register : registerList) {
            register.shutdown();
        }
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }
}
