/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.support;

import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.RedisCacheStore;
import com.ohaotian.plugin.mq.proxy.constants.LogUtils;
import com.ohaotian.plugin.mq.proxy.constants.MessageConfigUtils;
import com.ohaotian.plugin.mq.proxy.impl.ProxyMessageRegister;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import com.ohaotian.plugin.mq.proxy.support.EnablePluginMqProxy;
import com.ohaotian.plugin.mq.proxy.support.MqProxyConsumer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginMqProxyConfiguration
implements ImportBeanDefinitionRegistrar {
    private static final Logger logger = LoggerFactory.getLogger(PluginMqProxyConfiguration.class);
    private static final String RESOURCE_PATTERN = "**/*.class";

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnablePluginMqProxy.class.getName()));
        Object[] basePackages = attributes.getStringArray("value");
        if (ObjectUtils.isEmpty((Object[])basePackages)) {
            basePackages = attributes.getStringArray("basePackages");
        }
        if (ObjectUtils.isEmpty((Object[])basePackages)) {
            basePackages = new String[]{ClassUtils.getPackageName((String)importingClassMetadata.getClassName())};
        }
        RootBeanDefinition redisCacheStore = new RootBeanDefinition(RedisCacheStore.class);
        registry.registerBeanDefinition("redisCacheStore", (BeanDefinition)redisCacheStore);
        this.registerRegister(registry);
        this.registerProducer(registry);
        this.registerConsumer(registry, (String[])basePackages);
    }

    private void registerRegister(BeanDefinitionRegistry registry) {
        RootBeanDefinition proxyMessageRegister = new RootBeanDefinition(ProxyMessageRegister.class);
        MutablePropertyValues propertyValues = new MutablePropertyValues();
        propertyValues.add("strategy", (Object)MessageConfigUtils.getElKeyByKey("mq.strategy"));
        propertyValues.add("enable", (Object)MessageConfigUtils.getElKeyByKey("mq.enable"));
        proxyMessageRegister.setPropertyValues(propertyValues);
        proxyMessageRegister.setInitMethodName("startup");
        proxyMessageRegister.setDestroyMethodName("shutdown");
        registry.registerBeanDefinition("proxyMessageRegister", (BeanDefinition)proxyMessageRegister);
        LogUtils.debug(logger, "Loaded bean definitions from class [" + ProxyMessageRegister.class.getName() + ']');
    }

    /*
     * WARNING - void declaration
     */
    private void registerConsumer(BeanDefinitionRegistry registry, String[] basePackages) {
        void var6_8;
        LogUtils.debug(logger, "Started scan mq proxy consumer", null);
        ArrayList consumerList = new ArrayList(16);
        String[] stringArray = basePackages;
        int n = stringArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            String basePackage = stringArray[var6_8];
            try {
                LogUtils.debug(logger, "Scan mq proxy consumer on this package [" + basePackage + "]");
                consumerList.addAll(this.findConsumerClass(basePackage));
            }
            catch (IOException e) {
                LogUtils.warn(logger, "Scan this package error", basePackage);
            }
            ++var6_8;
        }
        if (CollectionUtils.isEmpty(consumerList)) {
            LogUtils.debug(logger, "Ended scan mq proxy consumer no consumer");
            return;
        }
        LogUtils.debug(logger, "Ended scan mq proxy consumer on consumer count [" + consumerList.size() + "]");
        for (Class clazz : consumerList) {
            RootBeanDefinition consumerDefinition = new RootBeanDefinition(clazz);
            MutablePropertyValues propertyValues = new MutablePropertyValues();
            propertyValues.add("id", this.getConsumerConfig(clazz, "id"));
            propertyValues.add("subject", this.getConsumerConfig(clazz, "subject"));
            propertyValues.add("tags", this.getConsumerConfig(clazz, "tags"));
            consumerDefinition.setPropertyValues(propertyValues);
            registry.registerBeanDefinition(this.getBeanNameByClass(clazz), (BeanDefinition)consumerDefinition);
            LogUtils.debug(logger, "Loaded bean definitions from class [" + clazz.getName() + ']');
        }
    }

    private Object getConsumerConfig(Class<?> consumerClass, String key) {
        for (Annotation annotation : consumerClass.getAnnotations()) {
            if (!(annotation instanceof MqProxyConsumer)) continue;
            MqProxyConsumer consumer = (MqProxyConsumer)annotation;
            if ("id".equals(key)) {
                String value = consumer.id();
                if (StringUtils.isEmpty((Object)value)) {
                    throw new IllegalArgumentException("[Plugin-Mq-Proxy] \u6d88\u8d39\u8005\u7c7b[" + consumerClass.getName() + "]\u7684@MqProxyConsumer\u6ce8\u89e3\u7684id\u672a\u914d\u7f6e");
                }
                return value;
            }
            if ("subject".equals(key)) {
                String value = consumer.subject();
                if (StringUtils.isEmpty((Object)value)) {
                    throw new IllegalArgumentException("[Plugin-Mq-Proxy] \u6d88\u8d39\u8005\u7c7b[" + consumerClass.getName() + "]\u7684@MqProxyConsumer\u6ce8\u89e3\u7684subject\u672a\u914d\u7f6e");
                }
                return value;
            }
            if (!"tags".equals(key)) continue;
            String[] value = consumer.tags();
            if (value.length == 0) {
                throw new IllegalArgumentException("[Plugin-Mq-Proxy] \u6d88\u8d39\u8005\u7c7b[" + consumerClass.getName() + "]\u7684@MqProxyConsumer\u6ce8\u89e3\u7684tags\u672a\u914d\u7f6e");
            }
            return Arrays.asList(value);
        }
        return null;
    }

    private List<Class<?>> findConsumerClass(String basePackage) throws IOException {
        Resource[] resources;
        ArrayList consumerList = new ArrayList(16);
        String packageSearchPath = "classpath*:" + this.replaceDotByDelimiter(basePackage) + "/" + RESOURCE_PATTERN;
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        SimpleMetadataReaderFactory readerFactory = new SimpleMetadataReaderFactory((ResourceLoader)resourceLoader);
        for (Resource resource : resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader).getResources(packageSearchPath)) {
            MetadataReader reader = readerFactory.getMetadataReader(resource);
            Class<?> targetClass = this.getClassTypeByClassName(reader.getClassMetadata().getClassName());
            if (targetClass == null || !this.isMqProxyConsumer(targetClass)) continue;
            consumerList.add(targetClass);
        }
        return consumerList;
    }

    private void registerProducer(BeanDefinitionRegistry registry) {
        RootBeanDefinition producer = new RootBeanDefinition(ProxyProducerFactoryBean.class);
        DefaultProxyMessageConfig config = new DefaultProxyMessageConfig();
        config.setId("DEFAULT_PRODUCER_ID");
        MutablePropertyValues propertyValues = new MutablePropertyValues();
        propertyValues.add("messageConfig", (Object)config);
        producer.setPropertyValues(propertyValues);
        producer.setInitMethodName("startup");
        producer.setDestroyMethodName("shutdown");
        registry.registerBeanDefinition("producer", (BeanDefinition)producer);
        LogUtils.debug(logger, "Loaded bean definitions from class [" + ProxyProducerFactoryBean.class.getName() + ']');
    }

    private String replaceDotByDelimiter(String path) {
        return StringUtils.replace((String)path, (String)".", (String)"/");
    }

    private Class<?> getClassTypeByClassName(String className) {
        Class clazz = null;
        try {
            clazz = ClassUtils.forName((String)className, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            LogUtils.debug(logger, "\u672a\u627e\u5230\u6307\u5b9a\u6d88\u8d39\u8005", className);
        }
        return clazz;
    }

    private String getBeanNameByClass(Class<?> consumerClass) {
        String name = consumerClass.getSimpleName();
        if (Character.isLowerCase(name.charAt(0))) {
            return name;
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private boolean isMqProxyConsumer(Class<?> targetClass) {
        for (Annotation annotation : targetClass.getAnnotations()) {
            if (!(annotation instanceof MqProxyConsumer)) continue;
            LogUtils.debug(logger, "Scan mq proxy consumer find consumer [" + targetClass.getName() + "]");
            return true;
        }
        return false;
    }
}

