/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.impl;

import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.ext.ExtInfo;
import com.ohaotian.plugin.mq.proxy.impl.ConsumerInvokeHandler;
import com.ohaotian.plugin.mq.proxy.impl.ConsumerRegisterInfo;
import com.ohaotian.plugin.mq.proxy.impl.IProxyMessageConsumerWrapper;
import com.ohaotian.plugin.mq.proxy.impl.MQRegister;
import com.ohaotian.plugin.mq.proxy.impl.MQUtils;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ProxyMessageRegister
implements ApplicationContextAware {
    private String strategy;
    List<MQRegister> registerList = new LinkedList<MQRegister>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map consumerMapping = applicationContext.getBeansOfType(ProxyMessageConsumer.class);
        Iterator consumers = consumerMapping.values().iterator();
        HashMap<String, ConsumerRegisterInfo> localStore = new HashMap<String, ConsumerRegisterInfo>();
        while (consumers.hasNext()) {
            ExtInfo extInfo;
            ProxyMessageType[] messageTypes;
            ProxyMessageConsumer consumer = (ProxyMessageConsumer)consumers.next();
            StringBuilder localStoreKey = new StringBuilder();
            localStoreKey.append(consumer.getSubject()).append("[");
            for (ProxyMessageType messageType : messageTypes = consumer.supportMessageTypes()) {
                localStoreKey.append(messageType.name()).append("-");
            }
            localStoreKey.append("]");
            ConsumerRegisterInfo consumerRegisterInfo = (ConsumerRegisterInfo)localStore.get(localStoreKey.toString());
            if (consumerRegisterInfo == null) {
                consumerRegisterInfo = new ConsumerRegisterInfo(consumer.getSubject(), new HashSet<String>(), consumer.supportMessageTypes(), new HashSet<IProxyMessageConsumerWrapper>(), consumer.getProperties());
                localStore.put(localStoreKey.toString(), consumerRegisterInfo);
            }
            Set<String> tagSet = consumerRegisterInfo.getTags();
            String[] tags = consumer.getTags();
            ProxyProducerFactoryBean.trans2TagSet(tagSet, tags);
            Set<IProxyMessageConsumerWrapper> localConsumers = consumerRegisterInfo.getConsumerWrappers();
            IProxyMessageConsumerWrapper proxyMessageConsumerWrapper = (IProxyMessageConsumerWrapper)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IProxyMessageConsumerWrapper.class}, (InvocationHandler)new ConsumerInvokeHandler(consumer));
            localConsumers.add(proxyMessageConsumerWrapper);
            String localStrategy = consumer.getStrategy();
            if (localStrategy == null || "".equals(localStrategy)) {
                localStrategy = this.strategy;
            }
            if ((extInfo = MQUtils.getExtInfoMapping().get(localStrategy)) == null) {
                throw new IllegalStateException("mq.strategy[" + localStrategy + "] unsupported");
            }
            MQRegister mqRegister = extInfo.newRegister();
            if (mqRegister instanceof ApplicationContextAware) {
                ((ApplicationContextAware)mqRegister).setApplicationContext(applicationContext);
            }
            this.registerList.add(mqRegister);
            mqRegister.register(consumerRegisterInfo);
        }
        this.startup();
    }

    public void startup() {
        for (MQRegister register : this.registerList) {
            register.startup();
        }
    }

    public void shtudown() {
        for (MQRegister register : this.registerList) {
            register.shutdown();
        }
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }
}

