/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.impl;

import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.impl.ProxyMessageRegister;
import com.ohaotian.plugin.mq.proxy.impl.ProxyMessageSenderWrapper;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyProducerFactoryBean
implements FactoryBean,
ApplicationContextAware {
    private ProxyMessageConfig messageConfig;
    private ProxyMessageSenderWrapper messageSenderWrapper;
    private ProxyMessageProducer messageProducer;
    private String defaultStrategy;

    public Object getObject() throws Exception {
        ProxyMessageType[] messageTypes;
        if (this.messageProducer != null) {
            return this.messageProducer;
        }
        HashSet<String> tagSet = new HashSet<String>();
        String[] tags = this.messageConfig.getTags();
        ProxyProducerFactoryBean.trans2TagSet(tagSet, tags);
        HashMap<ProxyMessageType, Set<String>> typeTagsMapping = new HashMap<ProxyMessageType, Set<String>>();
        for (ProxyMessageType messageType : messageTypes = this.messageConfig.supportMessageTypes()) {
            typeTagsMapping.put(messageType, tagSet);
        }
        String strategy = this.messageConfig.getStrategy();
        if (strategy == null || "".equals(strategy)) {
            strategy = this.defaultStrategy;
        }
        this.messageSenderWrapper = new ProxyMessageSenderWrapper(strategy, this.messageConfig, typeTagsMapping);
        this.messageProducer = (ProxyMessageProducer)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ProxyMessageProducer.class}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)ProxyProducerFactoryBean.this.messageSenderWrapper, args);
            }
        });
        return this.messageProducer;
    }

    public void startup() {
        if (this.messageSenderWrapper == null) {
            try {
                this.getObject();
            }
            catch (Exception e) {
                throw new IllegalStateException("Init message productor error", e);
            }
        }
        this.messageSenderWrapper.startup();
    }

    public void shutdown() {
        if (this.messageSenderWrapper != null) {
            this.messageSenderWrapper.shutdown();
        }
    }

    static void trans2TagSet(Set<String> tagSet, String[] tags) {
        for (String tag : tags) {
            if (tagSet.contains("*")) break;
            if (tag.equals("*")) {
                tagSet.clear();
                tagSet.add(tag);
                break;
            }
            if (tagSet.contains(tag)) continue;
            tagSet.add(tag);
        }
    }

    public Class<?> getObjectType() {
        return ProxyMessageProducer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setMessageConfig(ProxyMessageConfig messageConfig) {
        this.messageConfig = messageConfig;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ProxyMessageRegister messageConsumerRegister = (ProxyMessageRegister)applicationContext.getBean(ProxyMessageRegister.class);
        try {
            Field strategyField = ProxyMessageRegister.class.getDeclaredField("strategy");
            strategyField.setAccessible(true);
            this.defaultStrategy = (String)strategyField.get(messageConsumerRegister);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Get default strategy error", e);
        }
        if (this.messageSenderWrapper == null) {
            try {
                this.getObject();
            }
            catch (Exception e) {
                throw new IllegalStateException("Init message productor error", e);
            }
        }
        this.messageSenderWrapper.setApplicationContext(applicationContext);
    }
}

