/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.redismq;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.impl.IProxyMessageConsumerWrapper;
import java.io.IOException;
import java.util.Set;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisMQMessageListener
extends JedisPubSub {
    private final JedisPool jedisPool;
    private final ThreadLocal<ObjectMapper> objectMapperThreadLocal = new ThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            return new ObjectMapper();
        }
    };
    private Set<IProxyMessageConsumerWrapper> consumerWrapperList;

    public RedisMQMessageListener(JedisPool jedisPool, Set<IProxyMessageConsumerWrapper> consumerWrapperList) {
        this.consumerWrapperList = consumerWrapperList;
        this.jedisPool = jedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unsetOneConsumer(ProxyMessage message) {
        boolean result = false;
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            result = jedis.del(message.getMessageId()).intValue() > 0;
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return result;
    }

    public void onMessage(String channel, String message) {
        this.processMessage(message);
    }

    public void onPMessage(String pattern, String channel, String message) {
        this.processMessage(message);
    }

    private void processMessage(String message) {
        try {
            ProxyMessage proxyMessage = (ProxyMessage)this.objectMapperThreadLocal.get().readValue(message, ProxyMessage.class);
            if (this.unsetOneConsumer(proxyMessage)) {
                for (IProxyMessageConsumerWrapper messageConsumer : this.consumerWrapperList) {
                    if (!messageConsumer.needWrapper(proxyMessage.getSubject(), proxyMessage.getTag())) continue;
                    messageConsumer.onMessage(proxyMessage);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Redis parse value error", e);
        }
    }
}

