/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.impl;

import com.ohaotian.plugin.mq.proxy.ext.ExtInfo;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MQUtils {
    private static final PathMatchingResourcePatternResolver PMRPR = new PathMatchingResourcePatternResolver(ExtInfo.class.getClassLoader());
    private static final Map<String, ExtInfo> EXT_INFO_MAPPING;

    public static Map<String, ExtInfo> getExtInfoMapping() {
        return EXT_INFO_MAPPING;
    }

    public static String tags2Line(Set<String> tagSet) {
        StringBuilder tagLine = new StringBuilder();
        String seprator = null;
        for (String tag : tagSet) {
            if (seprator != null) {
                tagLine.append(seprator);
            } else {
                seprator = "||";
            }
            tagLine.append(tag);
        }
        return tagLine.toString();
    }

    static {
        Resource resource = PMRPR.getResource("classpath:/" + ExtInfo.class.getPackage().getName().replace(".", "/") + "/mq.handlers");
        Properties props = new Properties();
        try {
            HashMap<String, ExtInfo> extInfoMapping = new HashMap<String, ExtInfo>();
            InputStream ins = resource.getInputStream();
            props.load(ins);
            ins.close();
            Set<Object> keySet = props.keySet();
            for (Object keyObj : keySet) {
                String key = (String)keyObj;
                if (extInfoMapping.containsKey(key = key.substring(0, key.indexOf(".")))) continue;
                extInfoMapping.put(key, new ExtInfo());
            }
            Set entrySet = extInfoMapping.entrySet();
            for (Map.Entry entry : entrySet) {
                ExtInfo extInfo = (ExtInfo)entry.getValue();
                extInfo.setRegisterClass(Class.forName(props.getProperty((String)entry.getKey() + ".register")));
                if (!extInfo.registerSupported((String)entry.getKey())) {
                    throw new IllegalStateException("handler[" + extInfo.getRegisterClass().getName() + "] key must be [" + (String)entry.getKey() + ".register]");
                }
                extInfo.setSenderClass(Class.forName(props.getProperty((String)entry.getKey() + ".sender")));
            }
            EXT_INFO_MAPPING = Collections.unmodifiableMap(extInfoMapping);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException("init mq-proxy handlers error", e);
        }
    }
}

