/*
 * Decompiled with CFR 0.152.
 */
package com.haotian.remote;

import com.haotian.remote.ProxyConsumer;
import com.haotian.remote.ProxyProvider;
import com.haotian.remote.RemoteConsumer;
import com.haotian.remote.RemoteProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class AnnotationUtil {
    private static final PathMatchingResourcePatternResolver PMRPR = new PathMatchingResourcePatternResolver(AnnotationUtil.class.getClassLoader());

    public static List<RemoteConsumer> extractProxyConsumers(String scanPath) throws IOException, ClassNotFoundException {
        List<String> consumerList = AnnotationUtil.extractAnnotationClazzes(ProxyConsumer.class, scanPath);
        ArrayList<RemoteConsumer> proxyConsumerList = new ArrayList<RemoteConsumer>(consumerList.size());
        for (String consumer : consumerList) {
            proxyConsumerList.add(new RemoteConsumer(Class.forName(consumer)));
        }
        return proxyConsumerList;
    }

    public static List<String> getProxyProviders(String scanPath) throws IOException, ClassNotFoundException {
        List<String> providerList = AnnotationUtil.extractAnnotationClazzes(ProxyProvider.class, scanPath);
        return providerList;
    }

    public static List<RemoteProvider> extractProxyProviders(List<String> providerList) throws ClassNotFoundException {
        ArrayList<RemoteProvider> proxyProviderList = new ArrayList<RemoteProvider>(providerList.size());
        for (String provider : providerList) {
            proxyProviderList.add(new RemoteProvider(Class.forName(provider)));
        }
        return proxyProviderList;
    }

    private static List<String> extractAnnotationClazzes(final Class<?> annotationClazz, String scanPath) throws IOException, ClassNotFoundException {
        Resource[] clazzes = PMRPR.getResources(scanPath);
        final ArrayList<String> clazzList = new ArrayList<String>();
        ClassVisitor anaotationClassVisitor = new ClassVisitor(327680){
            private final String PROXY_REMOTE_INTERFACE;
            private String clazz;
            {
                super(arg0);
                this.PROXY_REMOTE_INTERFACE = "L" + annotationClazz.getName().replaceAll("\\.", "/") + ";";
            }

            public void visit(int i, int i1, String s, String s1, String s2, String[] strings) {
                super.visit(i, i1, s, s1, s2, strings);
                this.clazz = s;
            }

            public AnnotationVisitor visitAnnotation(String s, boolean b) {
                if (this.PROXY_REMOTE_INTERFACE.equals(s)) {
                    clazzList.add(this.clazz.replaceAll("/", "."));
                }
                return super.visitAnnotation(s, b);
            }
        };
        for (Resource clazz : clazzes) {
            ClassReader cr = new ClassReader(clazz.getInputStream());
            cr.accept(anaotationClassVisitor, 0);
        }
        return clazzList;
    }
}

