/*
 * Decompiled with CFR 0.152.
 */
package com.haotian.remote;

import com.haotian.remote.ProxyProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class ProxyXmlWebApplicationContext
extends XmlWebApplicationContext {
    private static final Logger logger = Logger.getLogger(ProxyXmlWebApplicationContext.class.getName());
    private static final PathMatchingResourcePatternResolver PMRPR = new PathMatchingResourcePatternResolver(ProxyXmlWebApplicationContext.class.getClassLoader());
    private static final Map<Class<?>, Set<String>> PROXY_BEAN_MAPPINGS = new HashMap();

    private static final void addProxyBean(Class<?> beanClass, String beanName) {
        Set<String> beanNameSet;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("loaded proxy bean[beanName:" + beanName + ", class:" + beanClass.getName() + "].");
        }
        if ((beanNameSet = PROXY_BEAN_MAPPINGS.get(beanClass)) == null) {
            beanNameSet = new HashSet<String>();
            PROXY_BEAN_MAPPINGS.put(beanClass, beanNameSet);
        }
        if (beanNameSet.contains(beanName)) {
            throw new RuntimeException("[id:" + beanName + ", class:" + beanClass + "] repeated!!!");
        }
        beanNameSet.add(beanName);
    }

    public static final Set<String> getBeanNames(Class<?> beanClass) {
        return PROXY_BEAN_MAPPINGS.get(beanClass);
    }

    /*
     * WARNING - void declaration
     */
    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws IOException {
        String[] configLocations;
        super.loadBeanDefinitions(reader);
        for (String string : configLocations = super.getConfigLocations()) {
            void var6_6;
            Resource[] locations;
            if (string.startsWith("/WEB-INF")) {
                String string2 = "../.." + string;
            }
            if ((locations = PMRPR.getResources((String)var6_6)) == null) continue;
            SAXReader saxReader = new SAXReader();
            for (Resource location : locations) {
                this.parseAndLoadResource(saxReader, location);
            }
        }
    }

    private void loadedProxyBeansAndInitContextProps(Resource contextLocation, Element rootElement, SAXReader saxReader) throws ClassNotFoundException, IOException {
        List beanList = rootElement.elements("bean");
        for (Element bean : beanList) {
            Class<?> beanClass = Class.forName(bean.attributeValue("class"));
            if (beanClass.getAnnotation(ProxyProvider.class) != null) {
                String beanName = bean.attributeValue("id");
                if (beanName == null) {
                    beanName = bean.attributeValue("name");
                }
                if (beanName == null) {
                    throw new RuntimeException("beanName required for class[" + beanClass.getName() + "] in file[" + contextLocation.getFilename() + "]");
                }
                ProxyXmlWebApplicationContext.addProxyBean(beanClass, beanName);
                continue;
            }
            if (!PropertiesFactoryBean.class.isAssignableFrom(beanClass)) continue;
            ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("classpath*:**/" + contextLocation.getFilename());
            String beanName = bean.attributeValue("id");
            if (beanName == null) {
                beanName = bean.attributeValue("name");
            }
            if (beanName != null) continue;
        }
        List importList = rootElement.elements("import");
        for (Element importResource : importList) {
            Resource[] locations;
            for (Resource location : locations = PMRPR.getResources(importResource.attributeValue("resource"))) {
                this.parseAndLoadResource(saxReader, location);
            }
        }
    }

    private void parseAndLoadResource(SAXReader saxReader, Resource location) throws IOException {
        InputStream locationInput = location.getInputStream();
        try {
            this.loadedProxyBeansAndInitContextProps(location, saxReader.read(locationInput).getRootElement(), saxReader);
        }
        catch (Exception e) {
            logger.info("parse bean error:" + e.getMessage() + " for [" + location.getFilename() + "]");
        }
        locationInput.close();
    }
}

