/*
 * Decompiled with CFR 0.152.
 */
package com.haotian.remote;

import com.haotian.remote.AnnotationUtil;
import com.haotian.remote.RemoteConsumer;
import com.haotian.remote.RemoteProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class StartProxyClassListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static Properties CONTEXT_PROPS = new Properties();
    private static final Logger logger = Logger.getLogger(StartProxyClassListener.class.getName());
    private static final Map<Class<?>, Set<String>> PROXY_BEAN_MAPPINGS = new HashMap();

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext context = event.getApplicationContext();
        if (context.getParent() == null) {
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)context.getAutowireCapableBeanFactory());
            try {
                Properties props = (Properties)context.getBean("propertyConfigurer", Properties.class);
                CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)CONTEXT_PROPS);
            }
            catch (Exception e) {
                logger.info("load properties error:" + e.getMessage());
            }
            ArrayList<String> providers = new ArrayList();
            try {
                providers = AnnotationUtil.getProxyProviders(StartProxyClassListener.getScanPath());
                this.dealProxyProviderService(providers);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            List<RemoteProvider> providerList = StartProxyClassListener.extractProviderList(providers);
            List<RemoteConsumer> consumerList = StartProxyClassListener.extractConsumerList(StartProxyClassListener.getScanPath());
            Object classpath = Thread.currentThread().getContextClassLoader().getResource(File.separator).getPath();
            if (!((String)classpath).endsWith(File.separator)) {
                classpath = (String)classpath + File.separator;
            }
            String remoteFileName = "proxy-remote-provider.xml";
            File remoteFile = new File((String)classpath + remoteFileName);
            remoteFile.deleteOnExit();
            try {
                remoteFile.createNewFile();
                FileOutputStream foutput = new FileOutputStream(remoteFile);
                foutput.write(this.generateProviderBeans(providerList));
                foutput.close();
                reader.loadBeanDefinitions("classpath:" + remoteFileName);
                remoteFileName = "proxy-remote-consumer.xml";
                remoteFile = new File((String)classpath + remoteFileName);
                remoteFile.deleteOnExit();
                remoteFile.createNewFile();
                foutput = new FileOutputStream(remoteFile);
                foutput.write(StartProxyClassListener.genenrateConsumerBeans(consumerList, providerList));
                foutput.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            reader.loadBeanDefinitions("classpath:" + remoteFileName);
        }
    }

    private void dealProxyProviderService(List<String> providers) {
        if (providers == null) {
            return;
        }
        for (String provider : providers) {
            Service annotation;
            Class<?> serviceClass = null;
            try {
                serviceClass = Class.forName(provider);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if ((annotation = serviceClass.getAnnotation(Service.class)) == null) continue;
            Object beanName = annotation.value();
            if (StringUtils.isEmpty((Object)beanName)) {
                beanName = serviceClass.getSimpleName();
                String big = ((String)beanName).substring(0, 1);
                String small = big.toLowerCase();
                beanName = small + ((String)beanName).substring(1);
            }
            StartProxyClassListener.addProxyBean(serviceClass, (String)beanName);
        }
    }

    private static final void addProxyBean(Class<?> beanClass, String beanName) {
        Set<String> beanNameSet;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("loaded proxy bean[beanName:" + beanName + ", class:" + beanClass.getName() + "].");
        }
        if ((beanNameSet = PROXY_BEAN_MAPPINGS.get(beanClass)) == null) {
            beanNameSet = new HashSet<String>();
            PROXY_BEAN_MAPPINGS.put(beanClass, beanNameSet);
        }
        if (beanNameSet.contains(beanName)) {
            throw new RuntimeException("[id:" + beanName + ", class:" + beanClass + "] repeated!!!");
        }
        beanNameSet.add(beanName);
    }

    public static final Set<String> getBeanNames(Class<?> beanClass) {
        return PROXY_BEAN_MAPPINGS.get(beanClass);
    }

    public static List<RemoteConsumer> extractConsumerList(String scanPath) {
        List<RemoteConsumer> consumerList;
        try {
            consumerList = AnnotationUtil.extractProxyConsumers(scanPath);
        }
        catch (Exception e) {
            throw new RuntimeException("extract proxyconsumer error", e);
        }
        return consumerList;
    }

    public static List<RemoteProvider> extractProviderList(List<String> providers) {
        List<RemoteProvider> providerList;
        try {
            providerList = AnnotationUtil.extractProxyProviders(providers);
        }
        catch (Exception e) {
            throw new RuntimeException("extract proxyprovider error", e);
        }
        return providerList;
    }

    public static String getScanPath() {
        String scanPath = CONTEXT_PROPS.getProperty("sys.scanPath");
        if (scanPath == null) {
            scanPath = "classpath*:com/chinaunicom/**/*.class";
        }
        return scanPath;
    }

    private static String getRemoteStrategy() {
        String remoteStrategy = CONTEXT_PROPS.getProperty("remote.strategy");
        if (remoteStrategy == null) {
            remoteStrategy = "HSF";
        }
        return remoteStrategy;
    }

    public static byte[] genenrateConsumerBeans(List<RemoteConsumer> consumers, List<RemoteProvider> providerList) {
        byte[] springBeans;
        byte[] byArray = springBeans = StartProxyClassListener.getRemoteStrategy().equals("HSF") ? StartProxyClassListener.generateHsfConsumerBeans(consumers, providerList) : StartProxyClassListener.generateHsfConsumerBeans(consumers, providerList);
        if (logger.isLoggable(Level.INFO)) {
            logger.info(new String(springBeans));
        }
        return springBeans;
    }

    private byte[] generateProviderBeans(List<RemoteProvider> providers) {
        byte[] springBeans;
        byte[] byArray = springBeans = StartProxyClassListener.getRemoteStrategy().equals("HSF") ? this.generateHsfProviderBeans(providers) : this.generateHsfProviderBeans(providers);
        if (logger.isLoggable(Level.INFO)) {
            logger.info(new String(springBeans));
        }
        return springBeans;
    }

    private static byte[] generateHsfConsumerBeans(List<RemoteConsumer> consumers, List<RemoteProvider> providerList) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream print = new PrintStream(output);
        HashMap<CallSite, String> providerInterfaces = new HashMap<CallSite, String>();
        for (RemoteProvider provider : providerList) {
            String providerVersion = StartProxyClassListener.getRealValue(provider.getVersion());
            String providerGroup = StartProxyClassListener.getRealValue(provider.getGroup());
            providerInterfaces.put((CallSite)((Object)(provider.getInterface() + ":" + providerVersion + ":" + providerGroup)), provider.getRef());
        }
        print.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        print.println("<beans xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        print.println("xmlns:hsf=\"http://www.taobao.com/hsf\"");
        print.println("xmlns=\"http://www.springframework.org/schema/beans\"");
        print.println("xsi:schemaLocation=\"http://www.springframework.org/schema/beans");
        print.println("http://www.springframework.org/schema/beans/spring-beans-2.5.xsd");
        print.println("http://www.taobao.com/hsf");
        print.println("http://www.taobao.com/hsf/hsf.xsd\">");
        for (RemoteConsumer consumer : consumers) {
            String consumerVersion = StartProxyClassListener.getRealValue(consumer.getVersion());
            String consumerGroup = StartProxyClassListener.getRealValue(consumer.getGroup());
            if (!providerInterfaces.containsKey(consumer.getInterface() + ":" + consumerVersion + ":" + consumerGroup)) {
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.info("consumer[" + consumer.getInterface() + ":" + consumerVersion + ":" + consumerGroup + "]'s provider exists; Do not publish consumer.");
                continue;
            }
            String beanId = StartProxyClassListener.getRealValue(consumer.getBeanId());
            if (beanId == null || "".equals(beanId)) {
                throw new RuntimeException("consumerId required[" + consumer.getInterface());
            }
            if (providerInterfaces.containsValue(beanId)) {
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.info("consumer[" + beanId + ":" + consumer.getInterface() + ":" + consumer.getVersion() + ":" + consumer.getGroup() + "]'s conflict.");
                continue;
            }
            print.print("<hsf:consumer");
            print.print(" id=\"");
            print.print(beanId);
            print.print("\"");
            print.print(" interface=\"");
            print.print(StartProxyClassListener.getRealValue(consumer.getInterface()));
            print.print("\"");
            print.print(" version=\"");
            print.print(StartProxyClassListener.getRealValue(consumer.getVersion()));
            print.print("\"");
            if (consumer.getGroup() != null && !"".equals(consumer.getGroup())) {
                print.print(" group=\"");
                print.print(StartProxyClassListener.getRealValue(consumer.getGroup()));
                print.print("\"");
            }
            if (consumer.getTarget() != null && !"".equals(consumer.getTarget())) {
                print.print(" target=\"");
                print.print(StartProxyClassListener.getRealValue(consumer.getTarget()));
                print.print("\"");
            }
            if (consumer.getClientTimeout() != 0L) {
                print.print(" clientTimeout=\"");
                print.print(consumer.getClientTimeout());
                print.print("\"");
            }
            if (consumer.getConnectionNum() != 0) {
                print.print(" connectionNum=\"");
                print.print(consumer.getConnectionNum());
                print.print("\"");
            }
            print.println("></hsf:consumer>");
        }
        print.println("</beans>");
        print.flush();
        print.close();
        return output.toByteArray();
    }

    private byte[] generateHsfProviderBeans(List<RemoteProvider> providers) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream print = new PrintStream(output);
        print.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        print.println("<beans xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        print.println("xmlns:hsf=\"http://www.taobao.com/hsf\"");
        print.println("xmlns=\"http://www.springframework.org/schema/beans\"");
        print.println("xsi:schemaLocation=\"http://www.springframework.org/schema/beans");
        print.println("http://www.springframework.org/schema/beans/spring-beans-2.5.xsd");
        print.println("http://www.taobao.com/hsf");
        print.println("http://www.taobao.com/hsf/hsf.xsd\">");
        for (RemoteProvider provider : providers) {
            String providerRef = StartProxyClassListener.getRealValue(provider.getRef());
            if (providerRef == null || "".equals(providerRef)) {
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.info("Provider [" + StartProxyClassListener.getRealValue(provider.getInterface()) + ":" + StartProxyClassListener.getRealValue(provider.getVersion()) + "] ref not exists.");
                continue;
            }
            print.print("<hsf:provider");
            print.print(" id=\"");
            print.print(providerRef + "-" + StartProxyClassListener.getRealValue(provider.getVersion()) + "-provider");
            print.print("\"");
            print.print(" interface=\"");
            print.print(StartProxyClassListener.getRealValue(provider.getInterface()));
            print.print("\"");
            print.print(" ref=\"");
            print.print(StartProxyClassListener.getRealValue(provider.getRef()));
            print.print("\"");
            print.print(" version=\"");
            print.print(StartProxyClassListener.getRealValue(provider.getVersion()));
            print.print("\"");
            if (provider.getGroup() != null && !"".equals(provider.getGroup())) {
                print.print(" group=\"");
                print.print(StartProxyClassListener.getRealValue(provider.getGroup()));
                print.print("\"");
            }
            if (provider.getClientTimeout() != 0L) {
                print.print(" clientTimeout=\"");
                print.print(provider.getClientTimeout());
                print.print("\"");
            }
            if (provider.getCorePoolSize() != 0) {
                print.print(" corePoolSize=\"");
                print.print(provider.getCorePoolSize());
                print.print("\"");
            }
            if (provider.getMaxPoolSize() != 0) {
                print.print(" maxPoolSize=\"");
                print.print(provider.getMaxPoolSize());
                print.print("\"");
            }
            if (provider.getSerializeType() != null && !"".equals(provider.getSerializeType())) {
                print.print(" serializeType=\"");
                print.print(StartProxyClassListener.getRealValue(provider.getSerializeType()));
                print.print("\"");
            }
            print.println("></hsf:provider>");
        }
        print.println("</beans>");
        print.flush();
        print.close();
        return output.toByteArray();
    }

    private static String getRealValue(String value) {
        if (value == null || !value.startsWith("${") || !value.endsWith("}")) {
            return value;
        }
        String key = value.substring(2, value.length() - 1);
        if (CONTEXT_PROPS.getProperty(key) != null) {
            return CONTEXT_PROPS.getProperty(key);
        }
        if ("LIQUIDATION_VERSION".equals(key)) {
            return "1.0.0";
        }
        if ("LIQUIDATION_GROUP".equals(key)) {
            return "LIQUIDATION_DEV_GROUP";
        }
        if ("MANAGE_VERSION".equals(key)) {
            return "1.0.0";
        }
        if ("MANAGE_GROUP".equals(key)) {
            return "MANAGE_DEV_GROUP";
        }
        if ("SETTLEMENT_VERSION".equals(key)) {
            return "1.0.0";
        }
        if ("SETTLEMENT_GROUP".equals(key)) {
            return "SETTLEMENT_DEV_GROUP";
        }
        return CONTEXT_PROPS.getProperty(key);
    }
}

