/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.autoadapter;

import com.haotian.remote.ProxyAnnotationXmlWebApplicationContext;
import com.haotian.remote.ProxyConsumer;
import com.haotian.remote.ProxyProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ServiceLoad {
    private static final Logger LOGGER = Logger.getLogger(ProxyAnnotationXmlWebApplicationContext.class.getName());
    private static Properties CONTEXT_PROPS = new Properties();
    private static final Map<Class<?>, Set<String>> PROVIDER_BEAN_MAPPINGS = new HashMap();
    private static final Map<Class<?>, Set<String>> CONSUMER_BEAN_MAPPINGS = new HashMap();
    private static final PathMatchingResourcePatternResolver PMRPR = new PathMatchingResourcePatternResolver(ProxyAnnotationXmlWebApplicationContext.class.getClassLoader());
    private static Boolean DUBBO_APPLICATION_NAMED = false;
    private static Boolean CUSTOM_ANNOTATION_ENABLE = false;

    public void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws IOException {
        String consumerScanPath;
        String providerScanPath;
        LOGGER.info("StartXmlWebApplicationContext LoadBeanDefinitions Start");
        this.getPropertiesByApplicationContext();
        if (!StringUtils.isEmpty((Object)this.getProperty("custom.annotation.enable")) && "true".equals(this.getProperty("custom.annotation.enable"))) {
            CUSTOM_ANNOTATION_ENABLE = true;
        }
        if (!StringUtils.isEmpty((Object)(providerScanPath = this.getProperty("sys.provider.scanPath")))) {
            if (CUSTOM_ANNOTATION_ENABLE.booleanValue()) {
                this.generateProviderXmlWithCustomAnnotation(providerScanPath, reader);
            } else {
                this.generateProviderXml(providerScanPath, reader);
            }
        }
        if (!StringUtils.isEmpty((Object)(consumerScanPath = this.getProperty("sys.consumer.scanPath")))) {
            if (CUSTOM_ANNOTATION_ENABLE.booleanValue()) {
                this.generateConsumerXmlWithCustomAnntation(consumerScanPath, reader);
            } else {
                this.generateConsumerXml(consumerScanPath, reader);
            }
        }
        LOGGER.info("StartXmlWebApplicationContext LoadBeanDefinitions End");
    }

    private void getPropertiesByApplicationContext() {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("classpath*:**/spring-properties-loader.xml");
        Properties props = (Properties)applicationContext.getBean("propertyConfigurer", Properties.class);
        if (props != null) {
            CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)CONTEXT_PROPS);
        } else {
            this.getPropertiesByPath();
        }
    }

    private void getPropertiesByPath() {
        String classpath = Thread.currentThread().getContextClassLoader().getResource("").getPath();
        Properties props = new Properties();
        try {
            FileInputStream in = new FileInputStream(classpath + "default.properties");
            props.load(in);
            in.close();
            CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)CONTEXT_PROPS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dealProxyConsumerService(List<String> consumers) {
        if (consumers == null) {
            return;
        }
        for (String consumer : consumers) {
            Class<?> serviceClass = null;
            try {
                serviceClass = Class.forName(consumer);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            Object beanName = consumer.substring(consumer.lastIndexOf(".") + 1);
            String big = ((String)beanName).substring(0, 1);
            String small = big.toLowerCase();
            beanName = small + ((String)beanName).substring(1);
            this.addConsumerBean(serviceClass, (String)beanName);
        }
    }

    private void addConsumerBean(Class<?> beanClass, String beanName) {
        Set<String> beanNameSet;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("loaded proxy consumer bean[beanName:" + beanName + ", class:" + beanClass.getName() + "].");
        }
        if ((beanNameSet = CONSUMER_BEAN_MAPPINGS.get(beanClass)) == null) {
            beanNameSet = new HashSet<String>();
            CONSUMER_BEAN_MAPPINGS.put(beanClass, beanNameSet);
        }
        if (beanNameSet.contains(beanName)) {
            throw new RuntimeException("[id:" + beanName + ", class:" + beanClass + "] repeated!!!");
        }
        beanNameSet.add(beanName);
    }

    private void generateConsumerXml(String consumerScanPath, XmlBeanDefinitionReader reader) {
        try {
            List<String> consumers = this.extractWithoutAnnotationClazzes(consumerScanPath);
            this.dealProxyConsumerService(consumers);
            String classpath = Thread.currentThread().getContextClassLoader().getResource("").getPath();
            String consumerFileName = this.getProperty("consumer.file.name");
            if (StringUtils.isEmpty((Object)consumerFileName)) {
                consumerFileName = "proxy-remote-consumer";
            }
            File consumerFile = new File(classpath + consumerFileName + ".xml");
            consumerFile.deleteOnExit();
            consumerFile.createNewFile();
            FileOutputStream foutput = new FileOutputStream(consumerFile);
            foutput.write(this.generateConsumerBeans(consumers));
            foutput.close();
            reader.loadBeanDefinitions("classpath:" + consumerFileName + ".xml");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateConsumerXmlWithCustomAnntation(String consumerScanPath, XmlBeanDefinitionReader reader) {
        try {
            List<String> consumers = this.extractAnnotationClazzes(ProxyConsumer.class, consumerScanPath);
            this.dealProxyConsumerService(consumers);
            String classpath = Thread.currentThread().getContextClassLoader().getResource("").getPath();
            String consumerFileName = this.getProperty("consumer.file.name");
            if (StringUtils.isEmpty((Object)consumerFileName)) {
                consumerFileName = "proxy-remote-consumer";
            }
            File consumerFile = new File(classpath + consumerFileName + ".xml");
            consumerFile.deleteOnExit();
            consumerFile.createNewFile();
            FileOutputStream foutput = new FileOutputStream(consumerFile);
            foutput.write(this.generateConsumerBeansWithCustomAnnotation(consumers));
            foutput.close();
            reader.loadBeanDefinitions("classpath:" + consumerFileName + ".xml");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateProviderXml(String providerScanPath, XmlBeanDefinitionReader reader) {
        try {
            List<String> providerClasses = this.extractAnnotationClazzes(Service.class, providerScanPath);
            List<String> providers = this.dealProxyProviderService(providerClasses);
            String classpath = Thread.currentThread().getContextClassLoader().getResource("").getPath();
            String providerFileName = this.getProperty("privider.file.name");
            if (StringUtils.isEmpty((Object)providerFileName)) {
                providerFileName = "proxy-remote-provider";
            }
            File providerFile = new File(classpath + providerFileName + ".xml");
            providerFile.deleteOnExit();
            providerFile.createNewFile();
            FileOutputStream foutput = new FileOutputStream(providerFile);
            foutput.write(this.generateProviderBeans(providers));
            foutput.close();
            reader.loadBeanDefinitions("classpath:" + providerFileName + ".xml");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateProviderXmlWithCustomAnnotation(String providerScanPath, XmlBeanDefinitionReader reader) {
        try {
            List<String> providerClasses = this.extractAnnotationClazzes(ProxyProvider.class, providerScanPath);
            List<String> providers = this.dealProxyProviderService(providerClasses);
            String classpath = Thread.currentThread().getContextClassLoader().getResource("").getPath();
            String providerFileName = this.getProperty("privider.file.name");
            if (StringUtils.isEmpty((Object)providerFileName)) {
                providerFileName = "proxy-remote-provider";
            }
            File providerFile = new File(classpath + providerFileName + ".xml");
            providerFile.deleteOnExit();
            providerFile.createNewFile();
            FileOutputStream foutput = new FileOutputStream(providerFile);
            foutput.write(this.generateProviderBeansWithCustomAnnotation(providers));
            foutput.close();
            reader.loadBeanDefinitions("classpath:" + providerFileName + ".xml");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<String> extractWithoutAnnotationClazzes(String scanPath) throws IOException, ClassNotFoundException {
        final ArrayList<String> clazzList = new ArrayList<String>();
        ClassVisitor anaotationClassVisitor = new ClassVisitor(327680){
            private String clazz;

            public void visit(int i, int i1, String s, String s1, String s2, String[] strings) {
                super.visit(i, i1, s, s1, s2, strings);
                this.clazz = s;
                clazzList.add(this.clazz.replaceAll("/", "."));
            }

            public AnnotationVisitor visitAnnotation(String s, boolean b) {
                return super.visitAnnotation(s, b);
            }
        };
        if (!StringUtils.isEmpty((Object)scanPath)) {
            String[] scanPaths = scanPath.split(",");
            for (int i = 0; i < scanPaths.length; ++i) {
                Resource[] clazzes;
                String path = "classpath*:" + scanPaths[i].replace(".", "/") + "/*.class";
                for (Resource clazz : clazzes = PMRPR.getResources(path)) {
                    ClassReader cr = new ClassReader(clazz.getInputStream());
                    cr.accept(anaotationClassVisitor, 0);
                }
            }
        }
        return clazzList;
    }

    private byte[] generateConsumerBeans(List<String> consumers) {
        byte[] springBeans;
        String remoteStrategy = this.getProperty("remote.strategy");
        byte[] byArray = springBeans = remoteStrategy.equals("DUBBO") ? this.generateDubboConsumerBeans(consumers) : this.generateHsfConsumerBeans(consumers);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(new String(springBeans));
        }
        return springBeans;
    }

    private byte[] generateConsumerBeansWithCustomAnnotation(List<String> consumers) {
        byte[] springBeans;
        String remoteStrategy = this.getProperty("remote.strategy");
        byte[] byArray = springBeans = remoteStrategy.equals("DUBBO") ? this.generateDubboConsumerBeansWithCustomAnnotation(consumers) : this.generateHsfConsumerBeansWithCustomAnnotation(consumers);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(new String(springBeans));
        }
        return springBeans;
    }

    private byte[] generateProviderBeans(List<String> providers) {
        byte[] springBeans;
        String remoteStrategy = this.getProperty("remote.strategy");
        byte[] byArray = springBeans = remoteStrategy.equals("DUBBO") ? this.generateDubboProviderBeans(providers) : this.generateHsfProviderBeans(providers);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(new String(springBeans));
        }
        return springBeans;
    }

    private byte[] generateProviderBeansWithCustomAnnotation(List<String> providers) {
        byte[] springBeans;
        String remoteStrategy = this.getProperty("remote.strategy");
        byte[] byArray = springBeans = remoteStrategy.equals("DUBBO") ? this.generateDubboProviderBeansWithCustomAnnotation(providers) : this.generateHsfProviderBeansWithCustomAnnotation(providers);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(new String(springBeans));
        }
        return springBeans;
    }

    private byte[] generateDubboConsumerBeansWithCustomAnnotation(List<String> consumers) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream print = new PrintStream(output);
        print.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        print.println("<beans xmlns=\"http://www.springframework.org/schema/beans\"");
        print.println("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        print.println("xmlns:dubbo=\"http://code.alibabatech.com/schema/dubbo\"");
        print.println("xsi:schemaLocation=\"http://www.springframework.org/schema/beans");
        print.println("http://www.springframework.org/schema/beans/spring-beans.xsd");
        print.println("http://code.alibabatech.com/schema/dubbo");
        print.println("http://code.alibabatech.com/schema/dubbo/dubbo.xsd\">");
        String dubboApplicationName = "";
        dubboApplicationName = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.application.name")) ? CONTEXT_PROPS.getProperty("dubbo.application.name") : "remote-dubbo-application";
        String dubboRegistryAddress = "";
        dubboRegistryAddress = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.registry.address")) ? CONTEXT_PROPS.getProperty("dubbo.registry.address") : "zookeeper://127.0.0.1:2181";
        if (!DUBBO_APPLICATION_NAMED.booleanValue()) {
            print.print("<dubbo:application");
            print.print(" name=\"");
            print.print(dubboApplicationName);
            print.println("\" ></dubbo:application>");
        }
        print.print("<dubbo:registry");
        print.print(" address=\"");
        print.print(dubboRegistryAddress);
        print.println("\" ></dubbo:registry>");
        for (String consumer : consumers) {
            String dubboServiceGroup;
            String dubboServiceVersion;
            Class<?> consumerClazz = null;
            try {
                consumerClazz = Class.forName(consumer);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ProxyConsumer proxyConsumer = consumerClazz.getAnnotation(ProxyConsumer.class);
            String intface = consumer;
            String beanId = "";
            Set<String> refSet = this.getConsumerBeanNames(consumerClazz);
            if (refSet == null || refSet.size() != 1) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("consumer [" + intface + "] ref not exists.");
                continue;
            }
            beanId = refSet.iterator().next();
            String consumerId = proxyConsumer.beanId();
            if (StringUtils.isEmpty((Object)consumerId)) {
                consumerId = beanId;
            }
            if (StringUtils.isEmpty((Object)(dubboServiceVersion = proxyConsumer.version()))) {
                dubboServiceVersion = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.service.version")) ? CONTEXT_PROPS.getProperty("dubbo.service.version") : "1.0.0";
            }
            if (StringUtils.isEmpty((Object)(dubboServiceGroup = proxyConsumer.group()))) {
                dubboServiceGroup = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.service.group")) ? CONTEXT_PROPS.getProperty("dubbo.service.group") : "REMOTE_DEFAULT_GROUP";
            }
            String dubboServiceLazy = String.valueOf(proxyConsumer.lazy());
            String dubboServiceLoadbalance = proxyConsumer.loadbalance();
            if (StringUtils.isEmpty((Object)dubboServiceLoadbalance)) {
                dubboServiceLoadbalance = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.service.loadbalance")) ? CONTEXT_PROPS.getProperty("dubbo.service.loadbalance") : "random";
            }
            String dubboConsumerCheck = String.valueOf(proxyConsumer.check());
            print.print("<dubbo:reference");
            print.print(" id=\"");
            print.print(consumerId);
            print.print("\"");
            print.print(" interface=\"");
            print.print(intface);
            print.print("\"");
            print.print(" version=\"");
            print.print(dubboServiceVersion);
            print.print("\"");
            print.print(" group=\"");
            print.print(dubboServiceGroup);
            print.print("\"");
            print.print(" lazy=\"");
            print.print(dubboServiceLazy);
            print.print("\"");
            print.print(" loadbalance=\"");
            print.print(dubboServiceLoadbalance);
            print.print("\"");
            print.print(" check=\"");
            print.print(dubboConsumerCheck);
            print.print("\"");
            print.println("></dubbo:reference>");
        }
        print.println("</beans>");
        print.flush();
        print.close();
        return output.toByteArray();
    }

    private byte[] generateDubboConsumerBeans(List<String> consumers) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream print = new PrintStream(output);
        print.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        print.println("<beans xmlns=\"http://www.springframework.org/schema/beans\"");
        print.println("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        print.println("xmlns:dubbo=\"http://code.alibabatech.com/schema/dubbo\"");
        print.println("xsi:schemaLocation=\"http://www.springframework.org/schema/beans");
        print.println("http://www.springframework.org/schema/beans/spring-beans.xsd");
        print.println("http://code.alibabatech.com/schema/dubbo");
        print.println("http://code.alibabatech.com/schema/dubbo/dubbo.xsd\">");
        String dubboApplicationName = "";
        dubboApplicationName = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.application.name")) ? CONTEXT_PROPS.getProperty("dubbo.application.name") : "remote-dubbo-application";
        String dubboRegistryAddress = "";
        dubboRegistryAddress = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.registry.address")) ? CONTEXT_PROPS.getProperty("dubbo.registry.address") : "zookeeper://127.0.0.1:2181";
        String dubboServiceVersion = "";
        dubboServiceVersion = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.service.version")) ? CONTEXT_PROPS.getProperty("dubbo.service.version") : "1.0.0";
        String dubboServiceGroup = "";
        dubboServiceGroup = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.service.group")) ? CONTEXT_PROPS.getProperty("dubbo.service.group") : "REMOTE_DEFAULT_GROUP";
        String dubboServiceLazy = "";
        dubboServiceLazy = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.service.lazy")) ? CONTEXT_PROPS.getProperty("dubbo.service.lazy") : "true";
        String dubboServiceLoadbalance = "";
        dubboServiceLoadbalance = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.service.loadbalance")) ? CONTEXT_PROPS.getProperty("dubbo.service.loadbalance") : "random";
        String dubboConsumerCheck = "";
        dubboConsumerCheck = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.consumer.check")) ? CONTEXT_PROPS.getProperty("dubbo.consumer.check") : "true";
        if (!DUBBO_APPLICATION_NAMED.booleanValue()) {
            print.print("<dubbo:application");
            print.print(" name=\"");
            print.print(dubboApplicationName);
            print.println("\" ></dubbo:application>");
        }
        print.print("<dubbo:registry");
        print.print(" address=\"");
        print.print(dubboRegistryAddress);
        print.println("\" ></dubbo:registry>");
        for (String consumer : consumers) {
            Class<?> consumerClazz = null;
            try {
                consumerClazz = Class.forName(consumer);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            String intface = consumer;
            String consumerId = "";
            Set<String> refSet = this.getConsumerBeanNames(consumerClazz);
            if (refSet == null || refSet.size() != 1) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("consumer [" + intface + "] ref not exists.");
                continue;
            }
            consumerId = refSet.iterator().next();
            print.print("<dubbo:reference");
            print.print(" id=\"");
            print.print(consumerId);
            print.print("\"");
            print.print(" interface=\"");
            print.print(intface);
            print.print("\"");
            print.print(" version=\"");
            print.print(dubboServiceVersion);
            print.print("\"");
            print.print(" group=\"");
            print.print(dubboServiceGroup);
            print.print("\"");
            print.print(" lazy=\"");
            print.print(dubboServiceLazy);
            print.print("\"");
            print.print(" loadbalance=\"");
            print.print(dubboServiceLoadbalance);
            print.print("\"");
            print.print(" check=\"");
            print.print(dubboConsumerCheck);
            print.print("\"");
            print.println("></dubbo:reference>");
        }
        print.println("</beans>");
        print.flush();
        print.close();
        return output.toByteArray();
    }

    private byte[] generateHsfConsumerBeansWithCustomAnnotation(List<String> consumers) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream print = new PrintStream(output);
        print.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        print.println("<beans xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        print.println("xmlns:hsf=\"http://www.taobao.com/hsf\"");
        print.println("xmlns=\"http://www.springframework.org/schema/beans\"");
        print.println("xsi:schemaLocation=\"http://www.springframework.org/schema/beans");
        print.println("http://www.springframework.org/schema/beans/spring-beans-2.5.xsd");
        print.println("http://www.taobao.com/hsf");
        print.println("http://www.taobao.com/hsf/hsf.xsd\" default-autowire=\"byName\">");
        for (String consumer : consumers) {
            String consumerConnectionNum;
            String consumerTarget;
            String consumerClientTimeout;
            String consumerGroup;
            String consumerVersion;
            Class<?> consumerClazz = null;
            try {
                consumerClazz = Class.forName(consumer);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ProxyConsumer proxyConsumer = consumerClazz.getAnnotation(ProxyConsumer.class);
            String intface = consumer;
            String beanId = "";
            Set<String> refSet = this.getConsumerBeanNames(consumerClazz);
            if (refSet == null || refSet.size() != 1) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("consumer [" + intface + "] id not exists.");
                continue;
            }
            beanId = refSet.iterator().next();
            String consumerId = proxyConsumer.beanId();
            if (StringUtils.isEmpty((Object)consumerId)) {
                consumerId = beanId;
            }
            if (StringUtils.isEmpty((Object)(consumerVersion = proxyConsumer.version()))) {
                consumerVersion = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.version")) ? CONTEXT_PROPS.getProperty("hsf.version") : "1.0.0";
            }
            if (StringUtils.isEmpty((Object)(consumerGroup = proxyConsumer.group()))) {
                consumerGroup = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.group")) ? CONTEXT_PROPS.getProperty("hsf.group") : "REMOTE_DEFAULT_GROUP";
            }
            if (StringUtils.isEmpty((Object)(consumerClientTimeout = String.valueOf(proxyConsumer.clientTimeout()))) || "0".equals(consumerClientTimeout)) {
                consumerClientTimeout = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.clientTimeout")) ? CONTEXT_PROPS.getProperty("hsf.clientTimeout") : "60000";
            }
            if (StringUtils.isEmpty((Object)(consumerTarget = proxyConsumer.target()))) {
                consumerTarget = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.target")) ? CONTEXT_PROPS.getProperty("hsf.target") : "";
            }
            if (StringUtils.isEmpty((Object)(consumerConnectionNum = String.valueOf(proxyConsumer.connectionNum()))) || "0".equals(consumerConnectionNum)) {
                consumerConnectionNum = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.connectionNum")) ? CONTEXT_PROPS.getProperty("hsf.connectionNum") : "";
            }
            print.print("<hsf:consumer");
            print.print(" id=\"");
            print.print(consumerId);
            print.print("\"");
            print.print(" interface=\"");
            print.print(intface);
            print.print("\"");
            print.print(" version=\"");
            print.print(consumerVersion);
            print.print("\"");
            print.print(" group=\"");
            print.print(consumerGroup);
            print.print("\"");
            print.print(" clientTimeout=\"");
            print.print(consumerClientTimeout);
            print.print("\"");
            if (!StringUtils.isEmpty((Object)consumerTarget)) {
                print.print(" target=\"");
                print.print(consumerTarget);
                print.print("\"");
            }
            if (!StringUtils.isEmpty((Object)consumerConnectionNum)) {
                print.print(" connectionNum=\"");
                print.print(consumerConnectionNum);
                print.print("\"");
            }
            print.println("></hsf:consumer>");
        }
        print.println("</beans>");
        print.flush();
        print.close();
        return output.toByteArray();
    }

    private byte[] generateHsfConsumerBeans(List<String> consumers) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream print = new PrintStream(output);
        print.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        print.println("<beans xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        print.println("xmlns:hsf=\"http://www.taobao.com/hsf\"");
        print.println("xmlns=\"http://www.springframework.org/schema/beans\"");
        print.println("xsi:schemaLocation=\"http://www.springframework.org/schema/beans");
        print.println("http://www.springframework.org/schema/beans/spring-beans-2.5.xsd");
        print.println("http://www.taobao.com/hsf");
        print.println("http://www.taobao.com/hsf/hsf.xsd\" default-autowire=\"byName\">");
        String consumerVersion = "";
        consumerVersion = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.version")) ? CONTEXT_PROPS.getProperty("hsf.version") : "1.0.0";
        String consumerGroup = "";
        consumerGroup = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.group")) ? CONTEXT_PROPS.getProperty("hsf.group") : "REMOTE_DEFAULT_GROUP";
        String consumerClientTimeout = "";
        consumerClientTimeout = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.clientTimeout")) ? CONTEXT_PROPS.getProperty("hsf.clientTimeout") : "60000";
        String consumerTarget = "";
        if (!StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.target"))) {
            consumerTarget = CONTEXT_PROPS.getProperty("hsf.target");
        }
        String consumerConnectionNum = "";
        if (!StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.connectionNum"))) {
            consumerConnectionNum = CONTEXT_PROPS.getProperty("hsf.connectionNum");
        }
        for (String consumer : consumers) {
            Class<?> consumerClazz = null;
            try {
                consumerClazz = Class.forName(consumer);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            String intface = consumer;
            String consumerId = "";
            Set<String> refSet = this.getConsumerBeanNames(consumerClazz);
            if (refSet == null || refSet.size() != 1) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("consumer [" + intface + "] id not exists.");
                continue;
            }
            consumerId = refSet.iterator().next();
            print.print("<hsf:consumer");
            print.print(" id=\"");
            print.print(consumerId);
            print.print("\"");
            print.print(" interface=\"");
            print.print(intface);
            print.print("\"");
            print.print(" version=\"");
            print.print(consumerVersion);
            print.print("\"");
            print.print(" group=\"");
            print.print(consumerGroup);
            print.print("\"");
            print.print(" clientTimeout=\"");
            print.print(consumerClientTimeout);
            print.print("\"");
            if (!StringUtils.isEmpty((Object)consumerTarget)) {
                print.print(" target=\"");
                print.print(consumerTarget);
                print.print("\"");
            }
            if (!StringUtils.isEmpty((Object)consumerConnectionNum)) {
                print.print(" connectionNum=\"");
                print.print(consumerConnectionNum);
                print.print("\"");
            }
            print.println("></hsf:consumer>");
        }
        print.println("</beans>");
        print.flush();
        print.close();
        return output.toByteArray();
    }

    private byte[] generateDubboProviderBeansWithCustomAnnotation(List<String> providers) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream print = new PrintStream(output);
        print.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        print.println("<beans xmlns=\"http://www.springframework.org/schema/beans\"");
        print.println("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        print.println("xmlns:dubbo=\"http://code.alibabatech.com/schema/dubbo\"");
        print.println("xsi:schemaLocation=\"http://www.springframework.org/schema/beans");
        print.println("http://www.springframework.org/schema/beans/spring-beans.xsd");
        print.println("http://code.alibabatech.com/schema/dubbo");
        print.println("http://code.alibabatech.com/schema/dubbo/dubbo.xsd\">");
        String dubboApplicationName = "";
        dubboApplicationName = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.application.name")) ? CONTEXT_PROPS.getProperty("dubbo.application.name") : "remote-dubbo-application";
        String dubboRegistryAddress = "";
        dubboRegistryAddress = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.registry.address")) ? CONTEXT_PROPS.getProperty("dubbo.registry.address") : "zookeeper://127.0.0.1:2181";
        String dubboProtocolName = "";
        dubboProtocolName = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.protocol.name")) ? CONTEXT_PROPS.getProperty("dubbo.protocol.name") : "dubbo";
        String dubboProtocolPort = "";
        dubboProtocolPort = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.protocol.port")) ? CONTEXT_PROPS.getProperty("dubbo.protocol.port") : "20880";
        String dubboProtocolThreadpool = "";
        dubboProtocolThreadpool = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.protocol.threadpool")) ? CONTEXT_PROPS.getProperty("dubbo.protocol.threadpool") : "cached";
        String dubboProtocolThreads = "";
        dubboProtocolThreads = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.protocol.threads")) ? CONTEXT_PROPS.getProperty("dubbo.protocol.threads") : "100";
        print.print("<dubbo:application");
        print.print(" name=\"");
        print.print(dubboApplicationName);
        print.println("\" ></dubbo:application>");
        print.print("<dubbo:registry");
        print.print(" address=\"");
        print.print(dubboRegistryAddress);
        print.println("\" ></dubbo:registry>");
        print.print("<dubbo:protocol");
        print.print(" name=\"");
        print.print(dubboProtocolName);
        print.print("\"");
        print.print(" port=\"");
        print.print(dubboProtocolPort);
        print.print("\"");
        print.print(" threadpool=\"");
        print.print(dubboProtocolThreadpool);
        print.print("\"");
        print.print(" threads=\"");
        print.print(dubboProtocolThreads);
        print.println("\" ></dubbo:protocol>");
        for (String provider : providers) {
            String dubboServiceTimeout;
            String dubboServiceRetries;
            String dubboServiceGroup;
            String dubboServiceVersion;
            Class<?> providerClazz = null;
            try {
                providerClazz = Class.forName(provider);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ProxyProvider proxyProvider = providerClazz.getAnnotation(ProxyProvider.class);
            String intface = providerClazz.getInterfaces()[0].getName();
            String providerRef = "";
            Set<String> refSet = this.getProviderBeanNames(providerClazz);
            if (refSet == null || refSet.size() != 1) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("Provider [" + intface + "] ref not exists.");
                continue;
            }
            providerRef = refSet.iterator().next();
            String dubboServiceDelay = String.valueOf(proxyProvider.delay());
            if (StringUtils.isEmpty((Object)dubboServiceDelay) || "0".equals(dubboServiceDelay)) {
                dubboServiceDelay = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.service.delay")) ? CONTEXT_PROPS.getProperty("dubbo.service.delay") : "-1";
            }
            if (StringUtils.isEmpty((Object)(dubboServiceVersion = proxyProvider.version()))) {
                dubboServiceVersion = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.service.version")) ? CONTEXT_PROPS.getProperty("dubbo.service.version") : "1.0.0";
            }
            if (StringUtils.isEmpty((Object)(dubboServiceGroup = proxyProvider.group()))) {
                dubboServiceGroup = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.service.group")) ? CONTEXT_PROPS.getProperty("dubbo.service.group") : "REMOTE_DEFAULT_GROUP";
            }
            if (StringUtils.isEmpty((Object)(dubboServiceRetries = String.valueOf(proxyProvider.retries()))) || "0".equals(dubboServiceRetries)) {
                dubboServiceRetries = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.service.retries")) ? CONTEXT_PROPS.getProperty("dubbo.service.retries") : "3";
            }
            if (StringUtils.isEmpty((Object)(dubboServiceTimeout = String.valueOf(proxyProvider.clientTimeout()))) || "0".equals(dubboServiceTimeout)) {
                dubboServiceTimeout = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.service.timeout")) ? CONTEXT_PROPS.getProperty("dubbo.service.timeout") : "60000";
            }
            print.print("<dubbo:service");
            print.print(" delay=\"");
            print.print(dubboServiceDelay);
            print.print("\"");
            print.print(" interface=\"");
            print.print(intface);
            print.print("\"");
            print.print(" ref=\"");
            print.print(providerRef);
            print.print("\"");
            print.print(" version=\"");
            print.print(dubboServiceVersion);
            print.print("\"");
            print.print(" group=\"");
            print.print(dubboServiceGroup);
            print.print("\"");
            print.print(" retries=\"");
            print.print(dubboServiceRetries);
            print.print("\"");
            print.print(" timeout=\"");
            print.print(dubboServiceTimeout);
            print.print("\"");
            print.println("></dubbo:service>");
        }
        print.println("</beans>");
        print.flush();
        print.close();
        DUBBO_APPLICATION_NAMED = true;
        return output.toByteArray();
    }

    private byte[] generateDubboProviderBeans(List<String> providers) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream print = new PrintStream(output);
        print.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        print.println("<beans xmlns=\"http://www.springframework.org/schema/beans\"");
        print.println("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        print.println("xmlns:dubbo=\"http://code.alibabatech.com/schema/dubbo\"");
        print.println("xsi:schemaLocation=\"http://www.springframework.org/schema/beans");
        print.println("http://www.springframework.org/schema/beans/spring-beans.xsd");
        print.println("http://code.alibabatech.com/schema/dubbo");
        print.println("http://code.alibabatech.com/schema/dubbo/dubbo.xsd\">");
        String dubboApplicationName = "";
        dubboApplicationName = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.application.name")) ? CONTEXT_PROPS.getProperty("dubbo.application.name") : "remote-dubbo-application";
        String dubboRegistryAddress = "";
        dubboRegistryAddress = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.registry.address")) ? CONTEXT_PROPS.getProperty("dubbo.registry.address") : "zookeeper://127.0.0.1:2181";
        String dubboProtocolName = "";
        dubboProtocolName = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.protocol.name")) ? CONTEXT_PROPS.getProperty("dubbo.protocol.name") : "dubbo";
        String dubboProtocolPort = "";
        dubboProtocolPort = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.protocol.port")) ? CONTEXT_PROPS.getProperty("dubbo.protocol.port") : "20880";
        String dubboProtocolThreadpool = "";
        dubboProtocolThreadpool = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.protocol.threadpool")) ? CONTEXT_PROPS.getProperty("dubbo.protocol.threadpool") : "cached";
        String dubboProtocolThreads = "";
        dubboProtocolThreads = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.protocol.threads")) ? CONTEXT_PROPS.getProperty("dubbo.protocol.threads") : "100";
        String dubboServiceDelay = "";
        dubboServiceDelay = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.service.delay")) ? CONTEXT_PROPS.getProperty("dubbo.service.delay") : "-1";
        String dubboServiceVersion = "";
        dubboServiceVersion = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.service.version")) ? CONTEXT_PROPS.getProperty("dubbo.service.version") : "1.0.0";
        String dubboServiceGroup = "";
        dubboServiceGroup = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.service.group")) ? CONTEXT_PROPS.getProperty("dubbo.service.group") : "REMOTE_DEFAULT_GROUP";
        String dubboServiceRetries = "";
        dubboServiceRetries = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.service.retries")) ? CONTEXT_PROPS.getProperty("dubbo.service.retries") : "3";
        String dubboServiceTimeout = "";
        dubboServiceTimeout = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("dubbo.service.timeout")) ? CONTEXT_PROPS.getProperty("dubbo.service.timeout") : "60000";
        print.print("<dubbo:application");
        print.print(" name=\"");
        print.print(dubboApplicationName);
        print.println("\" ></dubbo:application>");
        print.print("<dubbo:registry");
        print.print(" address=\"");
        print.print(dubboRegistryAddress);
        print.println("\" ></dubbo:registry>");
        print.print("<dubbo:protocol");
        print.print(" name=\"");
        print.print(dubboProtocolName);
        print.print("\"");
        print.print(" port=\"");
        print.print(dubboProtocolPort);
        print.print("\"");
        print.print(" threadpool=\"");
        print.print(dubboProtocolThreadpool);
        print.print("\"");
        print.print(" threads=\"");
        print.print(dubboProtocolThreads);
        print.println("\" ></dubbo:protocol>");
        for (String provider : providers) {
            Class<?> providerClazz = null;
            try {
                providerClazz = Class.forName(provider);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            String intface = providerClazz.getInterfaces()[0].getName();
            String providerRef = "";
            Set<String> refSet = this.getProviderBeanNames(providerClazz);
            if (refSet == null || refSet.size() != 1) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("Provider [" + intface + "] ref not exists.");
                continue;
            }
            providerRef = refSet.iterator().next();
            print.print("<dubbo:service");
            print.print(" delay=\"");
            print.print(dubboServiceDelay);
            print.print("\"");
            print.print(" interface=\"");
            print.print(intface);
            print.print("\"");
            print.print(" ref=\"");
            print.print(providerRef);
            print.print("\"");
            print.print(" version=\"");
            print.print(dubboServiceVersion);
            print.print("\"");
            print.print(" group=\"");
            print.print(dubboServiceGroup);
            print.print("\"");
            print.print(" retries=\"");
            print.print(dubboServiceRetries);
            print.print("\"");
            print.print(" timeout=\"");
            print.print(dubboServiceTimeout);
            print.print("\"");
            print.println("></dubbo:service>");
        }
        print.println("</beans>");
        print.flush();
        print.close();
        DUBBO_APPLICATION_NAMED = true;
        return output.toByteArray();
    }

    private byte[] generateHsfProviderBeansWithCustomAnnotation(List<String> providers) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream print = new PrintStream(output);
        print.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        print.println("<beans xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        print.println("xmlns:hsf=\"http://www.taobao.com/hsf\"");
        print.println("xmlns=\"http://www.springframework.org/schema/beans\"");
        print.println("xsi:schemaLocation=\"http://www.springframework.org/schema/beans");
        print.println("http://www.springframework.org/schema/beans/spring-beans-2.5.xsd");
        print.println("http://www.taobao.com/hsf");
        print.println("http://www.taobao.com/hsf/hsf.xsd\" default-autowire=\"byName\">");
        for (String provider : providers) {
            String providerSerializeType;
            String providerMaxPoolSize;
            String providerCorePoolSize;
            String providerClientTimeout;
            String providerGroup;
            Class<?> providerClazz = null;
            try {
                providerClazz = Class.forName(provider);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ProxyProvider proxyProvider = providerClazz.getAnnotation(ProxyProvider.class);
            String intface = providerClazz.getInterfaces()[0].getName();
            String providerRef = "";
            Set<String> refSet = this.getProviderBeanNames(providerClazz);
            if (refSet == null || refSet.size() != 1) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("Provider [" + intface + "] ref not exists.");
                continue;
            }
            providerRef = refSet.iterator().next();
            String providerVersion = proxyProvider.version();
            if (StringUtils.isEmpty((Object)providerVersion)) {
                providerVersion = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.version")) ? CONTEXT_PROPS.getProperty("hsf.version") : "1.0.0";
            }
            if (StringUtils.isEmpty((Object)(providerGroup = proxyProvider.group()))) {
                providerGroup = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.group")) ? CONTEXT_PROPS.getProperty("hsf.group") : "REMOTE_DEFAULT_GROUP";
            }
            if (StringUtils.isEmpty((Object)(providerClientTimeout = String.valueOf(proxyProvider.clientTimeout()))) || "0".equals(providerClientTimeout)) {
                providerClientTimeout = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.clientTimeout")) ? CONTEXT_PROPS.getProperty("hsf.clientTimeout") : "60000";
            }
            if (StringUtils.isEmpty((Object)(providerCorePoolSize = String.valueOf(proxyProvider.corePoolSize()))) || "0".equals(providerCorePoolSize)) {
                providerCorePoolSize = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.corePoolSize")) ? CONTEXT_PROPS.getProperty("hsf.corePoolSize") : "";
            }
            if (StringUtils.isEmpty((Object)(providerMaxPoolSize = String.valueOf(proxyProvider.maxPoolSize()))) || "0".equals(providerMaxPoolSize)) {
                providerMaxPoolSize = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.maxPoolSize")) ? CONTEXT_PROPS.getProperty("hsf.maxPoolSize") : "";
            }
            if (StringUtils.isEmpty((Object)(providerSerializeType = proxyProvider.serializeType()))) {
                providerSerializeType = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.serializeType")) ? CONTEXT_PROPS.getProperty("hsf.serializeType") : "";
            }
            print.print("<hsf:provider");
            print.print(" id=\"");
            print.print(providerRef + "Provider");
            print.print("\"");
            print.print(" interface=\"");
            print.print(intface);
            print.print("\"");
            print.print(" ref=\"");
            print.print(providerRef);
            print.print("\"");
            print.print(" version=\"");
            print.print(providerVersion);
            print.print("\"");
            print.print(" group=\"");
            print.print(providerGroup);
            print.print("\"");
            print.print(" clientTimeout=\"");
            print.print(providerClientTimeout);
            print.print("\"");
            if (!StringUtils.isEmpty((Object)providerCorePoolSize)) {
                print.print(" corePoolSize=\"");
                print.print(providerCorePoolSize);
                print.print("\"");
            }
            if (!StringUtils.isEmpty((Object)providerMaxPoolSize)) {
                print.print(" maxPoolSize=\"");
                print.print(providerMaxPoolSize);
                print.print("\"");
            }
            if (!StringUtils.isEmpty((Object)providerSerializeType)) {
                print.print(" serializeType=\"");
                print.print(providerSerializeType);
                print.print("\"");
            }
            print.println("></hsf:provider>");
        }
        print.println("</beans>");
        print.flush();
        print.close();
        return output.toByteArray();
    }

    private byte[] generateHsfProviderBeans(List<String> providers) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream print = new PrintStream(output);
        print.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        print.println("<beans xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        print.println("xmlns:hsf=\"http://www.taobao.com/hsf\"");
        print.println("xmlns=\"http://www.springframework.org/schema/beans\"");
        print.println("xsi:schemaLocation=\"http://www.springframework.org/schema/beans");
        print.println("http://www.springframework.org/schema/beans/spring-beans-2.5.xsd");
        print.println("http://www.taobao.com/hsf");
        print.println("http://www.taobao.com/hsf/hsf.xsd\" default-autowire=\"byName\">");
        String providerVersion = "";
        providerVersion = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.version")) ? CONTEXT_PROPS.getProperty("hsf.version") : "1.0.0";
        String providerGroup = "";
        providerGroup = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.group")) ? CONTEXT_PROPS.getProperty("hsf.group") : "REMOTE_DEFAULT_GROUP";
        String providerClientTimeout = "";
        providerClientTimeout = !StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.clientTimeout")) ? CONTEXT_PROPS.getProperty("hsf.clientTimeout") : "60000";
        String providerCorePoolSize = "";
        if (!StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.corePoolSize"))) {
            providerCorePoolSize = CONTEXT_PROPS.getProperty("hsf.corePoolSize");
        }
        String providerMaxPoolSize = "";
        if (!StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.maxPoolSize"))) {
            providerMaxPoolSize = CONTEXT_PROPS.getProperty("hsf.maxPoolSize");
        }
        String providerSerializeType = "";
        if (!StringUtils.isEmpty((Object)CONTEXT_PROPS.getProperty("hsf.serializeType"))) {
            providerSerializeType = CONTEXT_PROPS.getProperty("hsf.serializeType");
        }
        for (String provider : providers) {
            Class<?> providerClazz = null;
            try {
                providerClazz = Class.forName(provider);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            String intface = providerClazz.getInterfaces()[0].getName();
            String providerRef = "";
            Set<String> refSet = this.getProviderBeanNames(providerClazz);
            if (refSet == null || refSet.size() != 1) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("Provider [" + intface + "] ref not exists.");
                continue;
            }
            providerRef = refSet.iterator().next();
            print.print("<hsf:provider");
            print.print(" id=\"");
            print.print(providerRef + "Provider");
            print.print("\"");
            print.print(" interface=\"");
            print.print(intface);
            print.print("\"");
            print.print(" ref=\"");
            print.print(providerRef);
            print.print("\"");
            print.print(" version=\"");
            print.print(providerVersion);
            print.print("\"");
            print.print(" group=\"");
            print.print(providerGroup);
            print.print("\"");
            print.print(" clientTimeout=\"");
            print.print(providerClientTimeout);
            print.print("\"");
            if (!StringUtils.isEmpty((Object)providerCorePoolSize)) {
                print.print(" corePoolSize=\"");
                print.print(providerCorePoolSize);
                print.print("\"");
            }
            if (!StringUtils.isEmpty((Object)providerMaxPoolSize)) {
                print.print(" maxPoolSize=\"");
                print.print(providerMaxPoolSize);
                print.print("\"");
            }
            if (!StringUtils.isEmpty((Object)providerSerializeType)) {
                print.print(" serializeType=\"");
                print.print(providerSerializeType);
                print.print("\"");
            }
            print.println("></hsf:provider>");
        }
        print.println("</beans>");
        print.flush();
        print.close();
        return output.toByteArray();
    }

    public Set<String> getProviderBeanNames(Class<?> beanClass) {
        return PROVIDER_BEAN_MAPPINGS.get(beanClass);
    }

    public Set<String> getConsumerBeanNames(Class<?> beanClass) {
        return CONSUMER_BEAN_MAPPINGS.get(beanClass);
    }

    private String getProperty(String key) {
        String property = CONTEXT_PROPS.getProperty(key);
        if (StringUtils.isEmpty((Object)property)) {
            property = "";
        }
        return property;
    }

    private List<String> dealProxyProviderService(List<String> providers) {
        if (providers == null) {
            return null;
        }
        ArrayList<String> providerBean = new ArrayList<String>();
        for (String provider : providers) {
            Service annotation;
            if (provider.contains("$")) continue;
            Class<?> serviceClass = null;
            try {
                serviceClass = Class.forName(provider);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if ((annotation = serviceClass.getAnnotation(Service.class)) == null) continue;
            Object beanName = annotation.value();
            if (!(!StringUtils.isEmpty((Object)beanName) || ((String)(beanName = serviceClass.getSimpleName())).length() > 1 && Character.isUpperCase(((String)beanName).charAt(1)) && Character.isUpperCase(((String)beanName).charAt(0)))) {
                String big = ((String)beanName).substring(0, 1);
                String small = big.toLowerCase();
                beanName = small + ((String)beanName).substring(1);
            }
            this.addProviderBean(serviceClass, (String)beanName);
            providerBean.add(provider);
        }
        return providerBean;
    }

    private List<String> extractAnnotationClazzes(final Class<?> annotationClazz, String scanPath) throws IOException, ClassNotFoundException {
        final ArrayList<String> clazzList = new ArrayList<String>();
        ClassVisitor anaotationClassVisitor = new ClassVisitor(327680){
            private final String PROXY_REMOTE_INTERFACE;
            private String clazz;
            {
                super(arg0);
                this.PROXY_REMOTE_INTERFACE = "L" + annotationClazz.getName().replaceAll("\\.", "/") + ";";
            }

            public void visit(int i, int i1, String s, String s1, String s2, String[] strings) {
                super.visit(i, i1, s, s1, s2, strings);
                this.clazz = s;
            }

            public AnnotationVisitor visitAnnotation(String s, boolean b) {
                if (this.PROXY_REMOTE_INTERFACE.equals(s)) {
                    clazzList.add(this.clazz.replaceAll("/", "."));
                }
                return super.visitAnnotation(s, b);
            }
        };
        if (!StringUtils.isEmpty((Object)scanPath)) {
            String[] scanPaths = scanPath.split(",");
            for (int i = 0; i < scanPaths.length; ++i) {
                Resource[] clazzes;
                String path = "classpath*:" + scanPaths[i].replace(".", "/") + "/*.class";
                for (Resource clazz : clazzes = PMRPR.getResources(path)) {
                    ClassReader cr = new ClassReader(clazz.getInputStream());
                    cr.accept(anaotationClassVisitor, 0);
                }
            }
        }
        return clazzList;
    }

    private void addProviderBean(Class<?> beanClass, String beanName) {
        Set<String> beanNameSet = PROVIDER_BEAN_MAPPINGS.get(beanClass);
        if (beanNameSet == null) {
            beanNameSet = new HashSet<String>();
            PROVIDER_BEAN_MAPPINGS.put(beanClass, beanNameSet);
        }
        if (beanNameSet.contains(beanName)) {
            throw new RuntimeException("[id:" + beanName + ", class:" + beanClass + "] repeated!!!");
        }
        beanNameSet.add(beanName);
    }
}

