/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.base.filter;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.base.filter.XssAndSqlHttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@WebFilter(value={"/*"})
@Component
public class XssAndSqlFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(XssAndSqlFilter.class);
    private static Set<String> notAllowedKeyWords = null;
    @Value(value="${security.xss.key:and|exec|insert|select|delete|update|count|%|chr|mid|master|truncate|char|declare|or|like|where|union|order|by|table|from|grant|use|group_concat|column_name|information_schema.columns|table_schema|}")
    private String securityXssKey;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setCharacterEncoding("utf-8");
        response.setContentType("text/html;charset=utf-8");
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        log.info("CrosXssFilter----->orignal url:{},ParameterMap:{}", (Object)httpRequest.getRequestURI(), (Object)JSONObject.toJSONString((Object)httpRequest.getParameterMap()));
        XssAndSqlHttpServletRequestWrapper xssAndSqlHttpServletRequestWrapper = new XssAndSqlHttpServletRequestWrapper(httpRequest);
        String param = XssAndSqlFilter.getBodyString(xssAndSqlHttpServletRequestWrapper.getReader());
        Map test = request.getParameterMap();
        log.info("CrosXssFilter..........doFilter url:{},ParameterMap:{}", (Object)xssAndSqlHttpServletRequestWrapper.getRequestURI(), (Object)JSONObject.toJSONString(xssAndSqlHttpServletRequestWrapper.getParameterMap()));
        if (this.checkSqlKeyWords(param)) {
            log.error("[" + httpRequest.getRequestURI() + "]\uff0c\u8bf7\u6c42\u53c2\u6570\u4e2d\u5305\u542b\u4e0d\u5141\u8bb8sql\u7684\u5173\u952e\u8bcd");
            throw new ZTBusinessException("[" + httpRequest.getRequestURI() + "]\uff0c\u8bf7\u6c42\u53c2\u6570\u4e2d\u5305\u542b\u4e0d\u5141\u8bb8sql\u7684\u5173\u952e\u8bcd");
        }
        chain.doFilter((ServletRequest)xssAndSqlHttpServletRequestWrapper, response);
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public static String getBodyString(BufferedReader br) {
        String str = "";
        try {
            String inputLine;
            while ((inputLine = br.readLine()) != null) {
                str = str + inputLine;
            }
            br.close();
        }
        catch (IOException e) {
            log.error("\u8fc7\u6ee4\u53c2\u6570\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        return str;
    }

    private boolean checkValue(String paramValue, String keyword) {
        return paramValue.contains(" " + keyword) || paramValue.contains(keyword + " ") || paramValue.contains(" " + keyword + " ");
    }

    public boolean checkSqlKeyWords(String paramValue) {
        if (StringUtils.isEmpty((CharSequence)paramValue)) {
            return false;
        }
        if (notAllowedKeyWords == null) {
            String[] keyStr;
            notAllowedKeyWords = new HashSet<String>(0);
            for (String str : keyStr = this.securityXssKey.split("\\|")) {
                notAllowedKeyWords.add(str);
            }
        }
        JSONObject jsonObject = JSONObject.parseObject((String)paramValue);
        JSONObject childJsonObject = null;
        if (jsonObject != null) {
            for (Map.Entry entry : jsonObject.entrySet()) {
                if (entry.getValue() == null) continue;
                if (entry.getValue() instanceof JSONObject) {
                    childJsonObject = JSONObject.parseObject((String)entry.getValue().toString());
                    if (childJsonObject == null) continue;
                    for (String keyword : notAllowedKeyWords) {
                        if (!this.checkValue(entry.getValue().toString().toLowerCase(), keyword)) continue;
                        return true;
                    }
                    continue;
                }
                for (String keyword : notAllowedKeyWords) {
                    if (!this.checkValue(entry.getValue().toString().toLowerCase(), keyword)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

