/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.base.filter;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

public class XssAndSqlHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log;
    private static String key;
    private static Set<String> notAllowedKeyWords;
    private final byte[] body;
    private String currentUrl;

    public XssAndSqlHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.currentUrl = request.getRequestURI();
        this.body = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
    }

    public String getParameter(String name) {
        String value = super.getParameter(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return this.cleanXss(value);
    }

    public Map<String, String[]> getParameterMap() {
        Map values = super.getParameterMap();
        if (null == values) {
            return null;
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (String key : values.keySet()) {
            String encodedKey = this.cleanXss(key);
            int count = ((String[])values.get(key)).length;
            String[] encodedValues = new String[count];
            for (int i = 0; i < count; ++i) {
                encodedValues[i] = this.cleanXss(((String[])values.get(key))[i]);
            }
            result.put(encodedKey, encodedValues);
        }
        return result;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return this.cleanXss(value);
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.cleanXss(values[i]);
        }
        return encodedValues;
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() throws IOException {
                return bais.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener arg0) {
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    private String cleanXss(String valueP) {
        String value = valueP.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        value = value.replaceAll("<", "& lt;").replaceAll(">", "& gt;");
        value = value.replaceAll("\\(", "& #40;").replaceAll("\\)", "& #41;");
        value = value.replaceAll("'", "& #39;");
        value = value.replaceAll("eval\\((.*)\\)", "");
        value = value.replaceAll("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']", "\"\"");
        value = value.replaceAll("script", "");
        return value;
    }

    private boolean checkValue(String paramValue, String keyword) {
        return paramValue.contains(" " + keyword) || paramValue.contains(keyword + " ") || paramValue.contains(" " + keyword + " ");
    }

    public boolean checkSqlKeyWords(String value) {
        String paramValue = value;
        if (!StringUtils.isEmpty((CharSequence)paramValue)) {
            JSONObject jsonObject = JSONObject.parseObject((String)paramValue);
            JSONObject childJsonObject = null;
            if (jsonObject != null) {
                for (Map.Entry entry : jsonObject.entrySet()) {
                    if (entry.getValue() == null) continue;
                    if (entry.getValue() instanceof JSONObject) {
                        childJsonObject = JSONObject.parseObject((String)entry.getValue().toString());
                        if (childJsonObject == null) continue;
                        for (String keyword : notAllowedKeyWords) {
                            if (!this.checkValue(entry.getValue().toString().toLowerCase(), keyword)) continue;
                            log.error(this.getRequestURI() + "\u53c2\u6570\u4e2d\u5305\u542b\u4e0d\u5141\u8bb8sql\u7684\u5173\u952e\u8bcd(" + keyword + ")");
                            return true;
                        }
                        continue;
                    }
                    for (String keyword : notAllowedKeyWords) {
                        if (!this.checkValue(entry.getValue().toString().toLowerCase(), keyword)) continue;
                        log.error(this.getRequestURI() + "\u53c2\u6570\u4e2d\u5305\u542b\u4e0d\u5141\u8bb8sql\u7684\u5173\u952e\u8bcd(" + keyword + ")");
                        return true;
                    }
                }
            }
        }
        return false;
    }

    static {
        String[] keyStr;
        log = LoggerFactory.getLogger(XssAndSqlHttpServletRequestWrapper.class);
        key = "and|exec|insert|select|delete|update|count|%|chr|mid|master|truncate|char|declare|or|like|where|union|order|by|table|from|grant|use|group_concat|column_name|information_schema.columns|table_schema|";
        notAllowedKeyWords = new HashSet<String>(0);
        for (String str : keyStr = key.split("\\|")) {
            notAllowedKeyWords.add(str);
        }
    }
}

