/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.base.filter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

public class XssAndSqlHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(XssAndSqlHttpServletRequestWrapper.class);
    public final byte[] body;
    private String currentUrl;

    public XssAndSqlHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.currentUrl = request.getRequestURI();
        this.body = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
    }

    public String getParameter(String name) {
        String value = super.getParameter(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return this.cleanXss(value);
    }

    public Map<String, String[]> getParameterMap() {
        Map values = super.getParameterMap();
        if (null == values) {
            return null;
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (String key : values.keySet()) {
            String encodedKey = this.cleanXss(key);
            int count = ((String[])values.get(key)).length;
            String[] encodedValues = new String[count];
            for (int i = 0; i < count; ++i) {
                encodedValues[i] = this.cleanXss(((String[])values.get(key))[i]);
            }
            result.put(encodedKey, encodedValues);
        }
        return result;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return this.cleanXss(value);
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.cleanXss(values[i]);
        }
        return encodedValues;
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() throws IOException {
                return bais.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener arg0) {
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    private String cleanXss(String valueP) {
        String value = valueP.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        value = value.replaceAll("<", "& lt;").replaceAll(">", "& gt;");
        value = value.replaceAll("\\(", "& #40;").replaceAll("\\)", "& #41;");
        value = value.replaceAll("'", "& #39;");
        value = value.replaceAll("eval\\((.*)\\)", "");
        value = value.replaceAll("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']", "\"\"");
        value = value.replaceAll("script", "");
        return value;
    }
}

