/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.cache.impl;

import com.ohaotian.plugin.cache.CacheExecuterService;
import com.ohaotian.plugin.cache.CacheManager;
import com.ohaotian.plugin.cache.CacheService;
import com.ohaotian.plugin.common.util.SerializationUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;

@Deprecated
public class CacheSeviceImpl
implements CacheService {
    private static final Logger log = LoggerFactory.getLogger(CacheSeviceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private CacheManager cacheManager;

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void set(String key, Object value) {
        this.cacheManager.set(key.getBytes(), SerializationUtils.serializeSlightly((Object)value));
    }

    @Override
    public void put(String key, Object value) {
        this.cacheManager.set(key.getBytes(), SerializationUtils.serializeSlightly((Object)value));
    }

    @Override
    public void set(String key, Object value, int expire) {
        this.cacheManager.set(key.getBytes(), SerializationUtils.serializeSlightly((Object)value), expire);
    }

    @Override
    public void put(String key, Object value, int expire) {
        this.cacheManager.set(key.getBytes(), SerializationUtils.serializeSlightly((Object)value), expire);
    }

    @Override
    public Object get(String key) {
        byte[] value = this.cacheManager.get(key.getBytes());
        if (value == null) {
            return null;
        }
        return SerializationUtils.deserializeSlightly((byte[])value);
    }

    @Override
    public <T> T get(String key, Class<T> requiredType) {
        byte[] value = this.cacheManager.get(key.getBytes());
        if (value == null) {
            return null;
        }
        return (T)SerializationUtils.deserializeSlightly((byte[])value);
    }

    @Override
    public void delete(String key) {
        this.cacheManager.del(key.getBytes());
    }

    @Override
    public <T> T getFinal(CacheExecuterService<T> executer, String ... key) {
        String finalKey = this.getFinalKey(key);
        log.debug("finalKey=" + finalKey);
        byte[] value = this.cacheManager.get(finalKey.getBytes());
        if (value == null || value.length == 0) {
            log.debug("\u6570\u636e\u5728\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\uff01\u6267\u884c\u672c\u5730\u6570\u636e\u67e5\u8be2\u5668\u67e5\u8be2\u6570\u636e");
            T obj = executer.getParamFromDb(key);
            if (obj != null && !"".equals(obj)) {
                log.debug("value=" + obj.toString());
                this.put(finalKey, obj);
                return obj;
            }
            log.debug("\u6570\u636e\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01");
            return null;
        }
        Object finalValue = SerializationUtils.deserializeSlightly((byte[])value);
        log.debug("value=" + finalValue);
        return (T)finalValue;
    }

    private String getFinalKey(String ... key) {
        StringBuffer fkey = new StringBuffer();
        for (String s : key) {
            fkey.append(s);
            fkey.append("_");
        }
        fkey.setLength(fkey.length() - 1);
        return fkey.toString();
    }

    @Override
    public Set<String> getkeys(String pattern) {
        HashSet<String> keys = new HashSet<String>();
        Set<byte[]> keybs = this.cacheManager.keys(pattern);
        for (byte[] bs : keybs) {
            keys.add(new String(bs));
        }
        return keys;
    }

    @Override
    public Long getExpireTimeByKey(String key) {
        return this.cacheManager.getExpireTimeByKey(key.getBytes());
    }

    @Override
    public Long incr(String key) {
        return this.cacheManager.incr(key.getBytes());
    }

    @Override
    public Long incrExpireTime(String key, int expire) {
        return this.cacheManager.incrExpireTime(key.getBytes(), expire);
    }

    @Override
    public Long incrBy(String key, long num) {
        return this.cacheManager.incrBy(key.getBytes(), num);
    }

    @Override
    public Long incrExpireTimeBy(String key, long num, int expire) {
        return this.cacheManager.incrExpireTimeBy(key.getBytes(), num, expire);
    }

    @Override
    public Long getIncr(String key) {
        return this.cacheManager.getIncr(key.getBytes());
    }

    @Override
    public Long rpush(String key, String ... objs) {
        return this.cacheManager.rpush(key, objs);
    }

    @Override
    public String lpop(String key) {
        return this.cacheManager.lpop(key);
    }

    @Override
    public Long llen(String key) {
        return this.cacheManager.llen(key);
    }

    @Override
    public Long setnx(String key, Object value) {
        return this.cacheManager.setnx(key.getBytes(), SerializationUtils.serializeSlightly((Object)value));
    }

    @Override
    public Object getSet(String key, Object value) {
        byte[] bytes = this.cacheManager.getSet(key.getBytes(), SerializationUtils.serializeSlightly((Object)value));
        return bytes == null ? null : SerializationUtils.deserializeSlightly((byte[])bytes);
    }

    @Override
    public JedisPool getJedisPool() {
        return this.cacheManager.getJedisPool();
    }

    @Override
    public Map<String, String> getOuterCodeByKey(CacheExecuterService<Map<String, String>> executer, String ... key) {
        byte[] value;
        String finalKey = this.getRedisKey(executer, this.getFinalKey(key));
        if (isDebugEnabled) {
            log.debug("getOuterCodeByKey finalKey=" + finalKey);
        }
        if ((value = this.cacheManager.get(finalKey.getBytes())) == null || value.length == 0) {
            log.debug("\u6570\u636e\u5728\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\uff01\u6267\u884c\u672c\u5730\u6570\u636e\u67e5\u8be2\u5668\u67e5\u8be2\u6570\u636e");
            Map<String, String> obj = executer.getParamFromDb(key);
            if (obj.size() > 0) {
                if (isDebugEnabled) {
                    log.debug("outerCode=" + obj.get("outerCode"));
                    log.debug("outerCodeDesc=" + obj.get("outerCodeDesc"));
                }
                this.put(finalKey, obj);
            } else if (isDebugEnabled) {
                log.debug("\u6570\u636e\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01");
            }
            return obj;
        }
        Map finalValue = (Map)SerializationUtils.deserializeSlightly((byte[])value);
        return finalValue;
    }

    @Override
    public Map<String, String> getInnerCodeByKey(CacheExecuterService<Map<String, String>> executer, String ... key) {
        byte[] value;
        String finalKey = this.getRedisKey(executer, this.getFinalKey(key));
        if (isDebugEnabled) {
            log.debug("getInnerCodeByKey finalKey=" + finalKey);
        }
        if ((value = this.cacheManager.get(finalKey.getBytes())) == null || value.length == 0) {
            log.debug("\u6570\u636e\u5728\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\uff01\u6267\u884c\u672c\u5730\u6570\u636e\u67e5\u8be2\u5668\u67e5\u8be2\u6570\u636e");
            Map<String, String> obj = executer.getInnerParamFromDb(key);
            if (obj.size() > 0) {
                if (isDebugEnabled) {
                    log.debug("innerCode=" + obj.get("innerCode"));
                    log.debug("innerCodeDesc=" + obj.get("innerCodeDesc"));
                }
                this.put(finalKey, obj);
            } else if (isDebugEnabled) {
                log.debug("\u6570\u636e\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01");
            }
            return obj;
        }
        Map finalValue = (Map)SerializationUtils.deserializeSlightly((byte[])value);
        return finalValue;
    }

    private String getRedisKey(CacheExecuterService<Map<String, String>> executer, String finalKey) {
        if (executer.getClass().toString().contains("user")) {
            finalKey = finalKey + "_" + "user";
        }
        if (executer.getClass().toString().contains("order")) {
            finalKey = finalKey + "_" + "order";
        }
        if (executer.getClass().toString().contains("commodity")) {
            finalKey = finalKey + "_" + "commodity";
        }
        if (executer.getClass().toString().contains("pay")) {
            finalKey = finalKey + "_" + "pay";
        }
        if (executer.getClass().toString().contains("workflow")) {
            finalKey = finalKey + "_" + "workflow";
        }
        return finalKey;
    }
}

