/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.cache;

import com.ohaotian.plugin.cache.CacheManager;
import com.ohaotian.plugin.util.ConvertUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.util.Pool;

public class RedisManager
implements CacheManager {
    private String host = "115.28.105.99";
    private int port = 6379;
    private int expire = 0;
    private int timeout = 0;
    private String password = "BJtGXdevRedis123";
    private String type = "single";
    private Pool<Jedis> jedisPool = null;
    private JedisCluster jedisCluster = null;

    public RedisManager() {
    }

    public RedisManager(String host, int port, String password) {
        this.host = host;
        this.port = port;
        this.password = password;
    }

    public RedisManager(String host, int port, String password, int expire, int timeout) {
        this.host = host;
        this.port = port;
        this.password = password;
        this.expire = expire;
        this.timeout = timeout;
    }

    public void init() {
        if (this.jedisPool == null) {
            this.jedisPool = this.password != null && !"".equals(this.password) ? new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.host, this.port, this.timeout, this.password) : (this.timeout != 0 ? new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.host, this.port, this.timeout) : new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.host, this.port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(byte[] key) {
        byte[] value = null;
        if ("cluster".equals(this.type)) {
            value = this.jedisCluster.get(key);
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                value = jedis.get(key);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] set(byte[] key, byte[] value) {
        if ("cluster".equals(this.type)) {
            this.jedisCluster.set(key, value);
            if (this.expire != 0) {
                this.jedisCluster.expire(key, this.expire);
            }
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                jedis.set(key, value);
                if (this.expire != 0) {
                    jedis.expire(key, this.expire);
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] set(byte[] key, byte[] value, int expire) {
        if ("cluster".equals(this.type)) {
            this.jedisCluster.set(key, value);
            if (this.expire != 0) {
                this.jedisCluster.expire(key, this.expire);
            }
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                jedis.set(key, value);
                if (expire != 0) {
                    jedis.expire(key, expire);
                }
            }
        }
        return value;
    }

    @Override
    public void del(byte[] key) {
        if ("cluster".equals(this.type)) {
            this.jedisCluster.del(key);
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                jedis.del(key);
            }
        }
    }

    @Override
    public void flushDB() {
        if ("cluster".equals(this.type)) {
            this.jedisCluster.flushDB();
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                jedis.flushDB();
            }
        }
    }

    @Override
    public Long dbSize() {
        Long dbSize = 0L;
        if ("cluster".equals(this.type)) {
            dbSize = this.jedisCluster.dbSize();
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                dbSize = jedis.dbSize();
            }
        }
        return dbSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> keys(String pattern) {
        TreeSet<byte[]> keys = null;
        if ("cluster".equals(this.type)) {
            TreeSet keySet = new TreeSet();
            Map clusterNodes = this.jedisCluster.getClusterNodes();
            for (String k : clusterNodes.keySet()) {
                JedisPool jp = (JedisPool)clusterNodes.get(k);
                Jedis connection = jp.getResource();
                try {
                    keySet.addAll(connection.keys(pattern));
                }
                catch (Exception exception) {}
                continue;
                finally {
                    connection.close();
                }
            }
            if (!keySet.isEmpty()) {
                keys = new TreeSet<byte[]>();
            }
            for (String str : keySet) {
                keys.add(str.getBytes());
            }
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                keys = jedis.keys(pattern.getBytes());
            }
        }
        return keys;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getExpire() {
        return this.expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Pool<Jedis> getJedisPool() {
        return this.jedisPool;
    }

    public void setJedisPool(Pool<Jedis> jedisPool) {
        this.jedisPool = jedisPool;
    }

    public JedisCluster getJedisCluster() {
        return this.jedisCluster;
    }

    public void setJedisCluster(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueExpireTime(byte[] key, int expire) {
        if ("cluster".equals(this.type)) {
            if (expire != 0) {
                this.jedisCluster.expire(key, expire);
            }
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                if (expire != 0) {
                    jedis.expire(key, expire);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getExpireTimeByKey(byte[] key) {
        Long expireTime = -1L;
        if ("cluster".equals(this.type)) {
            expireTime = this.jedisCluster.ttl(key);
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                expireTime = jedis.ttl(key);
            }
        }
        return expireTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incr(byte[] key) {
        Long num = null;
        if ("cluster".equals(this.type)) {
            num = this.jedisCluster.incr(key);
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                num = jedis.incr(key);
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrExpireTime(byte[] key, int expire) {
        Long num = null;
        if ("cluster".equals(this.type)) {
            num = this.jedisCluster.incr(key);
            this.jedisCluster.expire(key, expire);
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                num = jedis.incr(key);
                jedis.expire(key, expire);
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrBy(byte[] key, long conut) {
        Long num = null;
        if ("cluster".equals(this.type)) {
            num = this.jedisCluster.incrBy(key, conut);
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                num = jedis.incrBy(key, conut);
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrExpireTimeBy(byte[] key, long conut, int expire) {
        Long num = null;
        if ("cluster".equals(this.type)) {
            num = this.jedisCluster.incrBy(key, conut);
            this.jedisCluster.expire(key, expire);
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                num = jedis.incrBy(key, conut);
                jedis.expire(key, expire);
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getIncr(byte[] key) {
        Long num = null;
        if ("cluster".equals(this.type)) {
            byte[] bnum = this.jedisCluster.get(key);
            String numStr = bnum == null ? null : new String(bnum);
            num = numStr == null ? null : Long.valueOf(Long.parseLong(numStr));
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                byte[] bnum = jedis.get(key);
                String numStr = bnum == null ? null : new String(bnum);
                num = numStr == null ? null : Long.valueOf(Long.parseLong(numStr));
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long rpush(byte[] key, byte[] value) {
        Long res = null;
        if ("cluster".equals(this.type)) {
            res = this.jedisCluster.rpush(key, (byte[][])new byte[][]{value});
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                res = jedis.rpush(key, (byte[][])new byte[][]{value});
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lpop(String key) {
        String res = null;
        if ("cluster".equals(this.type)) {
            res = this.jedisCluster.lpop(key);
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                res = jedis.lpop(key);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long llen(String key) {
        Long res = null;
        if ("cluster".equals(this.type)) {
            res = this.jedisCluster.llen(key);
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                res = jedis.llen(key);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long setnx(byte[] key, byte[] value) {
        Long res = null;
        if ("cluster".equals(this.type)) {
            res = this.jedisCluster.setnx(key, value);
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                res = jedis.setnx(key, value);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        byte[] res = null;
        if ("cluster".equals(this.type)) {
            res = this.jedisCluster.getSet(key, value);
        } else {
            try (Jedis jedis = null;){
                jedis = (Jedis)this.jedisPool.getResource();
                res = jedis.getSet(key, value);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T blpop(String key, int waitSeconds, Class<T> clazz) {
        if ("cluster".equals(this.type)) {
            try {
                List values = this.jedisCluster.brpop(waitSeconds, (byte[][])new byte[][]{key.getBytes()});
                if (values != null && values.size() > 0) {
                    byte[] value = (byte[])values.get(1);
                    return ConvertUtil.unserialize(value, clazz);
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        try (Jedis jedis = null;){
            jedis = (Jedis)this.jedisPool.getResource();
            List values = jedis.brpop(waitSeconds, (byte[][])new byte[][]{key.getBytes()});
            if (values != null && values.size() > 0) {
                byte[] value = (byte[])values.get(1);
                T t = ConvertUtil.unserialize(value, clazz);
                return t;
            }
            T t = null;
            return t;
        }
    }
}

