package com.ohaotian.plugin.cache;

import com.ohaotian.plugin.util.ConvertUtil;
import org.springframework.data.redis.connection.RedisClusterConnection;
import redis.clients.jedis.JedisPool;

import java.util.List;
import java.util.Set;

/** redis集群 封装基础的增删改查功能
 *
 * @author 李佳琪
 * @time 2020年4月8日11:39:02 */
public class RedisClusterManager implements CacheManager {

	/** 主机名称或者ip地址 */
	private String    host      = "115.28.105.99";

	/** 端口 */
	private int       port      = 6379;

	/** 失效时间 0为永不失效 */
	private int       expire    = 0;

	/** 连接超时时间 会自动重连 */
	private int       timeout   = 0;

	/** 密码 */
	private String    password  = "BJtGXdevRedis123";

	private RedisClusterConnection redisClusterConnection;

	public RedisClusterManager() {
	}

	/** get value from redis
	 *
	 * @param key
	 * @return */
	@Override
	public byte[] get(byte[] key) {
		byte[] value = null;
		RedisClusterConnection clusterConnection = null;
		try {
			clusterConnection = getJedisClusterPool();
			value = clusterConnection.get(key);
		}
		finally {
			if (clusterConnection != null) {
				clusterConnection.close();
			}
		}
		return value;
	}

	/** set
	 *
	 * @param key
	 * @param value
	 * @return */
	@Override
	public byte[] set(byte[] key, byte[] value) {
		RedisClusterConnection clusterConnection = null;
		try {
			clusterConnection = getJedisClusterPool();
			clusterConnection.set(key, value);
			if (this.expire != 0) {
				clusterConnection.expire(key, this.expire);
			}
		}
		finally {
			if (clusterConnection != null) {
				clusterConnection.close();
			}
		}
		return value;
	}

	/** set
	 *
	 * @param key
	 * @param value
	 * @param expire
	 * @return */
	@Override
	public byte[] set(byte[] key, byte[] value, int expire) {
		RedisClusterConnection clusterConnection = null;
		try {
			clusterConnection = getJedisClusterPool();
			clusterConnection.set(key, value);
			if (expire != 0) {
				clusterConnection.expire(key, expire);
			}
		}
		finally {
			if (clusterConnection != null) {
				clusterConnection.close();
			}
		}
		return value;
	}

	/** del
	 *
	 * @param key */
	@Override
	public void del(byte[] key) {
		RedisClusterConnection clusterConnection = null;
		try {
			clusterConnection = getJedisClusterPool();
			clusterConnection.del(key);
		}
		finally {
			if (clusterConnection != null) {
				clusterConnection.close();
			}
		}
	}

	/** flush */
	@Override
	public void flushDB() {
		RedisClusterConnection clusterConnection = null;
		try {
			clusterConnection = getJedisClusterPool();
			clusterConnection.flushDb();
		}
		finally {
			if (clusterConnection != null) {
				clusterConnection.close();
			}
		}
	}

	/** size */
	@Override
	public Long dbSize() {
		Long dbSize = 0L;
		RedisClusterConnection clusterConnection = null;
		try {
			clusterConnection = getJedisClusterPool();
			dbSize = clusterConnection.dbSize();
		}
		finally {
			if (clusterConnection != null) {
				clusterConnection.close();
			}
		}
		return dbSize;
	}

	/** keys
	 *
	 * @param pattern
	 * @return */
	@Override
	public Set<byte[]> keys(String pattern) {
		Set<byte[]> keys = null;
		RedisClusterConnection clusterConnection = null;
		try {
			clusterConnection = getJedisClusterPool();
			keys = clusterConnection.keys(pattern.getBytes());
		}
		finally {
			if (clusterConnection != null) {
				clusterConnection.close();
			}
		}
		return keys;
	}

	public String getHost() {
		return host;
	}

	public void setHost(String host) {
		this.host = host;
	}

	public int getPort() {
		return port;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public int getExpire() {
		return expire;
	}

	public void setExpire(int expire) {
		this.expire = expire;
	}

	public int getTimeout() {
		return timeout;
	}

	public void setTimeout(int timeout) {
		this.timeout = timeout;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public RedisClusterConnection getJedisClusterPool() {
		return redisClusterConnection;
	}

	@Override
	public JedisPool getJedisPool() {
		return null;
	}

	public void setJedisClusterPool(RedisClusterConnection redisClusterConnection) {
		this.redisClusterConnection = redisClusterConnection;
	}

	@Override
	public void setValueExpireTime(byte[] key, int expire) {
		RedisClusterConnection clusterConnection = null;
		try {
			clusterConnection = getJedisClusterPool();
			if (expire != 0) {
				clusterConnection.expire(key, expire);
			}
		}
		finally {
			if (clusterConnection != null) {
				clusterConnection.close();
			}
		}
	}

	@Override
	public Long getExpireTimeByKey(byte[] key) {
		Long expireTime = -1L;
		RedisClusterConnection clusterConnection = null;
		try {
			clusterConnection = getJedisClusterPool();
			expireTime = clusterConnection.ttl(key);
		}
		finally {
			if (clusterConnection != null) {
				clusterConnection.close();
			}
		}
		return expireTime;
	}

	@Override
	public Long incr(byte[] key) {
		RedisClusterConnection clusterConnection = null;
		Long num = null;
		try {
			clusterConnection = getJedisClusterPool();
			num = clusterConnection.incr(key);
		}
		finally {
			if (clusterConnection != null) {
				clusterConnection.close();
			}
		}
		return num;
	}

	@Override
	public Long incrExpireTime(byte[] key, int expire) {
		RedisClusterConnection clusterConnection = null;
		Long num = null;
		try {
			clusterConnection = getJedisClusterPool();
			num = clusterConnection.incr(key);
			clusterConnection.expire(key, expire);
		}
		finally {
			if (clusterConnection != null) {
				clusterConnection.close();
			}
		}
		return num;
	}

	@Override
	public Long incrBy(byte[] key, long conut) {
		RedisClusterConnection clusterConnection = null;
		Long num = null;
		try {
			clusterConnection = getJedisClusterPool();
			num = clusterConnection.incrBy(key, conut);
		}
		finally {
			if (clusterConnection != null) {
				clusterConnection.close();
			}
		}
		return num;
	}

	@Override
	public Long incrExpireTimeBy(byte[] key, long conut, int expire) {
		RedisClusterConnection clusterConnection = null;
		Long num = null;
		try {
			clusterConnection = getJedisClusterPool();
			num = clusterConnection.incrBy(key, conut);
			clusterConnection.expire(key, expire);
		}
		finally {
			if (clusterConnection != null) {
				clusterConnection.close();
			}
		}
		return num;
	}

	@Override
	public Long getIncr(byte[] key) {
		RedisClusterConnection clusterConnection = null;
		Long num = null;
		try {
			clusterConnection = getJedisClusterPool();
			byte[] bnum = clusterConnection.get(key);
			String numStr = bnum == null ? null : new String(bnum);
			num = numStr == null ? null : Long.parseLong(numStr);
		}
		finally {
			if (clusterConnection != null) {
				clusterConnection.close();
			}
		}
		return num;
	}


	//队列操作 begin
    /**
     * <p>通过key向list尾部添加字符串</p>
     * @param key
     * @param value 可以使一个string 也可以使string数组
     * @return 返回list的value个数
     */
	@Override
    public Long rpush(byte[] key ,byte[] value){
        RedisClusterConnection clusterConnection = null;
        Long res = null;
        try {
            clusterConnection = getJedisClusterPool();
            res = clusterConnection.rPush(key, value);
        } finally {
        	if (clusterConnection != null) {
				clusterConnection.close();
			}
        }
        return res;
    }

    /**
     * <p>通过key从list的头部删除一个value,并返回该value</p>
     * @param key
     * @return
     */
	@Override
    public String lpop(String  key){
        RedisClusterConnection clusterConnection = null;
        String res = null;
        try {
            clusterConnection = getJedisClusterPool();
			byte[] bytes = clusterConnection.lPop(key.getBytes());
			res = new String(bytes);
		} finally {
        	if (clusterConnection != null) {
				clusterConnection.close();
			}
        }
        return res;
    }

    /**
     * <p>通过key返回list的长度</p>
     * @param key
     * @return
     */
	@Override
    public Long llen(String key){
        RedisClusterConnection clusterConnection = null;
        Long res = null;
        try {
            clusterConnection = getJedisClusterPool();
            res = clusterConnection.lLen(key.getBytes());
        } finally {
        	if (clusterConnection != null) {
				clusterConnection.close();
			}
        }
        return res;
    }
	//队列操作 end

	//分布式锁 begin
	/**
     * 将 key 的值设为 value ，当且仅当 key 不存在。
     * 若给定的 key 已经存在，则 SETNX 不做任何动作。
     * SETNX 是『SET if Not eXists』(如果不存在，则 SET)的简写
     * @param key
     * @return   返回值：设置成功，返回 1 。设置失败，返回 0 。
     * */
	@Override
    public Long setnx(byte[] key,byte[] value){
        RedisClusterConnection clusterConnection = null;
        Long res = null;
        try {
            clusterConnection = getJedisClusterPool();
			Boolean aBoolean = clusterConnection.setNX(key, value);
			res = aBoolean == true? 1L:0L;
		} finally {
        	if (clusterConnection != null) {
				clusterConnection.close();
			}
        }
        return res;
    }

	/**
     * 语法：
     * GETSET key value
     * 功能：
     * 将给定 key 的值设为 value ，并返回 key 的旧值 (old value)，当 key 存在但不是字符串类型时，返回一个错误，当key不存在时，返回nil。
     * */
	@Override
    public byte[] getSet(byte[] key,byte[] value){
        RedisClusterConnection clusterConnection = null;
        byte[] res = null;
        try {
            clusterConnection = getJedisClusterPool();
            res = clusterConnection.getSet(key, value);
        } finally {
        	if (clusterConnection != null) {
				clusterConnection.close();
			}
        }
        return res;
    }
	//分布式锁 end

	/**
	 * 获取数据
	 *
	 * @param key
	 * @return
	 */
	public <T> T blpop(String key, int waitSeconds, Class<T> clazz)
	{
		RedisClusterConnection clusterConnection = null;

		try
		{
			clusterConnection = getJedisClusterPool();
			List<byte[]> values = clusterConnection.bRPop(waitSeconds, key.getBytes());
			if (values != null && values.size() > 0)
			{
				byte[] value = values.get(1);
				return ConvertUtil.unserialize(value, clazz);
			}
			else
			{
				return null;
			}
		}
		catch (Exception e)
		{
			return null;
		}
		finally
		{
			if (clusterConnection != null) {
				clusterConnection.close();
			}
		}
	}

}
