/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.cache.config;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.cache.RedisClusterManager;
import com.ohaotian.plugin.cache.RedisManager;
import com.ohaotian.plugin.cache.config.ClusterOrNot;
import com.ohaotian.plugin.cache.config.SignleOrNot;
import com.ohaotian.plugin.cache.impl.CacheClientImpl;
import com.ohaotian.plugin.common.util.RSAUtil;
import java.time.Duration;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class PluginCacheConfig {
    private static final Logger logger = LoggerFactory.getLogger(PluginCacheConfig.class);
    @Value(value="${redis.host}")
    private String host;
    @Value(value="${redis.port}")
    private int port;
    @Value(value="${redis.timeout}")
    private int timeout;
    @Value(value="${redis.pwd}")
    private String pwd;
    @Value(value="${redis.pwd.publicKey:}")
    private String publicKey;
    @Value(value="${redis.database:0}")
    private int database;
    @Value(value="${redis.pool.maxTotal}")
    private int poolMaxTotal;
    @Value(value="${redis.pool.maxIdle}")
    private int poolMaxIdle;
    @Value(value="${redis.pool.maxWaitMillis}")
    private int poolMaxWaitMillis;
    @Value(value="${redis.pool.testOnBorrow:false}")
    private boolean poolTestOnBorrow;
    @Value(value="${redis.pool.testOnReturn:false}")
    private boolean poolTestOnReturn;

    @Bean
    @Primary
    public void encrypt() {
        if (StringUtils.isNotEmpty((CharSequence)this.publicKey)) {
            try {
                logger.info("redis\u5bc6\u7801\u542f\u7528\u52a0\u5bc6\uff01");
                this.pwd = RSAUtil.decrypt((String)this.publicKey, (String)this.pwd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            RSAUtil.genKeyPair((String)"123abcd");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Bean
    @Primary
    public JedisPoolConfig jedisPoolConfig() {
        this.printRedisConfig();
        this.encrypt();
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(this.poolMaxTotal);
        config.setMaxIdle(this.poolMaxIdle);
        config.setMaxWaitMillis((long)this.poolMaxWaitMillis);
        config.setTestOnBorrow(this.poolTestOnBorrow);
        config.setTestOnReturn(this.poolTestOnReturn);
        return config;
    }

    private void printRedisConfig() {
        logger.info("plugin-cache-config:redis:host:{}, port:{}, timeout:{}, pwd:{}, database:{}", new Object[]{this.host, this.port, this.timeout, this.pwd, this.database});
        logger.info("plugin-cache-config:reids:poolMaxTotal:{}, poolMaxIdle:{}, poolMaxWaitMillis:{}, poolTestOnBorrow:{}, poolTestOnReturn:{}", new Object[]{this.poolMaxTotal, this.poolMaxIdle, this.poolMaxWaitMillis, this.poolTestOnBorrow, this.poolTestOnReturn});
    }

    @Bean
    @Primary
    @Conditional(value={SignleOrNot.class})
    public JedisPool jedisPool() {
        return new JedisPool((GenericObjectPoolConfig)this.jedisPoolConfig(), this.host, this.port, this.timeout, this.pwd, this.database);
    }

    @Bean
    @Primary
    @Conditional(value={ClusterOrNot.class})
    public RedisConnectionFactory connectionFactory() {
        String clusterNodes = this.host;
        JedisClientConfiguration clientConfig = JedisClientConfiguration.builder().usePooling().poolConfig((GenericObjectPoolConfig)this.jedisPoolConfig()).and().readTimeout(Duration.ofMillis(this.timeout)).build();
        RedisClusterConfiguration redisConfig = new RedisClusterConfiguration();
        String[] cNodes = clusterNodes.split(",");
        HashSet<RedisNode> nodes = new HashSet<RedisNode>();
        for (String node : cNodes) {
            String[] hp = node.split(":");
            nodes.add(new RedisNode(hp[0], Integer.parseInt(hp[1])));
        }
        redisConfig.setClusterNodes(nodes);
        redisConfig.setPassword(RedisPassword.of((String)this.pwd));
        return new JedisConnectionFactory(redisConfig, clientConfig);
    }

    @Bean
    @Primary
    @Conditional(value={ClusterOrNot.class})
    public RedisClusterManager redisClusterManager() {
        RedisClusterManager manager = new RedisClusterManager();
        manager.setJedisClusterPool(this.connectionFactory().getClusterConnection());
        manager.setExpire(0);
        return manager;
    }

    @Bean
    @Primary
    @Conditional(value={SignleOrNot.class})
    public RedisManager redisManager() {
        RedisManager manager = new RedisManager();
        manager.setJedisPool(this.jedisPool());
        return manager;
    }

    @Bean
    @Primary
    public CacheClient cacheClient() {
        CacheClientImpl cacheClient = new CacheClientImpl();
        if (this.host.indexOf(",") > -1) {
            logger.info("redis-cluster \u542f\u52a8");
            cacheClient.setCacheManager(this.redisClusterManager());
        } else {
            logger.info("redis \u5355\u673a\u542f\u52a8");
            cacheClient.setCacheManager(this.redisManager());
        }
        return cacheClient;
    }
}

