/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.cache.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.cache.CacheExecuterService;
import com.ohaotian.plugin.cache.CacheManager;
import com.ohaotian.plugin.cache.RedisClusterManager;
import com.ohaotian.plugin.common.util.SerializationUtils;
import com.ohaotian.plugin.util.ConvertUtil;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;

public class CacheClientImpl
implements CacheClient {
    private static final Logger log = LoggerFactory.getLogger(CacheClientImpl.class);
    private boolean isCluster = false;
    private CacheManager cacheManager;

    @Override
    public boolean isCluster() {
        return this.isCluster;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        if (cacheManager instanceof RedisClusterManager) {
            this.isCluster = true;
        }
    }

    @Override
    public void set(String key, Object value) {
        this.cacheManager.set(key.getBytes(), SerializationUtils.serializeSlightly((Object)value));
    }

    @Override
    public void put(String key, Object value) {
        this.cacheManager.set(key.getBytes(), SerializationUtils.serializeSlightly((Object)value));
    }

    @Override
    public void set(String key, Object value, int expire) {
        this.cacheManager.set(key.getBytes(), SerializationUtils.serializeSlightly((Object)value), expire);
    }

    @Override
    public void put(String key, Object value, int expire) {
        this.cacheManager.set(key.getBytes(), SerializationUtils.serializeSlightly((Object)value), expire);
    }

    @Override
    public Object get(String key) {
        byte[] value = this.cacheManager.get(key.getBytes());
        if (value == null) {
            return null;
        }
        return SerializationUtils.deserializeSlightly((byte[])value);
    }

    @Override
    public <T> T get(String key, Class<T> requiredType) {
        byte[] value = this.cacheManager.get(key.getBytes());
        if (value == null) {
            return null;
        }
        return (T)SerializationUtils.deserializeSlightly((byte[])value);
    }

    @Override
    public void delete(String key) {
        this.cacheManager.del(key.getBytes());
    }

    @Override
    public <T> T getFinal(CacheExecuterService<T> executer, String ... key) {
        String finalKey = this.getFinalKey(key);
        log.debug("finalKey=" + finalKey);
        byte[] value = this.cacheManager.get(finalKey.getBytes());
        if (value == null || value.length == 0) {
            log.debug("\u6570\u636e\u5728\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\uff01\u6267\u884c\u672c\u5730\u6570\u636e\u67e5\u8be2\u5668\u67e5\u8be2\u6570\u636e");
            T obj = executer.getParamFromDb(key);
            if (obj != null && !"".equals(obj)) {
                log.debug("value=" + obj.toString());
                this.put(finalKey, obj);
                return obj;
            }
            log.debug("\u6570\u636e\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01");
            return null;
        }
        Object finalValue = SerializationUtils.deserializeSlightly((byte[])value);
        log.debug("value=" + finalValue);
        return (T)finalValue;
    }

    private String getFinalKey(String ... key) {
        StringBuffer fkey = new StringBuffer();
        for (String s : key) {
            fkey.append(s);
            fkey.append("_");
        }
        fkey.setLength(fkey.length() - 1);
        return fkey.toString();
    }

    @Override
    public Set<String> getkeys(String pattern) {
        HashSet<String> keys = new HashSet<String>();
        Set<byte[]> keybs = this.cacheManager.keys(pattern);
        for (byte[] bs : keybs) {
            keys.add(new String(bs));
        }
        return keys;
    }

    @Override
    public Set<String> scan(String pattern) {
        return this.cacheManager.scan(pattern);
    }

    @Override
    public Long getExpireTimeByKey(String key) {
        return this.cacheManager.getExpireTimeByKey(key.getBytes());
    }

    @Override
    public Long incr(String key) {
        return this.cacheManager.incr(key.getBytes());
    }

    @Override
    public Long incrExpireTime(String key, int expire) {
        return this.cacheManager.incrExpireTime(key.getBytes(), expire);
    }

    @Override
    public Long incrBy(String key, long num) {
        return this.cacheManager.incrBy(key.getBytes(), num);
    }

    @Override
    public Long incrExpireTimeBy(String key, long num, int expire) {
        return this.cacheManager.incrExpireTimeBy(key.getBytes(), num, expire);
    }

    @Override
    public Long getIncr(String key) {
        return this.cacheManager.getIncr(key.getBytes());
    }

    @Override
    public Long rpush(String key, Object obj) {
        return this.cacheManager.rpush(key.getBytes(), ConvertUtil.serialize(obj));
    }

    @Override
    public String lpop(String key) {
        return this.cacheManager.lpop(key);
    }

    @Override
    public Long llen(String key) {
        return this.cacheManager.llen(key);
    }

    @Override
    public Long setnx(String key, Object value) {
        return this.cacheManager.setnx(key.getBytes(), SerializationUtils.serializeSlightly((Object)value));
    }

    @Override
    public Object getSet(String key, Object value) {
        byte[] bytes = this.cacheManager.getSet(key.getBytes(), SerializationUtils.serializeSlightly((Object)value));
        return bytes == null ? null : SerializationUtils.deserializeSlightly((byte[])bytes);
    }

    @Override
    public JedisPool getJedisPool() {
        return this.cacheManager.getJedisPool();
    }

    @Override
    public JedisCluster getJedisCluster() {
        return this.cacheManager.getJedisCluster();
    }

    @Override
    public <T> T blpop(String key, int waitSeconds, Class<T> clazz) {
        return this.cacheManager.blpop(key, waitSeconds, clazz);
    }

    @Override
    public Long expire(String key, int secound) {
        return this.cacheManager.expire(key, secound);
    }
}

