/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.util;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtobufIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConvertUtil {
    private static Map<Class<?>, Schema<?>> cachedSchema = new ConcurrentHashMap();

    private static <T> Schema<T> getSchema(Class<T> cls) {
        RuntimeSchema schema = cachedSchema.get(cls);
        if (schema == null && (schema = RuntimeSchema.createFrom(cls)) != null) {
            cachedSchema.put(cls, (Schema<?>)schema);
        }
        return schema;
    }

    public static <T> byte[] serialize(T obj) {
        Class<?> cls = obj.getClass();
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            Schema<?> schema = ConvertUtil.getSchema(cls);
            byte[] byArray = ProtobufIOUtil.toByteArray(obj, schema, (LinkedBuffer)buffer);
            return byArray;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            buffer.clear();
        }
    }

    public static <T> T unserialize(byte[] data, Class<T> cls) {
        try {
            T message = cls.newInstance();
            Schema<T> schema = ConvertUtil.getSchema(cls);
            ProtobufIOUtil.mergeFrom((byte[])data, message, schema);
            return message;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

