/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.cache;

import com.ohaotian.plugin.cache.CacheManager;
import com.ohaotian.plugin.util.ConvertUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

public class RedisSentinelManager
implements CacheManager {
    private Set<String> sentinels;
    private String masterName;
    private String host = "115.28.105.99";
    private int port = 6379;
    private int expire = 0;
    private int timeout = 0;
    private String password = "BJtGXdevRedis123";
    private JedisSentinelPool jedisSentinelPool = null;

    public RedisSentinelManager() {
    }

    public RedisSentinelManager(Set<String> sentinels, String masterName, String password) {
        this.sentinels = sentinels;
        this.masterName = masterName;
        this.password = password;
    }

    public RedisSentinelManager(Set<String> sentinels, String masterName, String password, int expire, int timeout) {
        this.sentinels = sentinels;
        this.masterName = masterName;
        this.password = password;
        this.expire = expire;
        this.timeout = timeout;
    }

    public void init() {
        if (this.jedisSentinelPool == null) {
            this.jedisSentinelPool = this.password != null && !"".equals(this.password) ? new JedisSentinelPool(this.masterName, this.sentinels, (GenericObjectPoolConfig)new JedisPoolConfig(), this.timeout, this.password) : (this.timeout != 0 ? new JedisSentinelPool(this.masterName, this.sentinels, (GenericObjectPoolConfig)new JedisPoolConfig(), this.timeout) : new JedisSentinelPool(this.masterName, this.sentinels, (GenericObjectPoolConfig)new JedisPoolConfig()));
        }
    }

    public void setJedisClusterPool(JedisSentinelPool jedisSentinelPool) {
        this.jedisSentinelPool = jedisSentinelPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(byte[] key) {
        byte[] value = null;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            value = jedis.get(key);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] set(byte[] key, byte[] value) {
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            jedis.set(key, value);
            if (this.expire != 0) {
                jedis.expire(key, (long)this.expire);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String set(String key, String value) {
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            jedis.set(key, value);
            if (this.expire != 0) {
                jedis.expire(key, (long)this.expire);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String set(String key, String value, int expire) {
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            jedis.set(key, value);
            if (expire != 0) {
                jedis.expire(key, (long)expire);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] set(byte[] key, byte[] value, int expire) {
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            jedis.set(key, value);
            if (expire != 0) {
                jedis.expire(key, (long)expire);
            }
        }
        return value;
    }

    @Override
    public void del(byte[] key) {
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            jedis.del(key);
        }
    }

    @Override
    public void flushDB() {
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            jedis.flushDB();
        }
    }

    @Override
    public Long dbSize() {
        Long dbSize = 0L;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            dbSize = jedis.dbSize();
        }
        return dbSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> keys(String pattern) {
        Set keys = null;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            keys = jedis.keys(pattern.getBytes());
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> scan(String pattern) {
        HashSet<String> scans = new HashSet<String>();
        try (Jedis jedis = null;){
            ScanResult scan;
            jedis = this.jedisSentinelPool.getResource();
            ScanParams scanParams = new ScanParams();
            scanParams.match(pattern);
            scanParams.count(Integer.valueOf(1000));
            String scanStart = ScanParams.SCAN_POINTER_START;
            while (!ScanParams.SCAN_POINTER_START.equals(scanStart = (scan = jedis.scan(scanStart, scanParams)).getCursor())) {
                List resultList = scan.getResult();
                if (resultList == null) break;
                if (resultList.size() == 0) {
                    break;
                }
                scans.addAll(resultList);
            }
        }
        return scans;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getExpire() {
        return this.expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public JedisPool getJedisPool() {
        return null;
    }

    @Override
    public JedisCluster getJedisCluster() {
        return null;
    }

    @Override
    public JedisSentinelPool getJedisSentinel() {
        return this.jedisSentinelPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueExpireTime(byte[] key, int expire) {
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            if (expire != 0) {
                jedis.expire(key, (long)expire);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getExpireTimeByKey(byte[] key) {
        Long expireTime = -1L;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            expireTime = jedis.ttl(key);
        }
        return expireTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incr(byte[] key) {
        Long num = null;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            num = jedis.incr(key);
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrExpireTime(byte[] key, int expire) {
        Long num = null;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            num = jedis.incr(key);
            jedis.expire(key, (long)expire);
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrBy(byte[] key, long conut) {
        Long num = null;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            num = jedis.incrBy(key, conut);
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrExpireTimeBy(byte[] key, long conut, int expire) {
        Long num = null;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            num = jedis.incrBy(key, conut);
            jedis.expire(key, (long)expire);
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getIncr(byte[] key) {
        Long num = null;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            byte[] bnum = jedis.get(key);
            String numStr = bnum == null ? null : new String(bnum);
            num = numStr == null ? null : Long.valueOf(Long.parseLong(numStr));
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long rpush(byte[] key, byte[] value) {
        Long res = null;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            res = jedis.rpush(key, (byte[][])new byte[][]{value});
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lpop(String key) {
        String res = null;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            res = jedis.lpop(key);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long llen(String key) {
        Long res = null;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            res = jedis.llen(key);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long setnx(byte[] key, byte[] value) {
        Long res = null;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            res = jedis.setnx(key, value);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        byte[] res = null;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            res = jedis.getSet(key, value);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T blpop(String key, int waitSeconds, Class<T> clazz) {
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            List values = jedis.brpop(waitSeconds, (byte[][])new byte[][]{key.getBytes()});
            if (values != null && values.size() > 0) {
                byte[] value = (byte[])values.get(1);
                T t = ConvertUtil.unserialize(value, clazz);
                return t;
            }
            T t = null;
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long expire(String key, int secound) {
        Long expire = null;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            expire = jedis.expire(key, (long)secound);
        }
        return expire;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> hgetAll(String key) {
        Map var3;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            var3 = jedis.hgetAll(key);
        }
        return var3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hdel(String key, String ... fields) {
        Long var4;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            var4 = jedis.hdel(key, fields);
        }
        return var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hset(String key, String field, String value) {
        Long var5;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            var5 = jedis.hset(key, field, value);
        }
        return var5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hget(String key, String field) {
        String var4;
        try (Jedis jedis = null;){
            jedis = this.jedisSentinelPool.getResource();
            var4 = jedis.hget(key, field);
        }
        return var4;
    }
}

