package com.ohaotian.plugin.cache;

import com.ohaotian.plugin.util.ConvertUtil;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisClusterException;

import java.util.List;
import java.util.Set;

/** redis集群 封装基础的增删改查功能
 *
 * @author 李佳琪
 * @time 2020年4月8日11:39:02 */
public class RedisClusterManager implements CacheManager {

	/** 主机名称或者ip地址 */
	private String    host      = "115.28.105.99";

	/** 端口 */
	private int       port      = 6379;

	/** 失效时间 0为永不失效 */
	private int       expire    = 0;

	/** 连接超时时间 会自动重连 */
	private int       timeout   = 0;

	/** 密码 */
	private String    password  = "BJtGXdevRedis123";

	private JedisCluster jedisCluster;

	public RedisClusterManager() {
	}

	/** get value from redis
	 *
	 * @param key
	 * @return */
	@Override
	public byte[] get(byte[] key) {
		byte[] value = null;
		JedisCluster jedisCluster = null;
		try {
			jedisCluster = getJedisCluster();
			value = jedisCluster.get(key);
		}
		finally {

		}
		return value;
	}

	/** set
	 *
	 * @param key
	 * @param value
	 * @return */
	@Override
	public byte[] set(byte[] key, byte[] value) {
		JedisCluster jedisCluster = null;
		try {
			jedisCluster = getJedisCluster();
			jedisCluster.set(key, value);
			if (this.expire != 0) {
				jedisCluster.expire(key, this.expire);
			}
		}
		finally {

		}
		return value;
	}

	/** set
	 *
	 * @param key
	 * @param value
	 * @param expire
	 * @return */
	@Override
	public byte[] set(byte[] key, byte[] value, int expire) {
		JedisCluster jedisCluster = null;
		try {
			jedisCluster = getJedisCluster();
			jedisCluster.set(key, value);
			if (expire != 0) {
				jedisCluster.expire(key, expire);
			}
		}
		finally {

		}
		return value;
	}

	/** del
	 *
	 * @param key */
	@Override
	public void del(byte[] key) {
		JedisCluster jedisCluster = null;
		try {
			jedisCluster = getJedisCluster();
			jedisCluster.del(key);
		}
		finally {

		}
	}

	/** flush */
	@Override
	public void flushDB() {
		throw new JedisClusterException("No way to dispatch this command to Redis Cluster.");
	}

	/** size */
	@Override
	public Long dbSize() {
		throw new JedisClusterException("No way to dispatch this command to Redis Cluster.");
	}

	/** keys
	 *
	 * @param pattern
	 * @return */
	@Override
	public Set<byte[]> keys(String pattern) {
		Set<byte[]> keys = null;
		JedisCluster jedisCluster = null;
		try {
			jedisCluster = getJedisCluster();
			keys = jedisCluster.keys(pattern.getBytes());
		}
		finally {

		}
		return keys;
	}

	public String getHost() {
		return host;
	}

	public void setHost(String host) {
		this.host = host;
	}

	public int getPort() {
		return port;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public int getExpire() {
		return expire;
	}

	public void setExpire(int expire) {
		this.expire = expire;
	}

	public int getTimeout() {
		return timeout;
	}

	public void setTimeout(int timeout) {
		this.timeout = timeout;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public JedisCluster getJedisCluster() {
		return jedisCluster;
	}

	@Override
	public JedisPool getJedisPool() {
		return null;
	}

	public void setJedisClusterPool(JedisCluster jedisCluster) {
		this.jedisCluster = jedisCluster;
	}

	@Override
	public void setValueExpireTime(byte[] key, int expire) {
		JedisCluster jedisCluster = null;
		try {
			jedisCluster = getJedisCluster();
			if (expire != 0) {
				jedisCluster.expire(key, expire);
			}
		}
		finally {

		}
	}

	@Override
	public Long getExpireTimeByKey(byte[] key) {
		Long expireTime = -1L;
		JedisCluster jedisCluster = null;
		try {
			jedisCluster = getJedisCluster();
			expireTime = jedisCluster.ttl(key);
		}
		finally {

		}
		return expireTime;
	}

	@Override
	public Long incr(byte[] key) {
		JedisCluster jedisCluster = null;
		Long num = null;
		try {
			jedisCluster = getJedisCluster();
			num = jedisCluster.incr(key);
		}
		finally {

		}
		return num;
	}

	@Override
	public Long incrExpireTime(byte[] key, int expire) {
		JedisCluster jedisCluster = null;
		Long num = null;
		try {
			jedisCluster = getJedisCluster();
			num = jedisCluster.incr(key);
			jedisCluster.expire(key, expire);
		}
		finally {

		}
		return num;
	}

	@Override
	public Long incrBy(byte[] key, long conut) {
		JedisCluster jedisCluster = null;
		Long num = null;
		try {
			jedisCluster = getJedisCluster();
			num = jedisCluster.incrBy(key, conut);
		}
		finally {

		}
		return num;
	}

	@Override
	public Long incrExpireTimeBy(byte[] key, long conut, int expire) {
		JedisCluster jedisCluster = null;
		Long num = null;
		try {
			jedisCluster = getJedisCluster();
			num = jedisCluster.incrBy(key, conut);
			jedisCluster.expire(key, expire);
		}
		finally {

		}
		return num;
	}

	@Override
	public Long getIncr(byte[] key) {
		JedisCluster jedisCluster = null;
		Long num = null;
		try {
			jedisCluster = getJedisCluster();
			byte[] bnum = jedisCluster.get(key);
			String numStr = bnum == null ? null : new String(bnum);
			num = numStr == null ? null : Long.parseLong(numStr);
		}
		finally {

		}
		return num;
	}


	//队列操作 begin
    /**
     * <p>通过key向list尾部添加字符串</p>
     * @param key
     * @param value 可以使一个string 也可以使string数组
     * @return 返回list的value个数
     */
	@Override
    public Long rpush(byte[] key ,byte[] value){
        JedisCluster jedisCluster = null;
        Long res = null;
        try {
            jedisCluster = getJedisCluster();
            res = jedisCluster.rpush(key, value);
        } finally {

        }
        return res;
    }

    /**
     * <p>通过key从list的头部删除一个value,并返回该value</p>
     * @param key
     * @return
     */
	@Override
    public String lpop(String  key){
        JedisCluster jedisCluster = null;
        String res = null;
        try {
            jedisCluster = getJedisCluster();
			byte[] bytes = jedisCluster.lpop(key.getBytes());
			res = new String(bytes);
		} finally {

        }
        return res;
    }

    /**
     * <p>通过key返回list的长度</p>
     * @param key
     * @return
     */
	@Override
    public Long llen(String key){
        JedisCluster jedisCluster = null;
        Long res = null;
        try {
            jedisCluster = getJedisCluster();
            res = jedisCluster.llen(key.getBytes());
        } finally {

        }
        return res;
    }
	//队列操作 end

	//分布式锁 begin
	/**
     * 将 key 的值设为 value ，当且仅当 key 不存在。
     * 若给定的 key 已经存在，则 SETNX 不做任何动作。
     * SETNX 是『SET if Not eXists』(如果不存在，则 SET)的简写
     * @param key
     * @return   返回值：设置成功，返回 1 。设置失败，返回 0 。
     * */
	@Override
    public Long setnx(byte[] key,byte[] value){
        JedisCluster jedisCluster = null;
        Long res = null;
        try {
            jedisCluster = getJedisCluster();
			res = jedisCluster.setnx(key, value);
		} finally {

        }
        return res;
    }

	/**
     * 语法：
     * GETSET key value
     * 功能：
     * 将给定 key 的值设为 value ，并返回 key 的旧值 (old value)，当 key 存在但不是字符串类型时，返回一个错误，当key不存在时，返回nil。
     * */
	@Override
    public byte[] getSet(byte[] key,byte[] value){
        JedisCluster jedisCluster = null;
        byte[] res = null;
        try {
            jedisCluster = getJedisCluster();
            res = jedisCluster.getSet(key, value);
        } finally {

        }
        return res;
    }
	//分布式锁 end

	/**
	 * 获取数据
	 *
	 * @param key
	 * @return
	 */
	public <T> T blpop(String key, int waitSeconds, Class<T> clazz)
	{
		JedisCluster jedisCluster = null;

		try
		{
			jedisCluster = getJedisCluster();
			List<byte[]> values = jedisCluster.brpop(waitSeconds, key.getBytes());
			if (values != null && values.size() > 0)
			{
				byte[] value = values.get(1);
				return ConvertUtil.unserialize(value, clazz);
			}
			else
			{
				return null;
			}
		}
		catch (Exception e)
		{
			return null;
		}
		finally
		{

		}
	}

	@Override
	public Long expire(String key, int secound) {
		JedisCluster jedisCluster = null;
		Long expire = null;
		try {
			jedisCluster = getJedisCluster();
			expire = jedisCluster.expire(key, secound);
		} finally {

		}
		return expire;
	}

}
