/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.common.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.ohaotian.plugin.base.bo.RspPage;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private Logger logger = LoggerFactory.getLogger(ReturnValueHandler.class);

    public boolean supportsReturnType(MethodParameter returnType) {
        boolean hasJSONAnno = returnType.getMethodAnnotation(BusiResponseBody.class) != null || returnType.getMethodAnnotation(BusiResponseBody.class) != null;
        return hasJSONAnno;
    }

    public void handleReturnValue(Object obj, MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest) throws Exception {
        modelAndViewContainer.setRequestHandled(true);
        HttpServletResponse response = (HttpServletResponse)nativeWebRequest.getNativeResponse(HttpServletResponse.class);
        response.setContentType("application/json;charset=UTF-8");
        this.logger.info("\u8bf7\u6c42\u6210\u529f\uff0c\u8fd4\u56de\u6d88\u606f\u8f6c\u6362");
        HashMap<String, Object> rsp = new HashMap<String, Object>();
        if (obj instanceof RspPage) {
            rsp.put("data", obj);
            rsp.put("code", "0");
            rsp.put("message", "\u6210\u529f");
            this.returnMsg(rsp, response);
        } else if (obj instanceof RspBaseBO) {
            Map<String, Object> transBean2Map = this.transBean2Map(obj);
            rsp.put("code", "0");
            rsp.put("message", "\u6210\u529f");
            transBean2Map.remove("code");
            transBean2Map.remove("message");
            if (transBean2Map.size() == 1) {
                Set<String> keySet = transBean2Map.keySet();
                for (String str : keySet) {
                    Object o = transBean2Map.get(str);
                    rsp.put("data", o);
                }
            } else {
                rsp.put("data", transBean2Map);
            }
            this.returnMsg(rsp, response);
        } else {
            Map<String, Object> transBean2Map = this.transBean2Map(obj);
            rsp.put("code", "0");
            rsp.put("message", "\u6210\u529f");
            if (transBean2Map != null && !transBean2Map.isEmpty()) {
                rsp.put("data", obj);
            }
            this.returnMsg(rsp, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnMsg(Object msg, HttpServletResponse response) {
        try (PrintWriter writer = null;){
            response.setContentType("text/plain;charset=UTF-8");
            writer = response.getWriter();
            writer.write(JSON.toJSONString((Object)msg, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullBooleanAsFalse}));
            writer.flush();
        }
    }

    private Map<String, Object> transBean2Map(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method getter;
                String key = property.getName();
                if (key.equals("class") || (getter = property.getReadMethod()) == null) continue;
                Object value = getter.invoke(obj, new Object[0]);
                map.put(key, value);
            }
        }
        catch (Exception e) {
            this.logger.error("transBean2Map Error ", (Throwable)e);
        }
        return map;
    }
}

