/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.common.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.ohaotian.plugin.common.strategy.ExceptionStrategy;
import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Order(value=-1000)
public class ExceptionResolver
implements HandlerExceptionResolver {
    private Logger logger = LoggerFactory.getLogger(ExceptionResolver.class);

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception e) {
        RspBaseBO result = new RspBaseBO();
        if (e instanceof ExceptionStrategy) {
            ExceptionStrategy exceptionStrategy = (ExceptionStrategy)e;
            String msg = exceptionStrategy.resolverException();
            this.addResult(result, msg);
        } else if (e instanceof ConstraintViolationException) {
            this.resolverBindException(e, result);
        } else {
            this.addResult(result, "\u7cfb\u7edf\u5f02\u5e38");
        }
        this.logger.error("\u7a0b\u5e8f\u51fa\u73b0\u5f02\u5e38\uff1a" + result.getMessage(), (Throwable)e);
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        try {
            response.getWriter().write(JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullBooleanAsFalse}));
        }
        catch (IOException ex) {
            this.logger.error("\u4e0e\u5ba2\u6237\u7aef\u901a\u8baf\u5f02\u5e38\uff1a" + ex.getMessage(), (Throwable)ex);
        }
        return new ModelAndView();
    }

    private void resolverBindException(Throwable e, RspBaseBO result) {
        ConstraintViolationException ve = (ConstraintViolationException)e;
        Set violations = ve.getConstraintViolations();
        StringBuilder sb = new StringBuilder();
        int size = violations.size();
        int[] num = new int[]{1};
        violations.forEach(entry -> {
            int n = num[0];
            num[0] = n + 1;
            if (size == n) {
                sb.append(entry.getMessage());
            } else {
                sb.append(entry.getMessage()).append("\u5e76\u4e14");
            }
        });
        this.addResult(result, sb.toString());
    }

    private final void addResult(RspBaseBO result, String message) {
        result.setCode("1");
        result.setMessage(message);
    }
}

