/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DelFormatHelper {
    private static final String sdf17_string = "yyyyMMddHHmmssSSS";
    private static final ThreadLocal<SimpleDateFormat> threadLocalSdf17 = new ThreadLocal();
    private static final String sdf14_string = "yyyyMMddHHmmss";
    private static final ThreadLocal<SimpleDateFormat> threadLocalSdf14 = new ThreadLocal();
    private static final String sdf_string = "yyyy-MM-dd HH:mm:ss";
    private static final ThreadLocal<SimpleDateFormat> threadLocalSdf = new ThreadLocal();
    private static final String sdfYearMonth_string = "yyyyMM";
    private static final ThreadLocal<SimpleDateFormat> threadLocalSdfYearMonth = new ThreadLocal();
    private static final String sdfYearMonthDay_string = "yyyyMMdd";
    private static final ThreadLocal<SimpleDateFormat> threadLocalSdfYearMonthDay = new ThreadLocal();
    private static final String sdfYearMonthDay2_string = "yyyy-MM-dd";
    private static final ThreadLocal<SimpleDateFormat> threadLocalSdfYearMonthDay2 = new ThreadLocal();
    private static final String sdfymdhm_string = "yyyy-MM-dd HH:mm";
    private static final ThreadLocal<SimpleDateFormat> threadLocalSdfymdhmg = new ThreadLocal();

    private static SimpleDateFormat getSdf17() {
        SimpleDateFormat sdf17 = threadLocalSdf17.get();
        if (sdf17 == null) {
            sdf17 = new SimpleDateFormat(sdf17_string);
            threadLocalSdf17.set(sdf17);
        }
        return sdf17;
    }

    private static SimpleDateFormat getSdf14() {
        SimpleDateFormat sdf14 = threadLocalSdf14.get();
        if (sdf14 == null) {
            sdf14 = new SimpleDateFormat(sdf14_string);
            threadLocalSdf14.set(sdf14);
        }
        return sdf14;
    }

    private static SimpleDateFormat getDateSdf() {
        SimpleDateFormat sdf = threadLocalSdfYearMonthDay2.get();
        if (sdf == null) {
            sdf = new SimpleDateFormat(sdfYearMonthDay2_string);
            threadLocalSdfYearMonthDay2.set(sdf);
        }
        return sdf;
    }

    private static SimpleDateFormat getSdf() {
        SimpleDateFormat sdf = threadLocalSdf.get();
        if (sdf == null) {
            sdf = new SimpleDateFormat(sdf_string);
            threadLocalSdf.set(sdf);
        }
        return sdf;
    }

    private static SimpleDateFormat getSdfYearMonth() {
        SimpleDateFormat sdfYearMonth = threadLocalSdfYearMonth.get();
        if (sdfYearMonth == null) {
            sdfYearMonth = new SimpleDateFormat(sdfYearMonth_string);
            threadLocalSdfYearMonth.set(sdfYearMonth);
        }
        return sdfYearMonth;
    }

    private static SimpleDateFormat getSdfymdhmDay() {
        SimpleDateFormat sdfymdhmDay = threadLocalSdfymdhmg.get();
        if (sdfymdhmDay == null) {
            sdfymdhmDay = new SimpleDateFormat(sdfymdhm_string);
            threadLocalSdfymdhmg.set(sdfymdhmDay);
        }
        return sdfymdhmDay;
    }

    private static SimpleDateFormat getSdfYearMonthDay() {
        SimpleDateFormat sdfYearMonthDay = threadLocalSdfYearMonthDay.get();
        if (sdfYearMonthDay == null) {
            sdfYearMonthDay = new SimpleDateFormat(sdfYearMonthDay_string);
            threadLocalSdfYearMonthDay.set(sdfYearMonthDay);
        }
        return sdfYearMonthDay;
    }

    public static String getDateStringFor14Nums() {
        return DelFormatHelper.getSdf14().format(new Date(System.currentTimeMillis()));
    }

    public static String getNowTimeForString() {
        return DelFormatHelper.getSdf().format(new Date(System.currentTimeMillis()));
    }

    public static String getNowTimeForString(String dateStr) throws ParseException {
        return DelFormatHelper.getSdf14().format(DelFormatHelper.getSdf().parse(dateStr));
    }

    public static Date fromSdfToDate(String dateStr) throws ParseException {
        return DelFormatHelper.getSdf().parse(dateStr);
    }

    public static Date strToDate(String dateStr) throws ParseException {
        return DelFormatHelper.getDateSdf().parse(dateStr);
    }

    public static Date fromStrymdhmToDate(String dateStr) throws ParseException {
        return DelFormatHelper.getSdfymdhmDay().parse(dateStr);
    }

    public static Date fromSdf17ToDate(String dateStr) throws ParseException {
        return DelFormatHelper.getSdf17().parse(dateStr);
    }

    public static Date fromSdf14ToDate(String dateStr) throws ParseException {
        return DelFormatHelper.getSdf14().parse(dateStr);
    }

    public static String fromDateToSdf17(Date date) {
        return DelFormatHelper.getSdf17().format(date);
    }

    public static Integer getNowYearAndMonth() {
        return Integer.parseInt(DelFormatHelper.getSdfYearMonth().format(new Date(System.currentTimeMillis())));
    }

    public static String getNowYearAndMonthDayString() {
        return DelFormatHelper.getSdfYearMonthDay().format(new Date(System.currentTimeMillis()));
    }

    public static Integer[] getOldSexMonthBefNow() {
        Integer[] months = new Integer[6];
        SimpleDateFormat format = DelFormatHelper.getSdfYearMonth();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(System.currentTimeMillis()));
        for (int i = 1; i < 7; ++i) {
            calendar.add(2, -1);
            Date month = calendar.getTime();
            months[i - 1] = Integer.parseInt(format.format(month));
        }
        return months;
    }

    public static String getYesterdayYearMonthDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(System.currentTimeMillis()));
        calendar.add(5, -1);
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(sdfYearMonthDay_string);
        return sdf.format(date);
    }

    public static String getForworday() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(System.currentTimeMillis()));
        calendar.add(5, -1);
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
        return sdf.format(date);
    }

    private static SimpleDateFormat getSdfYmdhm() {
        SimpleDateFormat sdfYearMonthDay = threadLocalSdfymdhmg.get();
        if (sdfYearMonthDay == null) {
            sdfYearMonthDay = new SimpleDateFormat(sdfymdhm_string);
            threadLocalSdfymdhmg.set(sdfYearMonthDay);
        }
        return sdfYearMonthDay;
    }

    public static String getNowYearMothDayHourMin() {
        return DelFormatHelper.getSdfYmdhm().format(new Date(System.currentTimeMillis()));
    }

    public static String getNowYearAndMonthString() {
        return DelFormatHelper.getSdfYearMonth().format(new Date(System.currentTimeMillis()));
    }

    private static SimpleDateFormat getSdfYearMonthDay2() {
        SimpleDateFormat sdfYearMonthDay = threadLocalSdfYearMonthDay2.get();
        if (sdfYearMonthDay == null) {
            sdfYearMonthDay = new SimpleDateFormat(sdfYearMonthDay2_string);
            threadLocalSdfYearMonthDay2.set(sdfYearMonthDay);
        }
        return sdfYearMonthDay;
    }

    public static Date getNowYearAndMonthDay() throws ParseException {
        String dateStr = DelFormatHelper.getSdfYearMonthDay().format(new Date(System.currentTimeMillis()));
        return DelFormatHelper.getSdfYearMonthDay().parse(dateStr);
    }

    public static Date getNowYearAndMonthDay(String dateStr) throws ParseException {
        return DelFormatHelper.getSdfYearMonthDay().parse(dateStr);
    }

    public static Date longToDate(long currentTime) {
        Date date = new Date(currentTime);
        return date;
    }

    public static String fromDateToSdf(Date date) {
        return DelFormatHelper.getSdf().format(date);
    }

    public static String fromDateToStr(Date date) {
        return DelFormatHelper.getDateSdf().format(date);
    }
}

