package com.ohaotian.plugin.common.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.constant.BaseRspConstants;
import com.ohaotian.plugin.base.exception.strategy.ExceptionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author liubq
 * @Description: 统一异常处理器
 */
@Order(-1000)
public class ExceptionResolver implements HandlerExceptionResolver {
    /**
     * 异常日志
     */
    private Logger logger = LoggerFactory.getLogger(ExceptionResolver.class);

    @Override
    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception e) {

        Map<String,Object> result = new HashMap<>();

        if (e instanceof ExceptionStrategy) {
            ExceptionStrategy exceptionStrategy = (ExceptionStrategy) e;
            String msg = exceptionStrategy.resolverException();
            addResult(result, msg);
        } else if (e instanceof ConstraintViolationException) {
            resolverBindException(e, result);
        } else {
            //处理其他异常
            addResult(result, BaseRspConstants.RSP_DESC_ERROR);
        }
        logger.error("程序出现异常：" + JSON.toJSONString(result), e);

        response.setContentType(MediaType.APPLICATION_JSON_VALUE);
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        try {
            response.getWriter().write(JSON.toJSONString(result, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullBooleanAsFalse));
        } catch (IOException ex) {
            logger.error("与客户端通讯异常：" + ex.getMessage(), ex);
        }
        return new ModelAndView();

    }

    /**
     * 处理参数绑定异常
     */
    private void resolverBindException(Throwable e, Map<String,Object> result) {
        // 里面嵌了一个ConstraintViolationException
        ConstraintViolationException ve = (ConstraintViolationException) e;
        // 可以拿到一个验证错误详细信息的集合
        Set<ConstraintViolation<?>> violations = ve.getConstraintViolations();
        StringBuilder sb = new StringBuilder();

        int size = violations.size();
        final int[] num = {1};
        violations.forEach(entry -> {
            if (size == num[0]++) {
                sb.append(entry.getMessage());
            } else {
                sb.append(entry.getMessage()).append("并且");
            }

        });
        addResult(result, sb.toString());
    }


    /**
     * 封装code和msg
     */
    private final void addResult(Map<String,Object> result, final String message) {
        result.put("code",BaseRspConstants.CODE_FAILUR);
        result.put("message",message);
    }
}
