package com.ohaotian.plugin.common.context;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Slf4j
@Order(1)
@Component
public class SpringContextHoderInitalizer implements ApplicationContextAware {

    /**
     * Set the ApplicationContext that this object runs in.
     * Normally this call will be used to initialize the object.
     * <p>Invoked after population of normal bean properties but before an init callback such
     * as {@link InitializingBean#afterPropertiesSet()}
     *
     * @throws BeansException              if thrown by application context methods
     * @see BeanInitializationException
     */
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        log.info("~~ Invoked SpringContextHolderInitalizer#setApplicationContext Method..Begin");
        SpringContextHolder.setApplicationContext(applicationContext);
        //SpringContextHolder.setEnvironment(SpringContextHolder.getActiveProfile());
        log.info("~~ Invoked SpringContextHolderInitalizer#setApplicationContext Method..End");
    }
}