package com.ohaotian.plugin.common.util;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpUriRequest;
import com.taobao.eagleeye.EagleEye;

/** 阿里鹰眼监控平台工具类
 * 
 * @author liuchang
 * @since 2016.9.18 */
public class EagleEyeUtils {

	private static final Log log = LogFactory.getLog(EagleEyeUtils.class);

	/** 标识一次trace调用的开始，traceName为用户设置，EagleEye在展示时会以该参数为分组条件
	 * 
	 * @param  -traceId
	 *        交易流水号
	 * @param url
	 *        根据 osn 具体情况，暂定为 ip+svcName */
	public static String startTrance(String url) {
		String tranceId = EagleEye.generateTraceId(null);// 生成traceId
//		String tranceId = EagleEye.getRpcId();// 生成traceId

		EagleEye.startTrace(tranceId, url);
		return tranceId;
	}

	// 一次 trace 调用结束
	public static void endTrance(Map<String, String> attributeMap) {
		endTrance(attributeMap, null);
	}

	/** 标识一次trace调用的结束
	 * 
	 * @param attributeMap
	 *        属性参数 map
	 * @param statusCode
	 *        状态码，默认为 00 */
	public static void endTrance(Map<String, String> attributeMap, String statusCode) {
		if (attributeMap != null && attributeMap.size() > 0) {
			Iterator<String> it = attributeMap.keySet().iterator();
			while (it.hasNext()) {
				String key = it.next();
				String value = attributeMap.get(key);
				EagleEye.attribute(key, value); // 设置RPC类型名
			}
		}
		if (statusCode == null) {
			statusCode = "00";
		}
		EagleEye.endTrace("00", 90); // 标识一次trace调用结束，设置状态码(00)和RpcType(90)
	}

	/** 开始一次 Rpc 调用
	 * 
	 * @param nodeName
	 *        节点名称：OSN SC HSN
	 * @param selfDefHeader ->ServiceName
	 *        服务名 */
	public static HttpUriRequest startRpc(HttpUriRequest request, String nodeName, Header selfDefHeader) {
//		BasicHeader bh = (BasicHeader) selfDefHeader;
//		SelfDefHeader header = new SelfDefHeader(bh.getValue());
//		EagleEye.startRpc(nodeName, header.getSvcName()); // 标识一次Rpc调用开始，设置服务名和方法名
//		EagleEye.remoteIp(request.getURI().getHost()); // 设置服务端IP
//		EagleEye.rpcClientSend(); // 标识客户端发送RPC调用请求
//
//		// 把 EagleEye 的当前上下文作为“附件”传送出去
//		request.addHeader(Constants.EagleEye._EagleEyeTraceId, EagleEye.getTraceId());
//		request.addHeader(Constants.EagleEye._EagleEyeRpcId, EagleEye.getRpcId());
		return request;
	}

	/** @param rpcName
	 * @param status */
	public static void endRpc(String rpcName, String status) {
		EagleEye.attribute("rpcName", rpcName); // 设置RPC类型名
		EagleEye.rpcClientRecv(status, 91); // 标识客户端收到RPC请求响应，并设置状态码(00)和 RpcType(91)
	}

	public static void main(String[] args) {
		String traceId = EagleEye.generateTraceId(null);
		EagleEye.startTrace(traceId, "json_AAA");
		System.out.println(EagleEye.getTraceId());
		System.out.println(traceId);
	}

}
