/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.common.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.ohaotian.plugin.base.bo.RspPage;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private Logger logger = LoggerFactory.getLogger(ReturnValueHandler.class);

    public boolean supportsReturnType(MethodParameter returnType) {
        boolean hasJSONAnno = returnType.getMethodAnnotation(BusiResponseBody.class) != null || returnType.getMethodAnnotation(BusiResponseBody.class) != null;
        return hasJSONAnno;
    }

    public void handleReturnValue(Object obj, MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest) throws Exception {
        HashMap<String, Object> rsp = new HashMap<String, Object>();
        modelAndViewContainer.setRequestHandled(true);
        HttpServletResponse response = (HttpServletResponse)nativeWebRequest.getNativeResponse(HttpServletResponse.class);
        response.setContentType("application/json;charset=UTF-8");
        this.logger.info("\u8bf7\u6c42\u6210\u529f\uff0c\u8fd4\u56de\u6d88\u606f\u8f6c\u6362");
        try {
            if (obj instanceof RspPage) {
                rsp.put("data", obj);
                if (StringUtils.isNotEmpty((String)((RspPage)obj).getCode())) {
                    rsp.put("code", ((RspPage)obj).getCode());
                    rsp.put("message", ((RspPage)obj).getMessage());
                } else {
                    rsp.put("code", "0");
                    rsp.put("message", "\u6210\u529f");
                }
                this.returnMsg(rsp, response);
            } else if (obj instanceof RspBaseBO) {
                LinkedHashMap linkedHashMap = (LinkedHashMap)JSONObject.parseObject((String)this.objToJsonString(obj), LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
                JSONObject jsonObject = new JSONObject();
                jsonObject.putAll((Map)linkedHashMap);
                if (jsonObject.size() == 1) {
                    Set keySet = jsonObject.keySet();
                    for (String str : keySet) {
                        Object o = jsonObject.get((Object)str);
                        rsp.put("data", o);
                    }
                } else {
                    rsp.put("data", jsonObject);
                }
                if (StringUtils.isNotEmpty((String)((RspBaseBO)obj).getCode())) {
                    rsp.put("code", ((RspBaseBO)obj).getCode());
                    rsp.put("message", ((RspBaseBO)obj).getMessage());
                } else {
                    rsp.put("code", "0");
                    rsp.put("message", "\u6210\u529f");
                }
                this.returnMsg(rsp, response);
            } else {
                rsp.put("code", "0");
                rsp.put("message", "\u6210\u529f");
                if (obj != null) {
                    rsp.put("data", obj);
                }
                this.returnMsg(rsp, response);
            }
        }
        catch (Exception e) {
            this.logger.info("\u8f6c\u6362\u4fe1\u606f\u5931\u8d25\uff0c\u8fd4\u56de\u6d88\u606f\u8f6c\u6362");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnMsg(Object msg, HttpServletResponse response) {
        try (PrintWriter writer = null;){
            writer = response.getWriter();
            writer.write(this.objToJsonString(msg));
            writer.flush();
        }
    }

    private String objToJsonString(Object msg) {
        return JSON.toJSONString((Object)msg, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullBooleanAsFalse});
    }

    public static void main(String[] args) {
        Object obj = null;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)"0");
        jsonObject.put("message", (Object)"\u6210\u529f");
        if (JSONObject.parseObject((String)JSONObject.toJSONString(obj)) != null) {
            jsonObject.put("data", (Object)JSONObject.parseObject((String)JSONObject.toJSONString(obj)));
        }
        System.out.println(jsonObject);
    }
}

