/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.common.sm;

import com.ohaotian.plugin.common.sm.SM3Digest;
import java.math.BigInteger;
import org.bouncycastle.math.ec.ECPoint;

public class Cipher {
    private int ct = 1;
    private ECPoint p2;
    private SM3Digest sm3keybase;
    private SM3Digest sm3c3;
    private byte[] key = new byte[32];
    private byte keyOff = 0;

    private void Reset() {
        this.sm3keybase = new SM3Digest();
        this.sm3c3 = new SM3Digest();
        this.NextKey();
    }

    private void NextKey() {
        SM3Digest sm3keycur = new SM3Digest(this.sm3keybase);
        sm3keycur.update((byte)(this.ct >> 24 & 0xFF));
        sm3keycur.update((byte)(this.ct >> 16 & 0xFF));
        sm3keycur.update((byte)(this.ct >> 8 & 0xFF));
        sm3keycur.update((byte)(this.ct & 0xFF));
        sm3keycur.doFinal(this.key, 0);
        this.keyOff = 0;
        ++this.ct;
    }

    public void Encrypt(byte[] data) {
        this.sm3c3.update(data, 0, data.length);
        int i = 0;
        while (i < data.length) {
            if (this.keyOff == this.key.length) {
                this.NextKey();
            }
            int n = i++;
            byte by = this.keyOff;
            this.keyOff = (byte)(by + 1);
            data[n] = (byte)(data[n] ^ this.key[by]);
        }
    }

    public void Init_dec(BigInteger userD, ECPoint c1) {
        this.p2 = c1.multiply(userD);
        this.Reset();
    }

    public void Decrypt(byte[] data) {
        int i = 0;
        while (i < data.length) {
            if (this.keyOff == this.key.length) {
                this.NextKey();
            }
            int n = i++;
            byte by = this.keyOff;
            this.keyOff = (byte)(by + 1);
            data[n] = (byte)(data[n] ^ this.key[by]);
        }
        this.sm3c3.update(data, 0, data.length);
    }

    public void Dofinal(byte[] c3) {
        this.Reset();
    }
}

