/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.common.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsfConfigUtils {
    private static final Logger logger = LoggerFactory.getLogger(HsfConfigUtils.class);

    public static void createHsfProviderXml(String projectName, String tpath, Map<String, String> config, List<String> includeBeans, List<String> notIncludeBeans) {
        String basePath = System.getProperty("user.dir").replace("\\", "/");
        String targetPath = basePath + "/src/main/resources/spring";
        String[] paths = tpath.split("/");
        String providerFile = paths[paths.length - 1];
        providerFile = providerFile.replace("-service.xml", "-phsf.xml");
        String targetFile = targetPath + "/" + providerFile;
        List<HashMap<String, String>> beans = HsfConfigUtils.getBeans(tpath, includeBeans, notIncludeBeans);
        Document doc = DocumentHelper.createDocument();
        Element beanElement = doc.addElement("beans", "http://www.springframework.org/schema/beans");
        beanElement.addElement("description").setText("hsf\u670d\u52a1\u8c03\u7528\u8005");
        HsfConfigUtils.setNamespace(beanElement);
        HsfConfigUtils.setHsfProvider(beanElement, beans, projectName, config);
        HsfConfigUtils.writer(doc, targetFile);
    }

    public static void createHsfProviderXml(String projectName, List<String> tpathList, Map<String, String> config) {
        for (String tpath : tpathList) {
            HsfConfigUtils.createHsfProviderXml(projectName, tpath, config, null, null);
        }
    }

    public static void createHsfProviderXml(String projectName, List<String> tpathList, Map<String, String> config, List<String> includeBeans, List<String> notIncludeBeans) {
        for (String tpath : tpathList) {
            HsfConfigUtils.createHsfProviderXml(projectName, tpath, config, includeBeans, notIncludeBeans);
        }
    }

    public static void createHsfConsumerXml(String projectName, String tpath, Map<String, Object> config) {
        String basePath = System.getProperty("user.dir").replace("\\", "/");
        String targetPath = basePath + "/src/main/resources/spring";
        String[] paths = tpath.split("/");
        String consumerFile = paths[paths.length - 1];
        consumerFile = consumerFile.replace("-service.xml", "-chsf.xml");
        String targetFile = targetPath + "/" + consumerFile;
        List<HashMap<String, String>> beans = HsfConfigUtils.getBeans(tpath, null, null);
        Document doc = DocumentHelper.createDocument();
        Element beanElement = doc.addElement("beans", "http://www.springframework.org/schema/beans");
        beanElement.addElement("description").setText("hsf\u670d\u52a1\u8c03\u7528\u8005");
        HsfConfigUtils.setNamespace(beanElement);
        HsfConfigUtils.setHsfConsumer(beanElement, beans, projectName, config);
        HsfConfigUtils.writer(doc, targetFile);
    }

    public static void createHsfConsumerXml(String projectName, List<String> tpathList, Map<String, Object> config) {
        for (String tpath : tpathList) {
            HsfConfigUtils.createHsfConsumerXml(projectName, tpath, config);
        }
    }

    public static String getVPNIpAddress() {
        String ipAddress = null;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface item = enumeration.nextElement();
                if (!StringUtils.isNotBlank((CharSequence)item.getDisplayName()) || !item.getDisplayName().contains("VPN")) continue;
                for (InterfaceAddress address : item.getInterfaceAddresses()) {
                    if (!(address.getAddress() instanceof Inet4Address)) continue;
                    Inet4Address inet4Address = (Inet4Address)address.getAddress();
                    ipAddress = inet4Address.getHostAddress();
                    System.out.println(inet4Address.getHostAddress());
                }
            }
        }
        catch (IOException ex) {
            System.out.println("\u83b7\u53d6VPN IP\u5730\u5740\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5VPN\u662f\u5426\u5df2\u8fde\u63a5\uff01");
        }
        System.out.println(ipAddress);
        return ipAddress;
    }

    private static List<HashMap<String, String>> getBeans(String path, List<String> includeBeans, List<String> notIncludeBeans) {
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(new File(path));
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
        Element node = document.getRootElement();
        String description = node.element("description").getText();
        List list = node.elements("bean");
        ArrayList<HashMap<String, String>> retList = new ArrayList<HashMap<String, String>>();
        for (Element e : list) {
            HashMap<String, String> map = new HashMap<String, String>();
            String id = e.attributeValue("id");
            String className = null;
            try {
                className = e.attributeValue("class");
                Class<?> claz = Class.forName(className);
                className = claz.getInterfaces()[0].getName();
            }
            catch (Exception e1) {
                logger.error("\u751f\u6210hsf\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u63a5\u53e3" + className, (Object)e);
            }
            if (includeBeans != null) {
                if (!includeBeans.contains(id)) continue;
                map.put("id", id);
                map.put("class", className);
                retList.add(map);
                continue;
            }
            if (notIncludeBeans != null) {
                if (notIncludeBeans.contains(id)) continue;
                map.put("id", id);
                map.put("class", className);
                retList.add(map);
                continue;
            }
            map.put("id", id);
            map.put("class", className);
            retList.add(map);
        }
        return retList;
    }

    private static void setNamespace(Element beans) {
        beans.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        beans.addNamespace("context", "http://www.springframework.org/schema/context");
        beans.addNamespace("hsf", "http://www.taobao.com/hsf");
        beans.addAttribute("xsi:schemaLocation", "http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd http://www.springframework.org/schema/context http://www.springframework.org/schema/context/spring-context.xsd http://www.taobao.com/hsf  http://www.taobao.com/hsf/hsf.xsd ");
    }

    private static void setHsfConsumer(Element beans, List<HashMap<String, String>> beanList, String projectName, Map<String, Object> config) {
        for (HashMap<String, String> beanMap : beanList) {
            String id = beanMap.get("id");
            String className = beanMap.get("class");
            Element hsfBean = beans.addElement("hsf:consumer");
            hsfBean.addAttribute("id", id);
            hsfBean.addAttribute("interface", className);
            hsfBean.addAttribute("version", "${" + projectName.toUpperCase() + "_VERSION}");
            hsfBean.addAttribute("group", "${" + projectName.toUpperCase() + "_GROUP}");
            if (config.get(className + ".timeout") != null) {
                hsfBean.addAttribute("clientTimeout", (String)config.get(className + ".timeout"));
            } else {
                hsfBean.addAttribute("clientTimeout", "60000");
            }
            hsfBean.addAttribute("enableTXC", "true");
            hsfBean.addAttribute("serializeType", "hessian");
            String ip = (String)config.get("target");
            if (ip == null) continue;
            hsfBean.addAttribute("target", ip);
        }
    }

    private static void setHsfProvider(Element beans, List<HashMap<String, String>> beanList, String projectName, Map<String, String> config) {
        for (HashMap<String, String> beanMap : beanList) {
            String id = beanMap.get("id");
            String className = beanMap.get("class");
            Element hsfBean = beans.addElement("hsf:provider");
            hsfBean.addAttribute("id", id + "H");
            hsfBean.addAttribute("interface", className);
            hsfBean.addAttribute("ref", id);
            hsfBean.addAttribute("version", "${" + projectName.toUpperCase() + "_VERSION}");
            hsfBean.addAttribute("group", "${" + projectName.toUpperCase() + "_GROUP}");
            if (config.get(className + ".timeout") != null) {
                hsfBean.addAttribute("clientTimeout", config.get(className + ".timeout"));
            } else {
                hsfBean.addAttribute("clientTimeout", "60000");
            }
            hsfBean.addAttribute("enableTXC", "true");
            hsfBean.addAttribute("serializeType", "hessian");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writer(Document document, String newPath) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        File file = new File(newPath);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        XMLWriter writer = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            writer = new XMLWriter((Writer)outputStreamWriter, format);
            writer.write(document);
            writer.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

