package com.ohaotian.plugin.common.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.constant.BaseRspConstants;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 统一格式返回
 *
 * @author liubq
 */
public class ReturnValueHandler implements HandlerMethodReturnValueHandler {

    private Logger logger = LoggerFactory.getLogger(ReturnValueHandler.class);

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        boolean hasJSONAnno = returnType.getMethodAnnotation(BusiResponseBody.class) != null || returnType.getMethodAnnotation(BusiResponseBody.class) != null;
        return hasJSONAnno;
    }

    @Override
    public void handleReturnValue(Object obj, MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer,
                                  NativeWebRequest nativeWebRequest) throws Exception {
        Map<String, Object> rsp = new HashMap<>();
        modelAndViewContainer.setRequestHandled(true);
        HttpServletResponse response = nativeWebRequest.getNativeResponse(HttpServletResponse.class);
        response.setContentType(MediaType.APPLICATION_JSON_UTF8_VALUE);
        logger.info("请求成功，返回消息转换");

        try {
            //返回封装数据
            if (obj instanceof RspPage) {
                rsp.put("data", obj);
                if(StringUtils.isNotEmpty(((RspPage) obj).getCode())){
                    rsp.put("code", ((RspPage) obj).getCode());
                    rsp.put("message", ((RspPage) obj).getMessage());
                }else{
                    rsp.put("code", BaseRspConstants.CODE_SUCCESS);
                    rsp.put("message", BaseRspConstants.RSP_DESC_SUCCESS);
                }
                returnMsg(rsp, response);
            } else if (obj instanceof RspBaseBO) {

                JSONObject jsonObject = JSON.parseObject(objToJsonString(obj));

                if (jsonObject.size() == 1) {
                    Set<String> keySet = jsonObject.keySet();
                    for (String str : keySet) {
                        Object o = jsonObject.get(str);
                        rsp.put("data", o);
                    }
                } else {
                    rsp.put("data", jsonObject);

                }

                if(StringUtils.isNotEmpty(((RspBaseBO) obj).getCode())){
                    rsp.put("code", ((RspBaseBO) obj).getCode());
                    rsp.put("message", ((RspBaseBO) obj).getMessage());

                }else{
                    rsp.put("code", BaseRspConstants.CODE_SUCCESS);
                    rsp.put("message", BaseRspConstants.RSP_DESC_SUCCESS);
                }

                returnMsg(rsp, response);
            }else {
                rsp.put("code", BaseRspConstants.CODE_SUCCESS);
                rsp.put("message", BaseRspConstants.RSP_DESC_SUCCESS);
                if (obj != null ) {
                    rsp.put("data", obj);
                }
                returnMsg(rsp, response);
            }
        }
        catch (Exception e){
            logger.info("转换信息失败，返回消息转换");
        }
    }

    /**
     * 返回给前端信息
     *
     * @param msg
     * @param response
     */
    private void returnMsg(Object msg, HttpServletResponse response) {
        PrintWriter writer = null;
        try {
            response.setContentType("text/plain;charset=UTF-8");
            writer = response.getWriter();
            writer.write(objToJsonString(msg));
            writer.flush();
        } catch (IOException ex) {
            logger.error("统一格式返回", ex);
        } finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /**
     * 对象转json字符串
     *
     * @param msg
     * @return
     */
    private String objToJsonString(Object msg) {
        return JSON.toJSONString(msg, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullBooleanAsFalse);
    }

    public static void main(String[] args) {

        Object obj = null;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", BaseRspConstants.CODE_SUCCESS);
        jsonObject.put("message", BaseRspConstants.RSP_DESC_SUCCESS);
        if (JSONObject.parseObject(JSONObject.toJSONString(obj)) != null) {
            jsonObject.put("data", JSONObject.parseObject(JSONObject.toJSONString(obj)));
        }
        System.out.println(jsonObject);


    }

}