package com.ohaotian.plugin.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 描述: 字符串 时间 数字 格式转换帮助工具类<br>
 *
 * @author Shao Zhen Jun
 * @created 2018-04-28-14:50
 **/
public class DelFormatHelper {
    /** 获取时间 7 位 */
    private static final String                        sdf17_string                = "yyyyMMddHHmmssSSS";
    private static final ThreadLocal<SimpleDateFormat> threadLocalSdf17            = new ThreadLocal<SimpleDateFormat>();

    /** 获取时间 14 位 */
    private static final String                        sdf14_string                = "yyyyMMddHHmmss";
    private static final ThreadLocal<SimpleDateFormat> threadLocalSdf14            = new ThreadLocal<SimpleDateFormat>();

    /** 当前时间格式 */
    private static final String                        sdf_string                  = "yyyy-MM-dd HH:mm:ss";
    private static final ThreadLocal<SimpleDateFormat> threadLocalSdf              = new ThreadLocal<SimpleDateFormat>();

    /** 当前月份 */
    private static final String                        sdfYearMonth_string         = "yyyyMM";
    private static final ThreadLocal<SimpleDateFormat> threadLocalSdfYearMonth     = new ThreadLocal<SimpleDateFormat>();

    /** 当前年月日 */
    private static final String                        sdfYearMonthDay_string      = "yyyyMMdd";
    private static final ThreadLocal<SimpleDateFormat> threadLocalSdfYearMonthDay  = new ThreadLocal<SimpleDateFormat>();

    /** 当前年-月-日 */
    private static final String                        sdfYearMonthDay2_string     = "yyyy-MM-dd";
    private static final ThreadLocal<SimpleDateFormat> threadLocalSdfYearMonthDay2 = new ThreadLocal<SimpleDateFormat>();

    /** 当前年月日 时分 */
    private static final String                        sdfymdhm_string             = "yyyy-MM-dd HH:mm";
    private static final ThreadLocal<SimpleDateFormat> threadLocalSdfymdhmg        = new ThreadLocal<SimpleDateFormat>();

    /** <br>
     * 适用场景: 17位时间转换<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:40:37 */
    private static SimpleDateFormat getSdf17() {
        SimpleDateFormat sdf17 = threadLocalSdf17.get();
        if (sdf17 == null) {
            sdf17 = new SimpleDateFormat(sdf17_string);
            threadLocalSdf17.set(sdf17);
        }
        return sdf17;
    }

    /** <br>
     * 适用场景: 14位时间转换<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:40:50 */
    private static SimpleDateFormat getSdf14() {
        SimpleDateFormat sdf14 = threadLocalSdf14.get();
        if (sdf14 == null) {
            sdf14 = new SimpleDateFormat(sdf14_string);
            threadLocalSdf14.set(sdf14);
        }
        return sdf14;
    }

    /** <br>
     * 适用场景: 获取当前时间<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:41:00 */
    private static SimpleDateFormat getDateSdf() {
        SimpleDateFormat sdf = threadLocalSdfYearMonthDay2.get();
        if (sdf == null) {
            sdf = new SimpleDateFormat(sdfYearMonthDay2_string);
            threadLocalSdfYearMonthDay2.set(sdf);
        }
        return sdf;
    }

    /** <br>
     * 适用场景: 获取当前时间<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:41:00 */
    private static SimpleDateFormat getSdf() {
        SimpleDateFormat sdf = threadLocalSdf.get();
        if (sdf == null) {
            sdf = new SimpleDateFormat(sdf_string);
            threadLocalSdf.set(sdf);
        }
        return sdf;
    }

    /** <br>
     * 适用场景:获取当前月份SimpleDateFormat <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:41:09 */
    private static SimpleDateFormat getSdfYearMonth() {
        SimpleDateFormat sdfYearMonth = threadLocalSdfYearMonth.get();
        if (sdfYearMonth == null) {
            sdfYearMonth = new SimpleDateFormat(sdfYearMonth_string);
            threadLocalSdfYearMonth.set(sdfYearMonth);
        }
        return sdfYearMonth;
    }

    /** <br>
     * 适用场景:获取当前年月日SimpleDateFormat <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:41:24 */
    private static SimpleDateFormat getSdfymdhmDay() {
        SimpleDateFormat sdfymdhmDay = threadLocalSdfymdhmg.get();
        if (sdfymdhmDay == null) {
            sdfymdhmDay = new SimpleDateFormat(sdfymdhm_string);
            threadLocalSdfymdhmg.set(sdfymdhmDay);
        }
        return sdfymdhmDay;
    }

    /** <br>
     * 适用场景:获取当前年月日SimpleDateFormat <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:41:24 */
    private static SimpleDateFormat getSdfYearMonthDay() {
        SimpleDateFormat sdfYearMonthDay = threadLocalSdfYearMonthDay.get();
        if (sdfYearMonthDay == null) {
            sdfYearMonthDay = new SimpleDateFormat(sdfYearMonthDay_string);
            threadLocalSdfYearMonthDay.set(sdfYearMonthDay);
        }
        return sdfYearMonthDay;
    }

    /** <br>
     * 适用场景: 获取当前时间前 14 位<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:41:39 */
    public static String getDateStringFor14Nums() {
        return getSdf14().format(new Date(System.currentTimeMillis()));
    }

    /** <br>
     * 适用场景:获取当前时间 字符串格式 YYYY-MM-dd HH:mm:ss <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:41:58 */
    public static String getNowTimeForString() {
        return getSdf().format(new Date(System.currentTimeMillis()));
    }

    /** <br>
     * 适用场景:String字符串格式 YYYY-MM-dd HH:mm:ss转字符串格式yyyyMMddHHmmss <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @throws ParseException
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:41:58 */
    public static String getNowTimeForString(String dateStr) throws ParseException {
        return getSdf14().format(getSdf().parse(dateStr));
    }

    /** <br>
     * 适用场景: YYYY-MM-dd HH:mm:ss 格式时间字符串转换为 Date<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param dateStr
     * @return
     * @throws ParseException
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:42:11 */
    public static Date fromSdfToDate(String dateStr) throws ParseException {
        return getSdf().parse(dateStr);
    }

    public static Date strToDate(String dateStr) throws ParseException {
        return getDateSdf().parse(dateStr);
    }

    /***
     * 适用场景:YYYY-MM-dd HH:mm 格式时间字符串转换为 Date<br>
     * @param dateStr
     * @return
     * @throws ParseException
     */
    public static Date fromStrymdhmToDate(String dateStr) throws ParseException {
        return getSdfymdhmDay().parse(dateStr);
    }

    /** <br>
     * 适用场景:YYYYMMddHHmmssSSS 格式的时间字符串转换为 Date <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param dateStr
     * @return
     * @throws ParseException
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:42:24 */
    public static Date fromSdf17ToDate(String dateStr) throws ParseException {
        return getSdf17().parse(dateStr);
    }

    /** <br>
     * 适用场景:YYYYMMddHHmmss 格式的时间字符串转换为 Date <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param dateStr
     * @return
     * @throws ParseException
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:42:24 */
    public static Date fromSdf14ToDate(String dateStr) throws ParseException {
        return getSdf14().parse(dateStr);
    }

    /** <br>
     * 适用场景:Date 转换为 YYYYMMddHHmmssSSS 格式的时间字符串 <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param date
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:42:35 */
    public static String fromDateToSdf17(Date date) {
        return getSdf17().format(date);
    }

    /** <br>
     * 适用场景:当前月份[YYYYMM] Integer 类型 <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:42:47 */
    public static Integer getNowYearAndMonth() {
        return Integer.parseInt(getSdfYearMonth().format(new Date(System.currentTimeMillis())));
    }

    /** <br>
     * 适用场景: 当前月份[YYYYMMdd]<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:42:58 */
    public static String getNowYearAndMonthDayString() {
        return getSdfYearMonthDay().format(new Date(System.currentTimeMillis()));
    }

    /** <br>
     * 适用场景:获取当前时间前6个月的时间 <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:43:07 */
    public static Integer[] getOldSexMonthBefNow() {
        Integer[] months = new Integer[6];
        SimpleDateFormat format = getSdfYearMonth();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(System.currentTimeMillis()));
        for (int i = 1; i < 7; i++) {
            calendar.add(Calendar.MONTH, -1);
            Date month = calendar.getTime();
            months[i - 1] = Integer.parseInt(format.format(month));
        }
        return months;
    }

    /** <br>
     * 适用场景: 获取当前日期的前一天 暂时不做性能优化，考虑到只有定时任务使用。频率较低<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:44:05 */
    public static String getYesterdayYearMonthDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(System.currentTimeMillis()));
        calendar.add(Calendar.DAY_OF_MONTH, -1);
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return sdf.format(date);
    }

    /** <br>
     * 适用场景:获取当前日期的前一天 <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:43:56 */
    public static String getForworday() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(System.currentTimeMillis()));
        calendar.add(Calendar.DAY_OF_MONTH, -1);
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
        return sdf.format(date);
    }

    // 获取当前年月日SimpleDateFormat
    private static SimpleDateFormat getSdfYmdhm() {
        SimpleDateFormat sdfYearMonthDay = threadLocalSdfymdhmg.get();
        if (sdfYearMonthDay == null) {
            sdfYearMonthDay = new SimpleDateFormat(sdfymdhm_string);
            threadLocalSdfymdhmg.set(sdfYearMonthDay);
        }
        return sdfYearMonthDay;
    }

    /** <br>
     * 适用场景: 当前年月日时分<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:43:27 */
    public static String getNowYearMothDayHourMin() {
        return getSdfYmdhm().format(new Date(System.currentTimeMillis()));
    }

    /** <br>
     * 适用场景: 获取当前月份 Date<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:43:38 */
    public static String getNowYearAndMonthString() {
        return getSdfYearMonth().format(new Date(System.currentTimeMillis()));
    }

    /** <br>
     * 适用场景:获取当前年-月-日SimpleDateFormat <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:41:24 */
    private static SimpleDateFormat getSdfYearMonthDay2() {
        SimpleDateFormat sdfYearMonthDay = threadLocalSdfYearMonthDay2.get();
        if (sdfYearMonthDay == null) {
            sdfYearMonthDay = new SimpleDateFormat(sdfYearMonthDay2_string);
            threadLocalSdfYearMonthDay2.set(sdfYearMonthDay);
        }
        return sdfYearMonthDay;
    }

    /** <br>
     * 适用场景: 当前月份[YYYY-MM-dd]<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @throws ParseException
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午10:42:58 */
    public static Date getNowYearAndMonthDay() throws ParseException {
        String dateStr = getSdfYearMonthDay().format(new Date(System.currentTimeMillis()));
        return getSdfYearMonthDay().parse(dateStr);
    }

    /** <br>
     * 适用场景: 将时间字符串转Date<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param dateStr
     * @return
     * @throws ParseException
     * @autho QIJIANFEI
     * @time 2017年7月29日 上午11:01:13 */
    public static Date getNowYearAndMonthDay(String dateStr) throws ParseException {
        return getSdfYearMonthDay().parse(dateStr);
    }

    /** <br>
     * 适用场景: 将时间整数转Date<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param currentTime
     * @return
     * @autho QIJIANFEI
     * @time 2017年8月2日 下午8:16:28 */
    public static Date longToDate(long currentTime) {
        Date date = new Date(currentTime);
        return date;
    }

    /** <br>
     * 适用场景:Date 转换为 yyyy-MM-dd HH:mm:ss 格式的时间字符串 <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param date
     * @return
     * @autho YW
     * @time 2017年9月09日 上午23:42:35 */
    public static String fromDateToSdf(Date date) {
        return getSdf().format(date);
    }

    /** <br>
     * 适用场景:Date 转换为 yyyy-MM-dd 格式的时间字符串 <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param date
     * @return
     * @autho zpp
     * @time 2018年4月04日  */
    public static String fromDateToStr(Date date) {
        return getDateSdf().format(date);
    }
}
