package com.ohaotian.plugin.common.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Inet4Address;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
/** <br>
 * 标题: mq配置文件维护<br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 *
 * @autho liuce
 * @time 2016年8月26日 下午4:32:17 */
@SuppressWarnings("unchecked")
public class HsfConfigUtils {

	private static final Logger logger = LoggerFactory.getLogger(HsfConfigUtils.class);


	public static void createHsfProviderXml(String projectName,String tpath,Map<String,String> config,List<String> includeBeans,List<String> notIncludeBeans) {
		String basePath = System.getProperty("user.dir").replace("\\", "/");
		String targetPath = basePath + "/src/main/resources/spring";

		// 获取文件名
		String[] paths = tpath.split("/");
		String providerFile = paths[paths.length-1];
		providerFile = providerFile.replace("-service.xml", "-phsf.xml");
		String targetFile = targetPath + "/" + providerFile;
		// 获取bean对象
		List<HashMap<String, String>> beans = getBeans(tpath,includeBeans,notIncludeBeans);

		// 生成bean
		// 创建chsf的xml文件
		Document doc = DocumentHelper.createDocument();
		Element beanElement = doc.addElement("beans", "http://www.springframework.org/schema/beans");
		beanElement.addElement("description").setText("hsf服务调用者");
		// 生产xml报文头
		setNamespace(beanElement);

		setHsfProvider(beanElement,beans, projectName, config);
		// 生产文件
		writer(doc, targetFile);

	}

	public static void createHsfProviderXml(String projectName,List<String> tpathList,Map<String,String> config) {
		for(String tpath:tpathList){
			createHsfProviderXml(projectName,tpath,config,null,null);
		}
	}

	public static void createHsfProviderXml(String projectName,List<String> tpathList,Map<String,String> config,List<String> includeBeans,List<String> notIncludeBeans) {
		for(String tpath:tpathList){
			createHsfProviderXml(projectName,tpath,config,includeBeans,notIncludeBeans);
		}
	}


	public static void createHsfConsumerXml(String projectName,String tpath,Map<String,Object> config) {
		String basePath = System.getProperty("user.dir").replace("\\", "/");
		String targetPath = basePath + "/src/main/resources/spring";

		// 获取文件名
		String[] paths = tpath.split("/");
		String consumerFile = paths[paths.length-1];
		consumerFile = consumerFile.replace("-service.xml", "-chsf.xml");
		String targetFile = targetPath + "/" + consumerFile;
		// 获取bean对象,hsf consumer 使用权利HSF配置文件
		List<HashMap<String, String>> beans = getBeans(tpath,null,null);

		// 生成bean
		// 创建chsf的xml文件
		Document doc = DocumentHelper.createDocument();
		Element beanElement = doc.addElement("beans", "http://www.springframework.org/schema/beans");
		beanElement.addElement("description").setText("hsf服务调用者");
		// 生产xml报文头
		setNamespace(beanElement);

		setHsfConsumer(beanElement,beans, projectName, config);
		// 生产文件
		writer(doc, targetFile);

	}

	public static void createHsfConsumerXml(String projectName,List<String> tpathList,Map<String,Object> config) {
		for(String tpath:tpathList){
			createHsfConsumerXml(projectName,tpath,config);
		}
	}

	public static String getVPNIpAddress() {
		String ipAddress = null;
		try {
			for (Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces(); enumeration.hasMoreElements();) {
				NetworkInterface item = enumeration.nextElement();
				// System.out.println("item.getDisplayName() = "+item.getDisplayName());
				if (StringUtils.isNotBlank(item.getDisplayName()) && item.getDisplayName().contains("VPN")) {
					for (InterfaceAddress address : item.getInterfaceAddresses()) {
						if (address.getAddress() instanceof Inet4Address) {
							Inet4Address inet4Address = (Inet4Address) address.getAddress();
							ipAddress = inet4Address.getHostAddress();
							System.out.println(inet4Address.getHostAddress());
						}
					}
				}
			}
		} catch (IOException ex) {
			System.out.println("获取VPN IP地址异常，请检查VPN是否已连接！");
		}
		System.out.println(ipAddress);
		return ipAddress;
	}


	/**
	 * 根据服务路径生产相应的获取相应的bean信息
	 * @param path
	 * @return
	 */
	private static List<HashMap<String, String>> getBeans(String path,List<String> includeBeans,List<String> notIncludeBeans) {
		// 创建saxReader对象
		SAXReader reader = new SAXReader();
		// 通过read方法读取一个文件 转换成Document对象
		Document document = null;
		try {
			document = reader.read(new File(path));
		} catch (DocumentException e2) {
		}
		// 获取根节点元素对象
		Element node = document.getRootElement();

		String description = node.element("description").getText();
		// 获取service中的所有的bean
		List<Element> list = node.elements("bean");
		List<HashMap<String, String>> retList = new ArrayList<HashMap<String,String>>();
		for (Element e : list) {
			HashMap<String, String> map = new HashMap<String, String>();
			String id = e.attributeValue("id");
			String className = null;
			try {
				className = e.attributeValue("class");
				Class<?> claz = Class.forName(className);
				className = claz.getInterfaces()[0].getName();
			}
			catch (Exception e1) {
				logger.error("生成hsf配置错误，请检查接口" + className, e);
			}
			if(includeBeans != null){
				if(includeBeans.contains(id)){
					map.put("id", id);
					map.put("class", className);
					retList.add(map);
				}
			} else if (notIncludeBeans != null){
				if(!notIncludeBeans.contains(id)){
					map.put("id", id);
					map.put("class", className);
					retList.add(map);
				}
			} else {
				map.put("id", id);
				map.put("class", className);
				retList.add(map);
			}
		}
		return retList;
	}

	/** 添加namespace <br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 *
	 * @param beans
	 * @autho liuce
	 * @time 2016年8月27日 下午4:33:51 */
	private static void setNamespace(Element beans) {
		beans.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
		beans.addNamespace("context", "http://www.springframework.org/schema/context");
		beans.addNamespace("hsf", "http://www.taobao.com/hsf");
		beans.addAttribute(
				"xsi:schemaLocation",
				"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd http://www.springframework.org/schema/context http://www.springframework.org/schema/context/spring-context.xsd http://www.taobao.com/hsf  http://www.taobao.com/hsf/hsf.xsd ");
	}

	/** 添加hsf消费端配置 <br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * @param beans
	 * @param id
	 * @param className
	 * @param projectName
	 * @autho liuce
	 * @time 2016年8月27日 下午4:34:04 */
	private static void setHsfConsumer(Element beans, List<HashMap<String, String>> beanList, String projectName, Map<String,Object> config) {
		for (HashMap<String, String> beanMap : beanList){
			String id = beanMap.get("id");
			String className = beanMap.get("class");
			Element hsfBean = beans.addElement("hsf:consumer");
			hsfBean.addAttribute("id", id);
			hsfBean.addAttribute("interface", className);
			hsfBean.addAttribute("version", "${" + projectName.toUpperCase() + "_VERSION}");
			hsfBean.addAttribute("group", "${" + projectName.toUpperCase() + "_GROUP}");
			if (config.get(className + ".timeout") != null) {
				hsfBean.addAttribute("clientTimeout", (String)config.get(className + ".timeout") );
			}
			else {
				hsfBean.addAttribute("clientTimeout", "60000");
			}
			hsfBean.addAttribute("enableTXC", "true");
			hsfBean.addAttribute("serializeType", "hessian");
			String ip = (String)config.get("target");
			if(ip != null){
				hsfBean.addAttribute("target", ip);
			}
		}
	}

	/** 添加hsf提供者配置 <br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 *
	 * @param beans
	 * @param id
	 * @param className
	 * @param projectName
	 * @autho lixin
	 * @time 2016年8月27日 下午4:34:22 */
	private static void setHsfProvider(Element beans, List<HashMap<String, String>> beanList, String projectName, Map<String,String> config) {

		for (HashMap<String, String> beanMap : beanList){
			String id = beanMap.get("id");
			String className = beanMap.get("class");
			Element hsfBean = beans.addElement("hsf:provider");
			hsfBean.addAttribute("id", id + "H");
			hsfBean.addAttribute("interface", className);
			hsfBean.addAttribute("ref", id);
			hsfBean.addAttribute("version", "${" + projectName.toUpperCase() + "_VERSION}");
			hsfBean.addAttribute("group", "${" + projectName.toUpperCase() + "_GROUP}");
			if (config.get(className + ".timeout") != null) {
				hsfBean.addAttribute("clientTimeout", config.get(className + ".timeout"));
			}
			else {
				hsfBean.addAttribute("clientTimeout", "60000");
			}
			hsfBean.addAttribute("enableTXC", "true");
			hsfBean.addAttribute("serializeType", "hessian");

		}

	}


	/** 把document对象写入新的文件
	 *
	 * @param document
	 * @throws Exception */
	private static void writer(Document document, String newPath){

		// 排版缩进的格式
		OutputFormat format = OutputFormat.createPrettyPrint();
		// 设置编码
		format.setEncoding("UTF-8");

		File file = new File(newPath);

		if(file.exists()){
			file.delete();
		}

		FileOutputStream fileOutputStream = null;

		OutputStreamWriter outputStreamWriter = null;

		XMLWriter writer = null;

		try {
			fileOutputStream = new FileOutputStream(file);

			outputStreamWriter = new OutputStreamWriter(fileOutputStream, "UTF-8");

			writer = new XMLWriter(outputStreamWriter, format);
			// 写入
			writer.write(document);
			// 立即写入
			writer.flush();

		} catch (IOException e) {
		} finally {
			try {
				if(fileOutputStream != null) fileOutputStream.close();
				if(outputStreamWriter != null) outputStreamWriter.close();
				if(writer != null) writer.close();
			} catch (IOException e) {
			}
		}
	}
}
