package com.ohaotian.plugin.common.util;

import java.math.BigDecimal;

/** <br>
 * 标题:金额转换，BigDecimal转Long，Long转BigDecimal <br>
 * 描述: 数据库中使用BigInt存储金额，单位：毫厘；前台显示单位：元，需要乘10000<br>
 * 公司: www.tydic.com<br>
 * 
 * @autho Shao Zhenjun
 * @time 2017年8月25日 下午3:03:42 */
public class MoneyUtils {

	/** <br>
	 * 适用场景:前台金额(保留两位小数)传到后台需要存库，如单品价格 <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * amount*10000,取整<br>
	 * 
	 * @param amount
	 * @return
	 * @throws Exception
	 * @autho Shao Zhenjun
	 * @time 2017年8月25日 下午3:22:32 */
	public static Long BigDecimal2Long(BigDecimal amount) throws Exception {

		if (amount != null) {
			try {
				BigDecimal bd = new BigDecimal("10000");
				BigDecimal retValue = amount.multiply(bd);
				return retValue.longValue();
			}
			catch (Exception e) {
				throw new Exception("BigDecimal2Long数据转换错误: " + e);
			}
		}

		return null;
	}
	
	/**
	 * 
	 * <br>
	 * 适用场景:转换类型，不乘10000<br>
	 * 调用方式:	<br>
	 * 业务逻辑说明<br>
	 *
	 * @param amount
	 * @return
	 * @throws Exception
	 * @autho Zay
	 * @time 2017年10月9日 下午3:32:34
	 */
	public static Long BigDecimalToLong(BigDecimal amount) throws Exception {

		if (amount != null) {
			try {
				BigDecimal bd = new BigDecimal("1");
				BigDecimal retValue = amount.multiply(bd);
				return retValue.longValue();
			}
			catch (Exception e) {
				throw new Exception("BigDecimal2Long数据转换错误: " + e);
			}
		}

		return null;
	}

	/** <br>
	 * 适用场景:后台金额(单位毫厘)传到前台元，如单品价格 <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * amount/10000,保留2两位小数<br>
	 * 
	 * @param amount
	 * @return
	 * @throws Exception
	 * @autho Shao Zhenjun
	 * @time 2017年8月25日 下午3:22:32 */
	public static BigDecimal Long2BigDecimal(Long amount) throws Exception {

		if (amount != null) {
			try {
				BigDecimal bd = new BigDecimal("10000");
				BigDecimal bAmount = new BigDecimal(amount);
				return bAmount.divide(bd, 2, BigDecimal.ROUND_DOWN);
			}
			catch (Exception e) {
				throw new Exception("Long2BigDecimal数据转换错误: " + e);
			}
		}

		return null;
	}

	/** <br>
	 * 适用场景: 将double类型保留两位小数并转为BigDecimal<br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param amount
	 * @return
	 * @throws Exception
	 * @autho QIJIANFEI
	 * @time 2017年9月13日 下午2:39:21 */
	public static BigDecimal Double2BigDecimal(Double amount) throws Exception {

		if (amount != null) {
			try {
				BigDecimal bAmount = new BigDecimal(amount);
				return bAmount.setScale(2, BigDecimal.ROUND_HALF_UP);
			}
			catch (Exception e) {
				throw new Exception("Double2BigDecimal数据转换错误: " + e);
			}
		}

		return null;
	}
}
