package com.ohaotian.plugin.common.util;

import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;

/**
 * 正则相关工具类
 *
 */
public class RegUtils {

	/**
	 * 判断字符串是否符合输入的规则
	 * @param str
	 * @param reg
	 * @return
	 */
	public static boolean isValidityByReg(String str,String reg){

		if(StringUtils.isBlank(str)){

			return false;
		}

		return Pattern.compile(reg).matcher(str).find();
	}

	/**
	 * 通配符算法。 可以匹配"*"和"?"
	 * 如a*b?d可以匹配aAAAbcd
	 * @param pattern 匹配表达式
	 * @param str 匹配的字符串
	 * @return
	 */
	public static boolean match(String pattern, String str) {
		if (pattern == null || str == null)
			return false;

		boolean result = false;
		char c; // 当前要匹配的字符串
		boolean beforeStar = false; // 是否遇到通配符*
		int back_i = 0;// 回溯,当遇到通配符时,匹配不成功则回溯
		int back_j = 0;
		int i, j;
		for (i = 0, j = 0; i < str.length(); ) {
			if (pattern.length() <= j) {
				if (back_i != 0) { // 有通配符,但是匹配未成功,回溯
					beforeStar = true;
					i = back_i;
					j = back_j;
					back_i = 0;
					back_j = 0;
					continue;
				}
				break;
			}

			if ((c = pattern.charAt(j)) == '*') {
				if (j == pattern.length() - 1) { // 通配符已经在末尾,返回true
					result = true;
					break;
				}
				beforeStar = true;
				j++;
				continue;
			}

			if (beforeStar) {
				if (str.charAt(i) == c) {
					beforeStar = false;
					back_i = i + 1;
					back_j = j;
					j++;
				}
			} else {
				if (c != '?' && c != str.charAt(i)) {
					result = false;
					if (back_i != 0) { // 有通配符,但是匹配未成功,回溯
						beforeStar = true;
						i = back_i;
						j = back_j;
						back_i = 0;
						back_j = 0;
						continue;
					}
					break;
				}
				j++;
			}
			i++;
		}

		if (i == str.length() && j == pattern.length())// 全部遍历完毕
			result = true;
		return result;
	}

	public static void main(String[] args) {
		System.out.println(isValidityByReg("1ww","^\\d+$"));
	}
}