/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.common.util;

import com.ohaotian.plugin.common.sm.SM4Utils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HanyuPinyinHelper {
    private static Logger ALLATORIxDEMO = LoggerFactory.getLogger(HanyuPinyinHelper.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toHanyuPinyin(String a) {
        a = ((String)a).trim().toCharArray();
        String string = "";
        HanyuPinyinOutputFormat hanyuPinyinOutputFormat = new HanyuPinyinOutputFormat();
        hanyuPinyinOutputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        hanyuPinyinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        hanyuPinyinOutputFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        try {
            for (int i = 0; i < ((Object)a).length; ++i) {
                string = String.valueOf((char)a[i]).matches(MoneyUtils.ALLATORIxDEMO("|\u4e71\n\u9fd4zZ")) ? new StringBuilder().insert(0, string).append(PinyinHelper.toHanyuPinyinStringArray((char)a[i], (HanyuPinyinOutputFormat)hanyuPinyinOutputFormat)[0]).toString() : new StringBuilder().insert(0, string).append((char)a[i]).toString();
            }
            return string;
        }
        catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
            ALLATORIxDEMO.error(SM4Utils.ALLATORIxDEMO("\u5b1f\u7b30\u4e45\u80eb\u8f24\u6206\u6c01\u8bfb\u62b4\u97e5"), (Throwable)badHanyuPinyinOutputFormatCombination);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPinyinString(String a) {
        char[] cArray = a.trim().toCharArray();
        String string = "";
        HanyuPinyinOutputFormat hanyuPinyinOutputFormat = new HanyuPinyinOutputFormat();
        hanyuPinyinOutputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        hanyuPinyinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        try {
            for (int i = 0; i < cArray.length; ++i) {
                String string2 = String.valueOf(cArray[i]);
                if (string2.matches(MoneyUtils.ALLATORIxDEMO("|\u4e71\n\u9fd4zZ"))) {
                    string = new StringBuilder().insert(0, string).append(PinyinHelper.toHanyuPinyinStringArray((char)cArray[i], (HanyuPinyinOutputFormat)hanyuPinyinOutputFormat)[0]).toString();
                    continue;
                }
                if (string2.matches(SM4Utils.ALLATORIxDEMO("\u0013&e/\u0015="))) {
                    string = new StringBuilder().insert(0, string).append(cArray[i]).toString();
                    continue;
                }
                if (!string2.matches(MoneyUtils.ALLATORIxDEMO("*F\\]0\n+zZ"))) continue;
                string = new StringBuilder().insert(0, string).append(cArray[i]).toString();
            }
            return string;
        }
        catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
            ALLATORIxDEMO.error(SM4Utils.ALLATORIxDEMO("\u5b1f\u7b30\u4e45\u80eb\u8f24\u6206\u6c01\u8bfb\u62b4\u97e5"), (Throwable)badHanyuPinyinOutputFormatCombination);
        }
        return string;
    }

    public HanyuPinyinHelper() {
        HanyuPinyinHelper a;
    }

    public static String getFirstLettersUp(String a) {
        return HanyuPinyinHelper.getFirstLetters(a, HanyuPinyinCaseType.UPPERCASE);
    }

    public static String getFirstLettersLo(String a) {
        return HanyuPinyinHelper.getFirstLetters(a, HanyuPinyinCaseType.LOWERCASE);
    }

    public static String getFirstSpell(String a) {
        int n;
        HanyuPinyinOutputFormat hanyuPinyinOutputFormat;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = a.toCharArray();
        HanyuPinyinOutputFormat hanyuPinyinOutputFormat2 = hanyuPinyinOutputFormat = new HanyuPinyinOutputFormat();
        hanyuPinyinOutputFormat2.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        hanyuPinyinOutputFormat2.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        int n2 = n = 0;
        while (n2 < cArray.length) {
            if (cArray[n] > '\u0080') {
                try {
                    String[] stringArray = PinyinHelper.toHanyuPinyinStringArray((char)cArray[n], (HanyuPinyinOutputFormat)hanyuPinyinOutputFormat);
                    if (stringArray != null) {
                        stringBuffer.append(stringArray[0].charAt(0));
                    }
                }
                catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
                    badHanyuPinyinOutputFormatCombination.printStackTrace();
                }
            } else {
                stringBuffer.append(cArray[n]);
            }
            n2 = ++n;
        }
        return stringBuffer.toString().replaceAll(MoneyUtils.ALLATORIxDEMO("{&"), "").trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFirstLetters(String a, HanyuPinyinCaseType a22) {
        char[] cArray = a.trim().toCharArray();
        String string = "";
        HanyuPinyinOutputFormat hanyuPinyinOutputFormat = new HanyuPinyinOutputFormat();
        hanyuPinyinOutputFormat.setCaseType(a22);
        hanyuPinyinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        try {
            for (int a22 = 0; a22 < cArray.length; ++a22) {
                StringBuilder stringBuilder;
                String string2 = String.valueOf(cArray[a22]);
                if (string2.matches(MoneyUtils.ALLATORIxDEMO("|\u4e71\n\u9fd4zZ"))) {
                    string = new StringBuilder().insert(0, string).append(PinyinHelper.toHanyuPinyinStringArray((char)cArray[a22], (HanyuPinyinOutputFormat)hanyuPinyinOutputFormat)[0].substring(0, 1)).toString();
                    continue;
                }
                if (string2.matches(SM4Utils.ALLATORIxDEMO("\u0013&e/\u0015="))) {
                    string = new StringBuilder().insert(0, string).append(cArray[a22]).toString();
                    continue;
                }
                if (string2.matches(MoneyUtils.ALLATORIxDEMO("*F\\]0\n+zZ"))) {
                    stringBuilder = new StringBuilder();
                    string = stringBuilder.insert(0, string).append(cArray[a22]).toString();
                    continue;
                }
                stringBuilder = new StringBuilder();
                string = stringBuilder.insert(0, string).append(cArray[a22]).toString();
            }
            return string;
        }
        catch (BadHanyuPinyinOutputFormatCombination a22) {
            ALLATORIxDEMO.error(SM4Utils.ALLATORIxDEMO("\u5b1f\u7b30\u4e45\u80eb\u8f24\u6206\u6c01\u8bfb\u62b4\u97e5"), (Throwable)a22);
        }
        return string;
    }
}

