/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.common.util;

import com.ohaotian.plugin.common.util.FSTSerializer;
import com.ohaotian.plugin.common.util.Serializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationUtils {
    private static Serializer l;
    private static final Logger ALLATORIxDEMO;

    public static Object deserialize(Object a) throws IOException {
        if (a == null) {
            return null;
        }
        return l.deserialize(SerializationUtils.toByteArray(a));
    }

    static {
        ALLATORIxDEMO = LoggerFactory.getLogger(SerializationUtils.class);
        l = new FSTSerializer();
    }

    public static byte[] serializeWithoutException(Object a) {
        try {
            return SerializationUtils.serialize(a);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public static byte[] serialize(Object a) throws IOException {
        if (a == null) {
            return null;
        }
        return l.serialize(a);
    }

    public static byte[] serializeSlightly(Object a) {
        try {
            return SerializationUtils.serialize(a);
        }
        catch (IOException iOException) {
            ALLATORIxDEMO.error(iOException.getMessage(), (Throwable)iOException);
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public static byte[] toByteArray(Object a) {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream;
            ObjectOutputStream objectOutputStream2 = objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream2.writeObject(a);
            objectOutputStream2.flush();
            byArray = byteArrayOutputStream.toByteArray();
            objectOutputStream2.close();
            byteArrayOutputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return byArray;
        }
    }

    public static Object deserializeSlightly(byte[] a) {
        if (a == null || a.length == 0) {
            return null;
        }
        try {
            return l.deserialize(a);
        }
        catch (IOException iOException) {
            ALLATORIxDEMO.error(iOException.getMessage(), (Throwable)iOException);
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public static Object deserialize(byte[] a) throws IOException {
        if (a == null || a.length == 0) {
            return null;
        }
        return l.deserialize(a);
    }

    public SerializationUtils() {
        SerializationUtils a;
    }
}

