package com.ohaotian.plugin.common.util;

import org.apache.commons.lang3.StringUtils;

/** <br>
 * 标题: 员工工号工具<br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 * 
 * @autho liuce
 * @time 2016年11月21日 下午9:27:14 */
public class StaffUtils {

	public static final String CONNECTION_SYMBO = "_";

	/** 用分隔符连接省份和员工工号<br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param provinceCode
	 * @param staffId
	 * @return
	 * @autho liuce
	 * @time 2016年11月21日 下午9:30:14 */
	public static String getOldStaffId(String provinceCode, String staffId) {
		if (StringUtils.isBlank(provinceCode) || StringUtils.isBlank(staffId)) {
			return null;
		}
		return provinceCode + CONNECTION_SYMBO + staffId;
	}

	/** 获取去掉省份编码的工号<br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param staffId
	 * @return
	 * @autho liuce
	 * @time 2016年11月21日 下午11:54:06 */
	public static String splitStaffId(String staffId) {
		if (StringUtils.isBlank(staffId)) {
			return null;
		}
		String[] strs = staffId.split(CONNECTION_SYMBO);
		if (strs.length == 2 && strs[0].length() == 2) {
			return strs[1];
		}
		else {
			return staffId;
		}
	}

}
