package com.ohaotian.plugin.common.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

/**
 * 对象序列化工具包
 *
 * @author Winter Lau(javayou@gmail.com)
 */
public class SerializationUtils {

    private final static Logger logger = LoggerFactory.getLogger(SerializationUtils.class);

    private static Serializer g_serializer = new FSTSerializer();

    /**
     * 针对不同类型做单独处理
     *
     * @param obj 待序列化的对象
     * @return 返回序列化后的字节数组
     * @throws IOException io exception
     */
    public static byte[] serialize(Object obj) throws IOException {
        if (obj == null)
            return null;
        return g_serializer.serialize(obj);
    }

    public static byte[] serializeWithoutException(Object obj) {
        try {
            return serialize(obj);
        } catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public static byte[] serializeSlightly(Object obj) {
        try {
            return serialize(obj);
        } catch (IOException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        }
    }

    /**
     * 反序列化
     *
     * @param bytes 待反序列化的字节数组
     * @return 序列化后的对象
     * @throws IOException io exception
     */
    public static Object deserialize(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length == 0)
            return null;
        return g_serializer.deserialize(bytes);
    }

    /**
     * 反序列化
     *
     * @param bytes 待反序列化的字节数组
     * @return 序列化后的对象
     * @throws IOException io exception
     */
    public static Object deserializeSlightly(byte[] bytes) {
        if (bytes == null || bytes.length == 0)
            return null;
        try {
            return g_serializer.deserialize(bytes);
        } catch (IOException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        }
    }

    /**
     * 反序列化
     *
     * @param obj 待反序列化的对象
     * @return 序列化后的对象
     * @throws IOException io exception
     */
    public static Object deserialize(Object obj) throws IOException {
        if (obj == null)
            return null;
        return g_serializer.deserialize(toByteArray(obj));
    }

    /**
     * obj转byte[]
     *
     * @param obj
     * @return
     */
    public static byte[] toByteArray(Object obj) {
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
            oos.close();
            bos.close();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
        return bytes;
    }
}
