package com.ohaotian.plugin.common.util;

import java.util.regex.Pattern;

/**
 * @Description TODO
 * @Author zhanghaishen
 * @Date 2023/4/21
 * @Project com.ohaotian.plugin.common.util
 */
public class RegexUtils {
    /**
     * 将通配符表达式转化为正则表达式
     * @param path
     * @return
     */
    public static String getRegPath(String path) {
        char[] chars = path.toCharArray();
        int len = chars.length;
        StringBuilder sb = new StringBuilder();
        boolean preX = false;
        for(int i=0;i<len;i++){
            if (chars[i] == '*'){//遇到*字符
                if (preX){//如果是第二次遇到*，则将**替换成.*
                    sb.append(".*");
                    preX = false;
                }else if(i+1 == len){//如果是遇到单星，且单星是最后一个字符，则直接将*转成[^/]*
                    sb.append("[^/]*");
                }else{//否则单星后面还有字符，则不做任何动作，下一把再做动作
                    preX = true;
                    continue;
                }
            }else{//遇到非*字符
                if (preX){//如果上一把是*，则先把上一把的*对应的[^/]*添进来
                    sb.append("[^/]*");
                    preX = false;
                }
                if (chars[i] == '?'){//接着判断当前字符是不是?，是的话替换成.
                    sb.append('.');
                }else{//不是?的话，则就是普通字符，直接添进来
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }
    /**
     * 通配符模式
     * @param whitePath - 白名单地址
     * @param reqPath - 请求地址
     * @return
     */
    public static boolean wildcardEquals(String whitePath, String reqPath) {
        String regPath = RegexUtils.getRegPath(whitePath);
        return Pattern.compile(regPath).matcher(reqPath).matches();
    }
}
