package com.ohaotian.plugin.common.interceptor;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Response;
import feign.codec.ErrorDecoder;
import org.springframework.context.annotation.Configuration;
import com.ohaotian.plugin.base.exception.InternalException;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

@Configuration
public class ExceptionErrorDecoder implements ErrorDecoder {
    ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public Exception decode(String s, Response response) {
        String errorMsg = null;
        if (response.headers().get("errorMsg") != null){
            try {
                errorMsg = URLDecoder.decode(response.headers().get("errorMsg").toString(),"utf-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return new InternalException(errorMsg);
        }

        return new InternalException("系统异常,请联系管理员");
    }
}