/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.common.util;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSAUtil {
    private static final byte[] base64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final char[] intToBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public static void main(String[] args) throws Exception {
        RSAUtil.genKeyPair("abcd");
        String \u516c\u94a5 = "MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAOQKOgqjMUeMGZz/U6Ke2IFDITTyIYdA/Ekah1aEdieyDEIys8c4l5lVPTObBNbDYopggoE5YG02e5I11sIPTMcCAwEAAQ==";
        String \u79c1\u94a5 = "MIIBVQIBADANBgkqhkiG9w0BAQEFAASCAT8wggE7AgEAAkEA5Ao6CqMxR4wZnP9Top7YgUMhNPIhh0D8SRqHVoR2J7IMQjKzxziXmVU9M5sE1sNiimCCgTlgbTZ7kjXWwg9MxwIDAQABAkB17eP+RE7j1UwZqOEzpDoK/xBZNS6pp63QkGuVDoOcGrnB22y93pzhXhzpCvPu3oa4gndK6VbZfzMQHmNB6OthAiEA+LyUwpN1UlAXlinysuKnqqeIqrQmKL9EFl3piJ9sjI0CIQDqsu2vv+268CYCG6K5JkZG/C7zSPnyE3q3ByXg0fbLowIhAMCK4jCYiunT294+zINS1m1Q0IcreppyLFeQDNXYauOFAiBnbJHxcNKCHnGhXCxJCuTNQzQtYWtDkfHx1eSLPftToQIhAIY5ec8G7ojhE7R6zZDElJTk2gnqB4J3tCkYY6gHZDdV";
        String rasPwd = RSAUtil.encrypt(\u79c1\u94a5, "1234abcd");
        System.out.println("\u5bc6\u6587\uff1a" + rasPwd);
        String srcPwd = RSAUtil.decrypt(\u516c\u94a5, rasPwd);
        System.out.println("\u660e\u6587\uff1a" + srcPwd);
    }

    public static String decrypt(String publicKeyText, String cipherText) throws Exception {
        PublicKey publicKey = RSAUtil.getPublicKey(publicKeyText);
        return RSAUtil.decrypt(publicKey, cipherText);
    }

    public static String decrypt(PublicKey publicKey, String cipherText) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        try {
            cipher.init(2, publicKey);
        }
        catch (InvalidKeyException var7) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            RSAPrivateKeySpec spec = new RSAPrivateKeySpec(rsaPublicKey.getModulus(), rsaPublicKey.getPublicExponent());
            PrivateKey fakePrivateKey = KeyFactory.getInstance("RSA").generatePrivate(spec);
            cipher = Cipher.getInstance("RSA");
            cipher.init(2, fakePrivateKey);
        }
        if (cipherText != null && cipherText.length() != 0) {
            byte[] cipherBytes = RSAUtil.base64ToByteArray(cipherText);
            byte[] plainBytes = cipher.doFinal(cipherBytes);
            return new String(plainBytes);
        }
        return cipherText;
    }

    public static PublicKey getPublicKey(String publicKeyText) {
        try {
            byte[] publicKeyBytes = RSAUtil.base64ToByteArray(publicKeyText);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(publicKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "SunRsaSign");
            return keyFactory.generatePublic(x509KeySpec);
        }
        catch (Exception var4) {
            throw new IllegalArgumentException("Failed to get public key", var4);
        }
    }

    public static void genKeyPair(String password) throws Exception {
        String[] arr = RSAUtil.genKeyPair(512);
        System.out.println("publicKey:" + arr[1]);
        System.out.println("password:" + RSAUtil.encrypt(arr[0], password));
    }

    private static String[] genKeyPair(int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        byte[][] keyPairBytes = RSAUtil.genKeyPairBytes(keySize);
        String[] keyPairs = new String[]{RSAUtil.byteArrayToBase64(keyPairBytes[0]), RSAUtil.byteArrayToBase64(keyPairBytes[1])};
        return keyPairs;
    }

    public static byte[][] genKeyPairBytes(int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        byte[][] keyPairBytes = new byte[2][];
        KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA", "SunRsaSign");
        gen.initialize(keySize, new SecureRandom());
        KeyPair pair = gen.generateKeyPair();
        keyPairBytes[0] = pair.getPrivate().getEncoded();
        keyPairBytes[1] = pair.getPublic().getEncoded();
        return keyPairBytes;
    }

    public static String encrypt(String key, String plainText) throws Exception {
        byte[] keyBytes = RSAUtil.base64ToByteArray(key);
        return RSAUtil.encrypt(keyBytes, plainText);
    }

    public static String encrypt(byte[] keyBytes, String plainText) throws Exception {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory factory = KeyFactory.getInstance("RSA", "SunRsaSign");
        PrivateKey privateKey = factory.generatePrivate(spec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        try {
            cipher.init(1, privateKey);
        }
        catch (InvalidKeyException var10) {
            RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)privateKey;
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(rsaPrivateKey.getModulus(), rsaPrivateKey.getPrivateExponent());
            PublicKey fakePublicKey = KeyFactory.getInstance("RSA").generatePublic(publicKeySpec);
            cipher = Cipher.getInstance("RSA");
            cipher.init(1, fakePublicKey);
        }
        byte[] encryptedBytes = cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8));
        String encryptedString = RSAUtil.byteArrayToBase64(encryptedBytes);
        return encryptedString;
    }

    private static byte[] base64ToByteArray(String s) {
        byte[] alphaToInt = base64ToInt;
        int sLen = s.length();
        int numGroups = sLen / 4;
        if (4 * numGroups != sLen) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int missingBytesInLastGroup = 0;
        int numFullGroups = numGroups;
        if (sLen != 0) {
            if (s.charAt(sLen - 1) == '=') {
                ++missingBytesInLastGroup;
                --numFullGroups;
            }
            if (s.charAt(sLen - 2) == '=') {
                ++missingBytesInLastGroup;
            }
        }
        byte[] result = new byte[3 * numGroups - missingBytesInLastGroup];
        int inCursor = 0;
        int outCursor = 0;
        for (int i = 0; i < numFullGroups; ++i) {
            int ch0 = RSAUtil.base64toInt(s.charAt(inCursor++), alphaToInt);
            int ch1 = RSAUtil.base64toInt(s.charAt(inCursor++), alphaToInt);
            int ch2 = RSAUtil.base64toInt(s.charAt(inCursor++), alphaToInt);
            int ch3 = RSAUtil.base64toInt(s.charAt(inCursor++), alphaToInt);
            result[outCursor++] = (byte)(ch0 << 2 | ch1 >> 4);
            result[outCursor++] = (byte)(ch1 << 4 | ch2 >> 2);
            result[outCursor++] = (byte)(ch2 << 6 | ch3);
        }
        if (missingBytesInLastGroup != 0) {
            int ch0 = RSAUtil.base64toInt(s.charAt(inCursor++), alphaToInt);
            int ch1 = RSAUtil.base64toInt(s.charAt(inCursor++), alphaToInt);
            result[outCursor++] = (byte)(ch0 << 2 | ch1 >> 4);
            if (missingBytesInLastGroup == 1) {
                int ch2 = RSAUtil.base64toInt(s.charAt(inCursor++), alphaToInt);
                result[outCursor++] = (byte)(ch1 << 4 | ch2 >> 2);
            }
        }
        return result;
    }

    private static String byteArrayToBase64(byte[] a) {
        int aLen = a.length;
        int numFullGroups = aLen / 3;
        int numBytesInPartialGroup = aLen - 3 * numFullGroups;
        int resultLen = 4 * ((aLen + 2) / 3);
        StringBuilder result = new StringBuilder(resultLen);
        char[] intToAlpha = intToBase64;
        int inCursor = 0;
        for (int i = 0; i < numFullGroups; ++i) {
            int byte0 = a[inCursor++] & 0xFF;
            int byte1 = a[inCursor++] & 0xFF;
            int byte2 = a[inCursor++] & 0xFF;
            result.append(intToAlpha[byte0 >> 2]);
            result.append(intToAlpha[byte0 << 4 & 0x3F | byte1 >> 4]);
            result.append(intToAlpha[byte1 << 2 & 0x3F | byte2 >> 6]);
            result.append(intToAlpha[byte2 & 0x3F]);
        }
        if (numBytesInPartialGroup != 0) {
            int byte0 = a[inCursor++] & 0xFF;
            result.append(intToAlpha[byte0 >> 2]);
            if (numBytesInPartialGroup == 1) {
                result.append(intToAlpha[byte0 << 4 & 0x3F]);
                result.append("==");
            } else {
                int byte1 = a[inCursor++] & 0xFF;
                result.append(intToAlpha[byte0 << 4 & 0x3F | byte1 >> 4]);
                result.append(intToAlpha[byte1 << 2 & 0x3F]);
                result.append('=');
            }
        }
        return result.toString();
    }

    private static int base64toInt(char c, byte[] alphaToInt) {
        byte result = alphaToInt[c];
        if (result < 0) {
            throw new IllegalArgumentException("Illegal character " + c);
        }
        return result;
    }
}

